/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.ejb.session;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.ScheduleInfo;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerUtil;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementUtil;
import com.clustercontrol.jobmanagement.factory.HistoryFilterProperty;
import com.clustercontrol.jobmanagement.factory.JobOperationProperty;
import com.clustercontrol.jobmanagement.factory.ModifyJob;
import com.clustercontrol.jobmanagement.factory.ModifySchedule;
import com.clustercontrol.jobmanagement.factory.SelectJob;
import com.clustercontrol.jobmanagement.factory.SelectRunSchedule;
import com.clustercontrol.jobmanagement.factory.SelectSchedule;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class JobControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(JobControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public ArrayList getHistoryTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 0, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"end.status", (Locale)locale), 11, 80, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"end.value", (Locale)locale), -1, 50, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"session.id", (Locale)locale), -1, 140, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"job.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"job.name", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"type", (Locale)locale), 1, 110, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 150, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"scheduled.start.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(10, new TableColumnInfo(Messages.getString((String)"start.rerun.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(11, new TableColumnInfo(Messages.getString((String)"end.suspend.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getDetailTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo("", -1, 30, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 0, 80, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"end.status", (Locale)locale), 11, 80, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"end.value", (Locale)locale), -1, 50, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"job.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"job.name", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"type", (Locale)locale), 1, 110, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 150, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"wait.rule.time", (Locale)locale), -1, 120, 16384));
        tableDefine.add(10, new TableColumnInfo(Messages.getString((String)"start.rerun.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(11, new TableColumnInfo(Messages.getString((String)"end.suspend.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getJobTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"job.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"job.name", (Locale)locale), -1, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"type", (Locale)locale), 1, 110, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 150, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"wait.rule", (Locale)locale), 9, 120, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getNodeDetailTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 0, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"return.value", (Locale)locale), -1, 50, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"facility.name", (Locale)locale), 2, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"start.rerun.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"end.suspend.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"message", (Locale)locale), -1, 300, 16384));
        return tableDefine;
    }

    public ArrayList getScheduleTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"schedule.id", (Locale)locale), -1, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"schedule.name", (Locale)locale), -1, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"job.id", (Locale)locale), -1, 80, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"job.name", (Locale)locale), -1, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"calendar.id", (Locale)locale), -1, 80, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"schedule", (Locale)locale), 7, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"valid", (Locale)locale) + "/" + Messages.getString((String)"invalid", (Locale)locale), 4, 100, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(10, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getRunScheduleListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"schedule.id", (Locale)locale), -1, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"schedule.name", (Locale)locale), -1, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"job.id", (Locale)locale), -1, 80, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"job.name", (Locale)locale), -1, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"calendar.id", (Locale)locale), -1, 80, 16384));
        tableDefine.add(5, new TableColumnInfo("", 15, 0, 16384));
        return tableDefine;
    }

    public ArrayList getRunScheduleDetailListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo("", -1, 30, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"job.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"job.name", (Locale)locale), -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"type", (Locale)locale), 1, 110, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"calendar.id", (Locale)locale), -1, 80, 16384));
        return tableDefine;
    }

    public ArrayList getRunScheduleTableDefine(Date base, Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo("", -1, 0, 16384));
        for (int i = 0; i < 28; ++i) {
            Calendar baseCalendar = Calendar.getInstance();
            baseCalendar.setTime(base);
            baseCalendar.add(5, i);
            Date work = baseCalendar.getTime();
            tableDefine.add(i + 1, new TableColumnInfo(DateFormat.getDateInstance(3, locale).format(work), 17, 70, 16384));
        }
        return tableDefine;
    }

    public ArrayList getRunScheduleDetailTableDefine(Date base, Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo("", -1, 0, 16384));
        tableDefine.add(1, new TableColumnInfo("", -1, 0, 16384));
        for (int i = 0; i < 28; ++i) {
            Calendar baseCalendar = Calendar.getInstance();
            baseCalendar.setTime(base);
            baseCalendar.add(5, i);
            Date work = baseCalendar.getTime();
            tableDefine.add(i + 2, new TableColumnInfo(DateFormat.getDateInstance(3, locale).format(work), 17, 70, 16384));
        }
        return tableDefine;
    }

    public ArrayList getForwardFileTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 0, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"end.status", (Locale)locale), 11, 80, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"file", (Locale)locale), -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"forward.source", (Locale)locale) + Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"forward.source", (Locale)locale) + Messages.getString((String)"facility.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"forward.destination", (Locale)locale) + Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"forward.destination", (Locale)locale) + Messages.getString((String)"facility.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"start.rerun.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"end.suspend.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public Property getHistoryFilterProperty(Locale locale) {
        HistoryFilterProperty history = new HistoryFilterProperty();
        return history.getProperty(locale);
    }

    public String getSeparator() {
        return ">";
    }

    public JobTreeItem getJobTree(boolean treeOnly, Locale locale) throws FinderException, NamingException {
        m_log.debug((Object)("getJobTree() : treeOnly=" + treeOnly + ", locale=" + locale));
        SelectJob select = new SelectJob();
        JobTreeItem item = select.getJobTree(treeOnly, locale);
        return item;
    }

    public JobTreeItem getJobTreeOneLevel(String parentJobId, Locale locale) throws FinderException, NamingException {
        m_log.debug((Object)("getJobTreeOneLevel() : parentJobId=" + parentJobId + ", locale=" + locale));
        SelectJob select = new SelectJob();
        JobTreeItem item = select.getJobTreeOneLevel(parentJobId, locale);
        return item;
    }

    public void registerJob(JobTreeItem item) throws FinderException, NamingException, RemoveException, CreateException {
        m_log.debug((Object)"registerJob()");
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyJob modify = new ModifyJob();
        try {
            modify.registerJob(item, pri.getName());
        }
        catch (FinderException e) {
            m_log.debug((Object)("registerJob() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("registerJob() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            m_log.debug((Object)("registerJob() : " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            m_log.debug((Object)("registerJob() : " + e.getMessage()));
            throw e;
        }
    }

    public Property getStartProperty(String sessionId, String jobId, String facilityId, Locale locale) {
        JobOperationProperty jobPropaerty = new JobOperationProperty();
        return jobPropaerty.getStartProperty(sessionId, jobId, facilityId, locale);
    }

    public Property getStopProperty(String sessionId, String jobId, String facilityId, Locale locale) {
        JobOperationProperty jobPropaerty = new JobOperationProperty();
        return jobPropaerty.getStopProperty(sessionId, jobId, facilityId, locale);
    }

    public void runJob(String jobId) throws CreateException, FinderException, NamingException {
        m_log.debug((Object)("runJob() : jobId=" + jobId));
        JobControllerLocal jobController = JobControllerUtil.getLocalHome().create();
        String sessionId = null;
        try {
            sessionId = jobController.createJobInfo(jobId, null);
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{jobId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{jobId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{jobId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
        JobRunManagementLocal JobRunManagement2 = JobRunManagementUtil.getLocalHome().create();
        try {
            JobRunManagement2.runJob(sessionId, jobId);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{sessionId, jobId};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{sessionId, jobId};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
    }

    public void runJob(String jobId, LogOutputInfo info) throws CreateException, FinderException, NamingException {
        m_log.debug((Object)("runJob() : jobId=" + jobId));
        JobControllerLocal jobController = JobControllerUtil.getLocalHome().create();
        String sessionId = null;
        try {
            sessionId = jobController.createJobInfo(jobId, info);
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{jobId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{jobId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{jobId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
        JobRunManagementLocal JobRunManagement2 = JobRunManagementUtil.getLocalHome().create();
        try {
            JobRunManagement2.runJob(sessionId, jobId);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{sessionId, jobId};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{sessionId, jobId};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("runJob() : " + e.getMessage()));
            throw e;
        }
    }

    public void scheduleRunJob(String jobId, String calendarId) throws CreateException, FinderException, NamingException {
        m_log.debug((Object)("runJob() : jobId=" + jobId + ", calendarId=" + calendarId));
        boolean check = false;
        if (calendarId != null && calendarId.length() > 0) {
            try {
                CalendarControllerLocal calendar = CalendarControllerUtil.getLocalHome().create();
                if (calendar.isRun(calendarId, new Date()).booleanValue()) {
                    check = true;
                }
            }
            catch (CreateException e) {
            }
            catch (NamingException e) {}
        } else {
            check = true;
        }
        if (!check) {
            return;
        }
        this.runJob(jobId);
    }

    public String createJobInfo(String jobId, LogOutputInfo info) throws CreateException, FinderException, NamingException {
        m_log.debug((Object)("createJobInfo() : jobId=" + jobId));
        return JobSessionUtil.getLocalHome().makeSession(jobId, info);
    }

    public void operationJob(Property property) throws FinderException, CreateException, NamingException {
        m_log.debug((Object)"operationJob()");
        JobRunManagementLocal JobRunManagement2 = JobRunManagementUtil.getLocalHome().create();
        JobRunManagement2.operationJob(property);
    }

    public ArrayList getHistoryList() throws FinderException, NamingException {
        m_log.debug((Object)"getHistoryList()");
        SelectJob select = new SelectJob();
        ArrayList list = select.getHistoryList();
        return list;
    }

    public ArrayList getHistoryList(Property property) throws FinderException, NamingException {
        m_log.debug((Object)"getHistoryList()");
        SelectJob select = new SelectJob();
        ArrayList list = select.getHistoryList(property);
        return list;
    }

    public CommonTableTreeItem getDetailList(String sessionId) throws FinderException, NamingException {
        m_log.debug((Object)("getDetailList() : sessionId=" + sessionId));
        SelectJob select = new SelectJob();
        CommonTableTreeItem item = select.getDetailList(sessionId);
        return item;
    }

    public ArrayList getNodeDetailList(String sessionId, String jobId, Locale locale) throws FinderException, NamingException, CreateException {
        m_log.debug((Object)("getNodeDetailList() : sessionId=" + sessionId + ", jobId=" + jobId));
        SelectJob select = new SelectJob();
        ArrayList list = select.getNodeDetailList(sessionId, jobId, locale);
        return list;
    }

    public ArrayList getForwardFileList(String sessionId, String jobId) throws FinderException, NamingException, CreateException {
        m_log.debug((Object)("getNodeDetailList() : sessionId=" + sessionId + ", jobId=" + jobId));
        SelectJob select = new SelectJob();
        ArrayList list = select.getForwardFileList(sessionId, jobId);
        return list;
    }

    public void addSchedule(ScheduleInfo info) throws ParseException, NamingException, SchedulerException {
        m_log.debug((Object)("addSchedule() : scheduleId=" + info.getId()));
        Principal pri = this.m_context.getCallerPrincipal();
        ModifySchedule modify = new ModifySchedule();
        try {
            modify.addSchedule(info, pri.getName());
        }
        catch (ParseException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{info.getId(), info.getJobId()};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addSchedule() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{info.getId(), info.getJobId()};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addSchedule() : " + e.getMessage()));
            throw e;
        }
        catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{info.getId(), info.getJobId()};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addSchedule() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifySchedule(ScheduleInfo info) throws NamingException, SchedulerException, ParseException {
        m_log.debug((Object)("modifySchedule() : scheduleId=" + info.getId()));
        Principal pri = this.m_context.getCallerPrincipal();
        ModifySchedule modify = new ModifySchedule();
        try {
            modify.modifySchedule(info, pri.getName());
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifySchedule() : " + e.getMessage()));
            throw e;
        }
        catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifySchedule() : " + e.getMessage()));
            throw e;
        }
        catch (ParseException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifySchedule() : " + e.getMessage()));
            throw e;
        }
    }

    public void deleteSchedule(String scheduleId) throws NamingException, SchedulerException {
        m_log.debug((Object)("deleteSchedule() : scheduleId=" + scheduleId));
        ModifySchedule modify = new ModifySchedule();
        try {
            modify.deleteSchedule(scheduleId);
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{scheduleId};
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("deleteSchedule() : " + e.getMessage()));
            throw e;
        }
        catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            Object[] args = new String[]{scheduleId};
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("deleteSchedule() : " + e.getMessage()));
            throw e;
        }
    }

    public ArrayList getScheduleList() throws NamingException, SchedulerException {
        m_log.debug((Object)"getScheduleList()");
        SelectSchedule select = new SelectSchedule();
        ArrayList list = select.getScheduleList();
        return list;
    }

    public ArrayList getRunScheduleList() throws NamingException, SchedulerException {
        m_log.debug((Object)"getRunScheduleList()");
        SelectRunSchedule select = new SelectRunSchedule();
        ArrayList list = select.getList();
        return list;
    }

    public ArrayList getRunSchedule(Date base) throws NamingException, SchedulerException, FinderException {
        m_log.debug((Object)("getRunSchedule() : base=" + base));
        SelectRunSchedule select = new SelectRunSchedule();
        ArrayList list = select.getSchedule(base);
        return list;
    }

    public CommonTableTreeItem getRunScheduleDetailList(String scheduleId) throws NamingException, FinderException, SchedulerException {
        m_log.debug((Object)("getRunScheduleDetailList() : scheduleId=" + scheduleId));
        SelectRunSchedule select = new SelectRunSchedule();
        CommonTableTreeItem item = select.getDetailList(scheduleId);
        return item;
    }

    public CommonTableTreeItem getRunScheduleDetail(String scheduleId, Date base) throws FinderException, NamingException, SchedulerException {
        m_log.debug((Object)("getRunScheduleDetail() : scheduleId=" + scheduleId + ", base=" + base));
        SelectRunSchedule select = new SelectRunSchedule();
        CommonTableTreeItem item = select.getDetailSchedule(scheduleId, base);
        return item;
    }

    public ArrayList getCalendarIdList() throws CreateException, NamingException, FinderException {
        m_log.debug((Object)"getCalendarIdList()");
        CalendarControllerLocal calendar = CalendarControllerUtil.getLocalHome().create();
        ArrayList list = calendar.getCalendarIdList();
        return list;
    }

    public JobTreeItem getSessionJobInfo(String sessionId, String jobId) throws NamingException, FinderException {
        m_log.debug((Object)("getSessionJobInfo() : sessionId=" + sessionId + ", jobId=" + jobId));
        SelectJob select = new SelectJob();
        JobTreeItem item = select.getSessionJobInfo(sessionId, jobId);
        return item;
    }
}

