/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.bean.EndStatusColorConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.EndStatusInfo;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.MasterInfoModifyListener;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class CommandComposite
extends Composite {
    private Text id = null;
    private Text name = null;
    private Button typeCommand = null;
    private Button typeScript = null;
    private Text command = null;
    private Text normalFrom = null;
    private Text normalTo = null;
    private Text warningFrom = null;
    private Text warningTo = null;
    private TreeItem selectItem = null;
    private TreeComposite composite = null;

    public CommandComposite(Composite parent, int style, TreeComposite composite) {
        super(parent, style);
        this.composite = composite;
        this.selectItem = composite.getSelectItem();
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(10, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        GridData gridData = null;
        Label label = null;
        Group group = new Group((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString((String)"command"));
        layout = new GridLayout(10, true);
        group.setLayout((Layout)layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"command.id")) + " : ");
        this.id = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.id.setLayoutData((Object)gridData);
        this.id.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"name")) + " : ");
        this.name = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.name.setLayoutData((Object)gridData);
        this.name.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"type")) + " : ");
        this.typeCommand = new Button((Composite)group, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.typeCommand.setLayoutData((Object)gridData);
        this.typeCommand.setText(Messages.getString((String)"command"));
        this.typeScript = new Button((Composite)group, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.typeScript.setLayoutData((Object)gridData);
        this.typeScript.setText(Messages.getString((String)"script"));
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"command")) + " : ");
        this.command = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.command.setLayoutData((Object)gridData);
        this.command.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        Group endStatusGroup = new Group((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        endStatusGroup.setLayoutData((Object)gridData);
        endStatusGroup.setText(Messages.getString((String)"end.status"));
        layout = new GridLayout(10, true);
        endStatusGroup.setLayout((Layout)layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        label = new Label((Composite)endStatusGroup, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)endStatusGroup, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"range.end.value"));
        label = new Label((Composite)endStatusGroup, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(EndStatusConstant.STRING_NORMAL) + " : ");
        label.setBackground(EndStatusColorConstant.COLOR_NORMAL);
        label = new Label((Composite)endStatusGroup, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.normalFrom = new Text((Composite)endStatusGroup, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.normalFrom.setLayoutData((Object)gridData);
        this.normalFrom.addVerifyListener((VerifyListener)new NumberVerifyListener());
        this.normalFrom.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        label = new Label((Composite)endStatusGroup, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setText("\u301c");
        label.setLayoutData((Object)gridData);
        this.normalTo = new Text((Composite)endStatusGroup, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.normalTo.setLayoutData((Object)gridData);
        this.normalTo.addVerifyListener((VerifyListener)new NumberVerifyListener());
        this.normalTo.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        label = new Label((Composite)endStatusGroup, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(EndStatusConstant.STRING_WARNING) + " : ");
        label.setBackground(EndStatusColorConstant.COLOR_WARNING);
        label = new Label((Composite)endStatusGroup, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.warningFrom = new Text((Composite)endStatusGroup, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.warningFrom.setLayoutData((Object)gridData);
        this.warningFrom.addVerifyListener((VerifyListener)new NumberVerifyListener());
        this.warningFrom.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        label = new Label((Composite)endStatusGroup, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setText("\u301c");
        label.setLayoutData((Object)gridData);
        this.warningTo = new Text((Composite)endStatusGroup, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.warningTo.setLayoutData((Object)gridData);
        this.warningTo.addVerifyListener((VerifyListener)new NumberVerifyListener());
        this.warningTo.addModifyListener((ModifyListener)new MasterInfoModifyListener(this.composite));
        label = new Label((Composite)endStatusGroup, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(EndStatusConstant.STRING_ABNORMAL) + " : ");
        label.setBackground(EndStatusColorConstant.COLOR_ABNORMAL);
        label = new Label((Composite)endStatusGroup, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)endStatusGroup, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        label.setText(Messages.getString((String)"other"));
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        label.setLayoutData((Object)gridData);
        Button buttonCreate = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonCreate.setLayoutData((Object)gridData);
        buttonCreate.setText(Messages.getString((String)"apply"));
        buttonCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidateResult result = CommandComposite.this.validate();
                if (result != null) {
                    CommandComposite.this.displayError(result);
                }
            }
        });
        this.setEnabled();
        this.update();
    }

    public void setEnabled() {
        if (this.composite.getCreateItem() == null) {
            this.id.setEnabled(false);
        } else {
            this.id.setEnabled(true);
        }
    }

    public void update() {
        if (this.selectItem instanceof TreeItem && this.selectItem.getInfo() instanceof CommandInfo) {
            CommandInfo info = (CommandInfo)this.selectItem.getInfo();
            if (info.getId() != null) {
                this.id.setText(info.getId());
            }
            if (info.getName() != null) {
                this.name.setText(info.getName());
            }
            if (info.getCommandType() == 0) {
                this.typeCommand.setSelection(true);
            } else {
                this.typeScript.setSelection(true);
            }
            if (info.getCommand() != null) {
                this.command.setText(info.getCommand());
            }
            if (info.getEndStatus() != null && info.getEndStatus() instanceof ArrayList) {
                int i = 0;
                while (i < info.getEndStatus().size()) {
                    EndStatusInfo endstatus = (EndStatusInfo)info.getEndStatus().get(i);
                    if (endstatus != null) {
                        if (endstatus.getEndStatus() == 0) {
                            this.normalFrom.setText(String.valueOf(endstatus.getStartRangeValue()));
                            this.normalTo.setText(String.valueOf(endstatus.getEndRangeValue()));
                        } else if (endstatus.getEndStatus() == 1) {
                            this.warningFrom.setText(String.valueOf(endstatus.getStartRangeValue()));
                            this.warningTo.setText(String.valueOf(endstatus.getEndRangeValue()));
                        }
                    }
                    ++i;
                }
            }
        }
        this.composite.setUpdateItem(null);
    }

    public ValidateResult createCommandInfo() {
        ValidateResult result = null;
        if (this.selectItem instanceof TreeItem && this.selectItem.getInfo() instanceof CommandInfo) {
            CommandInfo info = (CommandInfo)this.selectItem.getInfo();
            CommandInfo cloneInfo = (CommandInfo)info.clone();
            ItemInfo parentInfo = this.selectItem.getParent().getInfo();
            if (this.id.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.collective.run.4"));
                return result;
            }
            cloneInfo.setId(this.id.getText());
            if (this.id.isEnabled() && TreeItemUtil.findId((String)cloneInfo.getId(), (TreeItem)this.selectItem.getParent())) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                Object[] args = new String[]{Messages.getString((String)"command.id"), cloneInfo.getId()};
                result.setMessage(Messages.getString((String)"message.collective.run.16", (Object[])args));
                return result;
            }
            if (this.name.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.collective.run.3"));
                return result;
            }
            cloneInfo.setName(this.name.getText());
            if (this.command.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.collective.run.5"));
                return result;
            }
            cloneInfo.setCommand(this.command.getText());
            if (this.typeCommand.getSelection()) {
                cloneInfo.setCommandType(0);
            } else {
                cloneInfo.setCommandType(1);
            }
            ArrayList<EndStatusInfo> list = new ArrayList<EndStatusInfo>();
            EndStatusInfo endstatus = new EndStatusInfo();
            endstatus.setEndStatus(0);
            try {
                endstatus.setStartRangeValue(Integer.parseInt(this.normalFrom.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.8"));
                return result;
            }
            try {
                endstatus.setEndRangeValue(Integer.parseInt(this.normalTo.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.9"));
                return result;
            }
            if (endstatus.getStartRangeValue() > endstatus.getEndRangeValue()) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.14"));
                return result;
            }
            list.add(endstatus);
            if (this.warningFrom.getText().length() > 0 && this.warningTo.getText().length() > 0) {
                endstatus = new EndStatusInfo();
                endstatus.setEndStatus(1);
                try {
                    endstatus.setStartRangeValue(Integer.parseInt(this.warningFrom.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.job.11"));
                    return result;
                }
                try {
                    endstatus.setEndRangeValue(Integer.parseInt(this.warningTo.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.job.12"));
                    return result;
                }
                if (endstatus.getStartRangeValue() > endstatus.getEndRangeValue()) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.job.15"));
                    return result;
                }
                list.add(endstatus);
            }
            cloneInfo.setEndStatus(list);
            ModifyMaster modify = new ModifyMaster();
            if (modify.update((ItemInfo)cloneInfo, parentInfo)) {
                this.selectItem.setInfo((ItemInfo)cloneInfo);
                this.composite.setCreateItem(null);
                this.composite.setUpdateItem(null);
                this.composite.getTreeViewer().refresh((Object)this.selectItem);
            } else {
                Object[] args = new Object[]{cloneInfo.getName()};
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.collective.run.12", (Object[])args));
            }
        }
        return null;
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createCommandInfo();
        if (result != null) {
            return result;
        }
        return null;
    }

    protected void displayError(ValidateResult result) {
        MessageBox messageBox = new MessageBox(this.getShell(), 40);
        messageBox.setText(result.getID());
        messageBox.setMessage(result.getMessage());
        messageBox.open();
    }

    public TreeItem getSelectItem() {
        return this.selectItem;
    }

    public void setSelectItem(TreeItem selectItem) {
        this.selectItem = selectItem;
    }
}

