/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.util.apllog.AplLogger;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class LdapConnectionManager {
    protected static Log m_log = LogFactory.getLog(LdapConnectionManager.class);
    private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    private static final String OBJECT_NAME = "user:name=TroubleDetection,service=TroubleDetectionService";
    private static final String OPERATION_NAME = "putMessage";
    private static boolean m_provider = false;
    private static boolean m_consumer = false;
    private static LdapConnectionManager m_instance = null;

    public static LdapConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new LdapConnectionManager();
        }
        return m_instance;
    }

    private LdapConnectionManager() {
    }

    public DirContext getDirContext() {
        InitialLdapContext ctx = null;
        try {
            InitialContext iniCtx = new InitialContext();
            ctx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/provider");
            if (m_consumer) {
                this.outputLog("LDAP03", "001");
            }
            m_provider = true;
            m_consumer = false;
        }
        catch (NamingException e) {
            m_log.debug((Object)("LdapConnectionManager() : LDAP Connection Error : " + e.getMessage()));
            try {
                InitialContext iniCtx = new InitialContext();
                ctx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/consumer");
                if (m_provider) {
                    this.outputLog("LDAP02", "001");
                }
                m_provider = false;
                m_consumer = true;
            }
            catch (NamingException e1) {
                m_log.debug((Object)("LdapConnectionManager() : LDAP Connection Error : " + e1.getMessage()));
            }
        }
        if (ctx == null) {
            AplLogger apllog = new AplLogger("REP", "rep");
            apllog.put("SYS", "001");
            if (m_provider) {
                this.outputLog("LDAP02", "002");
            } else {
                this.outputLog("LDAP03", "002");
            }
            m_provider = false;
            m_consumer = false;
        }
        return ctx;
    }

    public void setDirContext(DirContext ctx) {
    }

    private void outputLog(String monitorId, String messageId) {
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            Object[] args = new Object[]{monitorId, messageId};
            String[] signature = new String[]{String.class.getName(), String.class.getName()};
            server.invoke(name, OPERATION_NAME, args, signature);
        }
        catch (NamingException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (IOException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
    }
}

