/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.LdapExtLoginModule;

public class LdapLoginModule
extends LdapExtLoginModule {
    protected static Log log = LogFactory.getLog(LdapConnectionManager.class);
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private static final String BASE_CTX_DN = "baseCtxDN";
    private static final String BASE_FILTER_OPT = "baseFilter";
    private static final String ROLE_FILTER_OPT = "roleFilter";
    private static final String ROLE_RECURSION = "roleRecursion";
    private static final String DEFAULT_ROLE = "defaultRole";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SEARCH_SCOPE_OPT = "searchScope";
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword != null) {
            if (inputPassword.length() == 0) {
                boolean allowEmptyPasswords = true;
                String flag = (String)this.options.get("allowEmptyPasswords");
                if (flag != null) {
                    allowEmptyPasswords = Boolean.valueOf(flag);
                }
                if (!allowEmptyPasswords) {
                    log.trace((Object)"Rejecting empty password due to allowEmptyPasswords");
                    return false;
                }
            }
            try {
                String username = this.getUsername();
                isValid = this.createLdapInitContext(username, inputPassword);
                this.defaultRole();
                isValid = true;
            }
            catch (Exception e) {
                log.debug((Object)"Failed to validate password", (Throwable)e);
            }
        }
        return isValid;
    }

    private void defaultRole() {
        try {
            String defaultRole = (String)this.options.get(DEFAULT_ROLE);
            if (defaultRole == null || defaultRole.equals("")) {
                return;
            }
            Principal p = super.createIdentity(defaultRole);
            log.trace((Object)("Assign user to role " + defaultRole));
            this.userRoles.addMember(p);
        }
        catch (Exception e) {
            log.debug((Object)"could not add default role to user", (Throwable)e);
        }
    }

    private boolean createLdapInitContext(String username, Object credential) throws Exception {
        String scope;
        block12: {
            this.baseDN = (String)this.options.get(BASE_CTX_DN);
            this.baseFilter = (String)this.options.get(BASE_FILTER_OPT);
            this.roleFilter = (String)this.options.get(ROLE_FILTER_OPT);
            this.roleAttributeID = (String)this.options.get(ROLE_ATTRIBUTE_ID_OPT);
            if (this.roleAttributeID == null) {
                this.roleAttributeID = "role";
            }
            String roleAttributeIsDNOption = (String)this.options.get(ROLE_ATTRIBUTE_IS_DN_OPT);
            this.roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption);
            this.roleNameAttributeID = (String)this.options.get(ROLE_NAME_ATTRIBUTE_ID_OPT);
            if (this.roleNameAttributeID == null) {
                this.roleNameAttributeID = "name";
            }
            this.rolesCtxDN = (String)this.options.get(ROLES_CTX_DN_OPT);
            String strRecursion = (String)this.options.get(ROLE_RECURSION);
            try {
                this.recursion = Integer.parseInt(strRecursion);
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)("Failed to parse: " + strRecursion + ", disabling recursion"));
                }
                this.recursion = 0;
            }
            String timeLimit = (String)this.options.get(SEARCH_TIME_LIMIT_OPT);
            if (timeLimit != null) {
                try {
                    this.searchTimeLimit = Integer.parseInt(timeLimit);
                }
                catch (NumberFormatException e) {
                    if (!this.trace) break block12;
                    log.trace((Object)("Failed to parse: " + timeLimit + ", using searchTimeLimit=" + this.searchTimeLimit));
                }
            }
        }
        if ("OBJECT_SCOPE".equalsIgnoreCase(scope = (String)this.options.get(SEARCH_SCOPE_OPT))) {
            this.searchScope = 0;
        } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
            this.searchScope = 1;
        }
        if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
            this.searchScope = 2;
        }
        InitialLdapContext ctx = this.constructInitialLdapContext();
        String userDN = this.bindDNAuthentication(ctx, username, credential, this.baseDN, this.baseFilter);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(this.searchScope);
        constraints.setReturningAttributes(new String[0]);
        constraints.setTimeLimit(this.searchTimeLimit);
        this.rolesSearch(ctx, constraints, username, userDN, this.recursion, 0);
        ctx.close();
        return true;
    }

    protected String bindDNAuthentication(InitialLdapContext ctx, String user, Object credential, String baseDN, String filter) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setReturningAttributes(new String[0]);
        constraints.setTimeLimit(this.searchTimeLimit);
        NamingEnumeration<SearchResult> results = null;
        Object[] filterArgs = new Object[]{user};
        results = ctx.search(baseDN, filter, filterArgs, constraints);
        if (!results.hasMore()) {
            throw new NamingException("Search of baseDN(" + baseDN + ") found no matches");
        }
        SearchResult sr = results.next();
        String name = sr.getName();
        String userDN = null;
        if (!sr.isRelative()) {
            throw new NamingException("Can't follow referal for authentication: " + name);
        }
        userDN = name + "," + baseDN;
        Attributes attrs = ctx.getAttributes(userDN);
        byte[] passwordByte = (byte[])attrs.get("userPassword").get(0);
        try {
            String password = new String(passwordByte, "UTF-8");
            if (!password.equals(credential)) {
                throw new NamingException("Can't follow referal for authentication: " + name);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new NamingException("Can't follow referal for authentication: " + name);
        }
        results = null;
        return userDN;
    }

    private InitialLdapContext constructInitialLdapContext() throws NamingException {
        InitialLdapContext ctx = null;
        try {
            InitialContext iniCtx = new InitialContext();
            ctx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/provider");
        }
        catch (NamingException e) {
            log.debug((Object)("LDAP Connection Error : " + e.getMessage()));
            try {
                InitialContext iniCtx = new InitialContext();
                ctx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/consumer");
            }
            catch (NamingException e1) {
                log.debug((Object)("LDAP Connection Error : " + e1.getMessage()));
            }
        }
        return ctx;
    }
}

