/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class PointbaseDelegate
extends StdJDBCDelegate {
    public PointbaseDelegate(Log logger, String tablePrefix, String instanceId) {
        super(logger, tablePrefix, instanceId);
    }

    public PointbaseDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties) {
        super(logger, tablePrefix, instanceId, useProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int insertResult;
        block7: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            int len = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, job.getName());
                ps.setString(2, job.getGroup());
                ps.setString(3, job.getDescription());
                ps.setString(4, job.getJobClass().getName());
                ps.setBoolean(5, job.isDurable());
                ps.setBoolean(6, job.isVolatile());
                ps.setBoolean(7, job.isStateful());
                ps.setBoolean(8, job.requestsRecovery());
                ps.setBinaryStream(9, (InputStream)bais, len);
                insertResult = ps.executeUpdate();
                Object var9_8 = null;
                if (null == ps) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        String[] jobListeners = job.getJobListenerNames();
        int i = 0;
        while (jobListeners != null) {
            if (i >= jobListeners.length) {
                return insertResult;
            }
            this.insertJobListener(conn, job, jobListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int insertResult;
        block7: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            int len = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, job.getDescription());
                ps.setString(2, job.getJobClass().getName());
                ps.setBoolean(3, job.isDurable());
                ps.setBoolean(4, job.isVolatile());
                ps.setBoolean(5, job.isStateful());
                ps.setBoolean(6, job.requestsRecovery());
                ps.setBinaryStream(7, (InputStream)bais, len);
                ps.setString(8, job.getName());
                ps.setString(9, job.getGroup());
                insertResult = ps.executeUpdate();
                Object var9_8 = null;
                if (null == ps) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        this.deleteJobListeners(conn, job.getName(), job.getGroup());
        String[] jobListeners = job.getJobListenerNames();
        int i = 0;
        while (jobListeners != null) {
            if (i >= jobListeners.length) {
                return insertResult;
            }
            this.insertJobListener(conn, job, jobListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        int len = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setBinaryStream(1, (InputStream)bais, len);
            ps.setString(2, job.getName());
            ps.setString(3, job.getGroup());
            n = ps.executeUpdate();
            Object var9_8 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        byte[] buf = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
            ps.setString(1, calendarName);
            ps.setBinaryStream(2, (InputStream)bais, buf.length);
            n = ps.executeUpdate();
            Object var10_9 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        byte[] buf = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
            ps.setBinaryStream(1, (InputStream)bais, buf.length);
            ps.setString(2, calendarName);
            n = ps.executeUpdate();
            Object var10_9 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        Object obj = null;
        byte[] binaryData = rs.getBytes(colName);
        ByteArrayInputStream binaryInput = new ByteArrayInputStream(binaryData);
        if (null != binaryInput) {
            ObjectInputStream in = new ObjectInputStream(binaryInput);
            obj = in.readObject();
            in.close();
        }
        return obj;
    }

    protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            byte[] data = rs.getBytes(colName);
            ByteArrayInputStream binaryInput = new ByteArrayInputStream(data);
            return binaryInput;
        }
        return this.getObjectFromBlob(rs, colName);
    }
}

