/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.ejb.mdb;

import com.clustercontrol.collectiverun.factory.CommandExecutor;
import com.clustercontrol.collectiverun.message.CollectiveRunInstructionInfo;
import com.clustercontrol.collectiverun.util.SendQueue;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectiveRunExecuteBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(CollectiveRunExecuteBean.class);
    private static final String RSH = "rsh";
    private static final String SSH = "ssh";
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    public void onMessage(Message message) {
        Serializable obj;
        m_log.debug((Object)"onMessage start");
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                obj = objectMessage.getObject();
            }
            catch (JMSException e) {
                m_log.error((Object)"\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63", (Throwable)e);
                return;
            }
            if (!(obj instanceof CollectiveRunInstructionInfo)) {
                m_log.error((Object)("\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63" + obj.toString()));
                return;
            }
        } else {
            m_log.error((Object)("\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63" + message.getClass()));
            return;
        }
        m_log.debug((Object)"onMessage get RunInstructionInfo");
        CollectiveRunInstructionInfo info = (CollectiveRunInstructionInfo)((Object)obj);
        m_log.debug((Object)("onMessage SessionID=" + info.getSessionId() + ", FacilityID=" + info.getFacilityId()));
        this.exec(info);
        m_log.debug((Object)"onMessage end");
    }

    public void exec(CollectiveRunInstructionInfo instructionInfo) {
        m_log.debug((Object)("run start :" + instructionInfo.getFacilityId()));
        RunResultInfo resultInfo = new RunResultInfo();
        resultInfo.setSessionId(instructionInfo.getSessionId());
        resultInfo.setJobId(instructionInfo.getJobId());
        resultInfo.setFacilityId(instructionInfo.getFacilityId());
        resultInfo.setCommandType(instructionInfo.getCommandType());
        resultInfo.setStatus(0);
        resultInfo.setTime(new Date());
        m_log.info((Object)("run SessionID=" + instructionInfo.getSessionId() + ", JobID=" + instructionInfo.getJobId()));
        SendQueue send = null;
        try {
            send = new SendQueue("queue/clustercontrol/CollectiveRun/status");
            send.put(resultInfo);
        }
        catch (NamingException e1) {
            m_log.error((Object)e1);
        }
        catch (JMSException e1) {
            m_log.error((Object)e1);
        }
        String host = "";
        try {
            host = this.getRemoteHostName(instructionInfo.getFacilityId());
        }
        catch (Exception e) {
            resultInfo.setStatus(2);
            resultInfo.setTime(new Date());
            resultInfo.setErrorMessage(e.getMessage());
            try {
                send.put(resultInfo);
            }
            catch (NamingException e1) {
                m_log.error((Object)e1);
            }
            catch (JMSException e1) {
                m_log.error((Object)e1);
            }
            return;
        }
        String endValueStr = instructionInfo.getSessionId() + ":ret=";
        String[] cmd = new String[]{this.getRemoteExec(), host, "-l", "root", instructionInfo.getCommand() + ";echo " + endValueStr + "$?;read"};
        CommandExecutor executor = new CommandExecutor();
        boolean ret = executor.exec(cmd, instructionInfo.getInputFile(), endValueStr);
        int exitValue = executor.getExitValue();
        String resultMsg = executor.getResultMsg();
        boolean errFlg = true;
        if (ret && exitValue == 0) {
            String passwd;
            int idx = resultMsg.lastIndexOf(endValueStr);
            if (idx != -1) {
                String endValue = resultMsg.substring(idx + endValueStr.length(), resultMsg.length() - 1);
                m_log.debug((Object)endValue);
                exitValue = Integer.parseInt(endValue);
                m_log.debug((Object)("int:" + exitValue));
                resultMsg = resultMsg.substring(0, idx);
                errFlg = false;
            }
            if ((passwd = instructionInfo.getPassword()) != null) {
                resultMsg = resultMsg.replaceAll(passwd, "");
            }
        }
        if (errFlg) {
            resultInfo.setStatus(2);
        } else {
            resultInfo.setStatus(1);
            resultInfo.setEndValue(exitValue);
        }
        resultInfo.setTime(new Date());
        resultInfo.setErrorMessage(executor.getErrMsg());
        resultInfo.setMessage(resultMsg);
        try {
            send.put(resultInfo);
        }
        catch (NamingException e1) {
            m_log.error((Object)e1);
        }
        catch (JMSException e1) {
            m_log.error((Object)e1);
        }
        try {
            send.close();
        }
        catch (NamingException e1) {
            m_log.error((Object)e1);
        }
        catch (JMSException e1) {
            m_log.error((Object)e1);
        }
        m_log.debug((Object)("run end :" + instructionInfo.getFacilityId()));
    }

    private String getRemoteHostName(String facilityID) throws Exception {
        String host = null;
        RepositoryControllerLocal repository = null;
        try {
            repository = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> facilityAttrList = new ArrayList<String>();
            facilityAttrList.add("ccNodeName");
            facilityAttrList.add("ipNetworkNumber");
            HashMap facilityAttrMap = repository.getNodeDetail(facilityID, facilityAttrList);
            host = (String)facilityAttrMap.get("ipNetworkNumber");
            if ((host == null || host.length() == 0) && (host = (String)facilityAttrMap.get("ccNodeName")) == null) {
                host = "";
            }
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("\u30ea\u30e2\u30fc\u30c8\u5bfe\u8c61\u30db\u30b9\u30c8\uff1a" + host));
            }
        }
        catch (Exception e) {
            m_log.error((Object)e);
            throw e;
        }
        finally {
            try {
                if (repository != null) {
                    repository.remove();
                }
            }
            catch (Exception e) {}
        }
        return host;
    }

    public String getRemoteExec() {
        Properties properties = new Properties();
        String homedir = System.getProperty("jboss.server.home.dir");
        String propertyFile = homedir + File.separator + "conf" + File.separator + "collectiverun.properties";
        String remoteExec = RSH;
        try {
            properties.load(new FileInputStream(propertyFile));
            remoteExec = properties.getProperty("collective.run.shell", "");
            if (remoteExec.equalsIgnoreCase(RSH)) {
                remoteExec = RSH;
            } else if (remoteExec.equalsIgnoreCase(SSH)) {
                remoteExec = SSH;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return remoteExec;
    }
}

