/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.dao;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.RoleAttributeConstant;
import com.clustercontrol.accesscontrol.bean.UserAttributeConstant;
import com.clustercontrol.accesscontrol.ejb.entity.RoleBean;
import com.clustercontrol.accesscontrol.ejb.entity.RolePK;
import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * Role(BMP Entity Bean)DAO饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class RoleDAOImpl implements RoleDAO {
	protected static Log m_log = LogFactory.getLog( RoleDAOImpl.class );
	
	protected static final String OBJECTCLASS = "objectClass";
	protected static final String BASE_DN = "ou=roles";
	protected static final String OBJECT_CLASS_ROLE = "ccRole";

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#init()
	 */
	public void init() {
		
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#load(com.clustercontrol.accesscontrol.ejb.entity.RolePK, com.clustercontrol.accesscontrol.ejb.entity.RoleBean)
	 */
	public void load(RolePK pk, RoleBean ejb) throws EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			clearBean(ejb);
			
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(pk.getDn());
			
			//dn
			ejb.setDn(pk.getDn());
			//cn
			ejb.setCn((String)attrs.get(UserAttributeConstant.CN).get(0));
			//description
			if(attrs.get(RoleAttributeConstant.DESCRIPTION) != null){
				ejb.setDescription((String)attrs.get(RoleAttributeConstant.DESCRIPTION).get(0));
			}
			//ccCreateTimestamp
			if(attrs.get(RoleAttributeConstant.CREATETIMESTAMP) != null){
				ejb.setCreateTimestamp(stringToDate((String)attrs.get(RoleAttributeConstant.CREATETIMESTAMP).get(0)));
			}
			//ccCreatorsName
			if(attrs.get(RoleAttributeConstant.CREATORSNAME) != null){
				ejb.setCreatorsName((String)attrs.get(RoleAttributeConstant.CREATORSNAME).get(0));
			}
			//ccModifiersName
			if(attrs.get(RoleAttributeConstant.MODIFIERSNAME) != null){
				ejb.setModifiersName((String)attrs.get(RoleAttributeConstant.MODIFIERSNAME).get(0));
			}
			//ccModifyTimestamp
			if(attrs.get(RoleAttributeConstant.MODIFYTIMESTAMP) != null){
				ejb.setModifyTimestamp(stringToDate((String)attrs.get(RoleAttributeConstant.MODIFYTIMESTAMP).get(0)));
			}
			//member
			if(attrs.get(RoleAttributeConstant.MEMBER) != null){
				javax.naming.NamingEnumeration hosts = attrs.get(RoleAttributeConstant.MEMBER).getAll();
				ArrayList<String> memberList = new ArrayList<String>();
				while ( hosts.hasMoreElements() ) {
					String member = (String)hosts.nextElement();
					memberList.add(member);
				}
				ejb.setMember(memberList);
				hosts.close();
			}
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#store(com.clustercontrol.accesscontrol.ejb.entity.RoleBean)
	 */
	public void store(RoleBean ejb) throws EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(ejb.getDn());
			
			javax.naming.directory.Attributes addAttrs = 
				new javax.naming.directory.BasicAttributes();
			javax.naming.directory.Attributes replaceAttrs = 
				new javax.naming.directory.BasicAttributes();
			javax.naming.directory.Attributes removeAttrs = 
				new javax.naming.directory.BasicAttributes();
			
			//description
			if(attrs.get(RoleAttributeConstant.DESCRIPTION) == null && ejb.getDescription() != null){
				addAttrs.put(RoleAttributeConstant.DESCRIPTION, ejb.getDescription());
			}
			else if(attrs.get(RoleAttributeConstant.DESCRIPTION) != null && ejb.getDescription() == null){
				removeAttrs.put(RoleAttributeConstant.DESCRIPTION, null);
			}
			else if(attrs.get(RoleAttributeConstant.DESCRIPTION) != null && ejb.getDescription() != null){
				replaceAttrs.put(RoleAttributeConstant.DESCRIPTION, ejb.getDescription());
			}
			//ccCreateTimestamp
			if(attrs.get(RoleAttributeConstant.CREATETIMESTAMP) == null && ejb.getCreateTimestamp() != null){
				addAttrs.put(RoleAttributeConstant.CREATETIMESTAMP, dateToString(ejb.getCreateTimestamp()));
			}
			else if(attrs.get(RoleAttributeConstant.CREATETIMESTAMP) != null && ejb.getCreateTimestamp() == null){
				removeAttrs.put(RoleAttributeConstant.CREATETIMESTAMP, null);
			}
			else if(attrs.get(RoleAttributeConstant.CREATETIMESTAMP) != null && ejb.getCreateTimestamp() != null){
				replaceAttrs.put(RoleAttributeConstant.CREATETIMESTAMP, dateToString(ejb.getCreateTimestamp()));
			}
			//ccCreatorsName
			if(attrs.get(RoleAttributeConstant.CREATORSNAME) == null && ejb.getCreatorsName() != null){
				addAttrs.put(RoleAttributeConstant.CREATORSNAME, ejb.getCreatorsName());
			}
			else if(attrs.get(RoleAttributeConstant.CREATORSNAME) != null && ejb.getCreatorsName() == null){
				removeAttrs.put(RoleAttributeConstant.CREATORSNAME, null);
			}
			else if(attrs.get(RoleAttributeConstant.CREATORSNAME) != null && ejb.getCreatorsName() != null){
				replaceAttrs.put(RoleAttributeConstant.CREATORSNAME, ejb.getCreatorsName());
			}
			//ccModifiersName
			if(attrs.get(RoleAttributeConstant.MODIFIERSNAME) == null && ejb.getModifiersName() != null){
				addAttrs.put(RoleAttributeConstant.MODIFIERSNAME, ejb.getModifiersName());
			}
			else if(attrs.get(RoleAttributeConstant.MODIFIERSNAME) != null && ejb.getModifiersName() == null){
				removeAttrs.put(RoleAttributeConstant.MODIFIERSNAME, null);
			}
			else if(attrs.get(RoleAttributeConstant.MODIFIERSNAME) != null && ejb.getModifiersName() != null){
				replaceAttrs.put(RoleAttributeConstant.MODIFIERSNAME, ejb.getModifiersName());
			}
			//ccModifyTimestamp
			if(attrs.get(RoleAttributeConstant.MODIFYTIMESTAMP) == null && ejb.getModifyTimestamp() != null){
				addAttrs.put(RoleAttributeConstant.MODIFYTIMESTAMP, dateToString(ejb.getModifyTimestamp()));
			}
			else if(attrs.get(RoleAttributeConstant.MODIFYTIMESTAMP) != null && ejb.getModifyTimestamp() == null){
				removeAttrs.put(RoleAttributeConstant.MODIFYTIMESTAMP, null);
			}
			else if(attrs.get(RoleAttributeConstant.MODIFYTIMESTAMP) != null && ejb.getModifyTimestamp() != null){
				replaceAttrs.put(RoleAttributeConstant.MODIFYTIMESTAMP, dateToString(ejb.getModifyTimestamp()));
			}
			//member
			if(attrs.get(RoleAttributeConstant.MEMBER) == null && ejb.getMember() != null){
				javax.naming.directory.Attribute attr =
					new javax.naming.directory.BasicAttribute(RoleAttributeConstant.MEMBER);
				ArrayList list = ejb.getMember();
				for(int i = 0; i < list.size(); i++) {
					String member = (String)list.get(i);
					attr.add(i, member);
				}
				if(attr.size() > 0){
					addAttrs.put(attr);
				}
			}
			else if(attrs.get(RoleAttributeConstant.MEMBER) != null && ejb.getMember() == null){
				removeAttrs.put(RoleAttributeConstant.MEMBER, null);
			}
			else if(attrs.get(RoleAttributeConstant.MEMBER) != null && ejb.getMember() != null){
				javax.naming.directory.Attribute attr =
					new javax.naming.directory.BasicAttribute(RoleAttributeConstant.MEMBER);
				ArrayList list = ejb.getMember();
				for(int i = 0; i < list.size(); i++) {
					String member = (String)list.get(i);
					attr.add(i, member);
				}
				replaceAttrs.put(attr);
			}
			
			//°ѹɲá
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.ADD_ATTRIBUTE, 
					addAttrs);
			//°ѹִ
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.REPLACE_ATTRIBUTE, 
					replaceAttrs);
			//°ѹʺ
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.REMOVE_ATTRIBUTE, 
					removeAttrs);
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#remove(com.clustercontrol.accesscontrol.ejb.entity.RolePK)
	 */
	public void remove(RolePK pk) throws RemoveException, EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//ȥ
			ctx.destroySubcontext(pk.getDn());
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {pk.getDn()};
            apllog.put("SYS", "005", args);
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#create(com.clustercontrol.accesscontrol.ejb.entity.RoleBean)
	 */
	public RolePK create(RoleBean ejb) throws CreateException, EJBException {
		RolePK pk = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			// Attributes for new entry
			javax.naming.directory.Attributes attrs =
				new javax.naming.directory.BasicAttributes();
			
			//objectClass
			javax.naming.directory.Attribute attr =
				new javax.naming.directory.BasicAttribute(OBJECTCLASS);
			attr.add(0, OBJECT_CLASS_ROLE);
			attrs.put(attr);
			
			//cn
			attrs.put(RoleAttributeConstant.CN, ejb.getCn());
			// dnʸ
			StringBuffer dn = new StringBuffer();
			dn.append(RoleAttributeConstant.CN);
			dn.append("=");
			dn.append(ejb.getCn());
			dn.append(",");
			dn.append(BASE_DN);
			
			//dn
			ejb.setDn(dn.toString());

			//ȥ
			ctx.createSubcontext(ejb.getDn(), attrs);

			pk = new RolePK(ejb.getDn());
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {ejb.getDn()};
            apllog.put("SYS", "004", args);
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
		return pk;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		ArrayList<RolePK> ret = new ArrayList<RolePK>();

		m_log.debug("findAll()");
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_ROLE);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				m_log.debug("findAll() : No Search Result");
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				RolePK pk = new RolePK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findAll() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}


		return ret;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#findByPrimaryKey(com.clustercontrol.accesscontrol.ejb.entity.RolePK)
	 */
	public RolePK findByPrimaryKey(RolePK pk) throws FinderException {
		javax.naming.directory.DirContext ctx = null;
		try {
			m_log.debug("findByPrimaryKey() : dn = " + pk.getDn());
			
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(pk.getDn());
			attrs.hashCode();
			
			return pk;
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByPrimaryKey() : " + ex.getMessage());
			throw new FinderException("dn=" + pk.getDn() + " not found.");
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#findByCn(java.lang.String)
	 */
	public RolePK findByCn(String cn) throws FinderException {
		m_log.debug("findByCn() : cn = " + cn);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// ̾դ֥Ȥ򸡺
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_ROLE);
		search.append(")(");
		search.append(RoleAttributeConstant.CN);
		search.append("=");
		search.append(cn);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		RolePK pk = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				throw new FinderException("cn=" + cn + " not found.");
			}
			
			javax.naming.directory.SearchResult aResult = null;
			javax.naming.directory.Attributes attrs = null;
			while ( results.hasMoreElements() ) {
				aResult = (javax.naming.directory.SearchResult)results.nextElement();
				attrs = aResult.getAttributes();
				break;
			}
			
			if (attrs == null) {
				throw new FinderException("cn=" + cn + " not found.");
			}
			
			pk = new RolePK(aResult.getName() + "," + BASE_DN);
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByCn() : " + e.getMessage());
			throw new FinderException("cn=" + cn + " not found.");
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return pk;
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#findByMember(java.lang.String)
	 */
	public Collection findByMember(String dn) throws FinderException {
		ArrayList<RolePK> ret = new ArrayList<RolePK>();

		m_log.debug("findByMember() : dn = " + dn);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_ROLE);
		search.append(")(");
		search.append(RoleAttributeConstant.MEMBER);
		search.append("=");
		search.append(dn);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				m_log.debug("findByMember() : No Search Result : dn = " + dn);
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				RolePK pk = new RolePK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByMember() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return ret;
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.RoleDAO#findByCnAndMenber(java.lang.String, java.lang.String)
	 */
	public RolePK findByCnAndMenber(String cn, String dn) throws FinderException {
		m_log.debug("findByCnAndMenber() : cn = " + cn + ", dn = " + dn);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// ̾դ֥Ȥ򸡺
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_ROLE);
		search.append(")(");
		search.append(RoleAttributeConstant.CN);
		search.append("=");
		search.append(cn);
		search.append(")(");
		search.append(RoleAttributeConstant.MEMBER);
		search.append("=");
		search.append(dn);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		RolePK pk = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				throw new FinderException("cn=" + cn + ", dn = " + dn + " not found.");
			}
			
			javax.naming.directory.SearchResult aResult = null;
			javax.naming.directory.Attributes attrs = null;
			while ( results.hasMoreElements() ) {
				aResult = (javax.naming.directory.SearchResult)results.nextElement();
				attrs = aResult.getAttributes();
				break;
			}
			
			if (attrs == null) {
				throw new FinderException("cn=" + cn + ", dn = " + dn + " not found.");
			}
			
			pk = new RolePK(aResult.getName() + "," + BASE_DN);
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByCnAndMenber() : " + e.getMessage());
			throw new FinderException("cn=" + cn + ", dn = " + dn + " not found.");
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return pk;
	}
	
	/**
	 * StringBooleanѴ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param value
	 * @return
	 */
	public Boolean stringToBoolean(String value) {
		Boolean ret = null;
		
		if(value.compareTo("TRUE") == 0){
			ret = new Boolean(true);
		}
		else{
			ret = new Boolean(false);;
		}
		
		return ret;
	}
	
	/**
	 * BooleanStringѴ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param value
	 * @return
	 */
	public String booleanToString(Boolean value) {
		String ret = null;
		
		if(value.booleanValue()){
			ret = "TRUE";
		}
		else{
			ret = "FALSE";
		}
		
		return ret;
	}
	
	/**
	 * StringDateѴ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param value
	 * @return
	 */
	public Date stringToDate(String value) {
		Date ret = null;
		
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");

		try {
			ret = formatter.parse(value);
		} catch (ParseException e) {
		}

		return ret;
	}
	
	/**
	 * DateStringѴ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param value
	 * @return
	 */
	public String dateToString(Date value) {
		String ret = null;
		
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");

		ret = formatter.format(value);


		return ret;
	}
	
	/**
	 * Beanꥢ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param ejb
	 */
	protected void clearBean(RoleBean ejb){
	    ejb.setDn(null);
	    ejb.setCn(null);
	    ejb.setMember(null);
	    ejb.setDescription(null);
	    ejb.setCreateTimestamp(null);
	    ejb.setCreatorsName(null);
	    ejb.setModifiersName(null);
	    ejb.setModifyTimestamp(null);
	}
}
