/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.dao;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.UserAttributeConstant;
import com.clustercontrol.accesscontrol.ejb.entity.RoleLocal;
import com.clustercontrol.accesscontrol.ejb.entity.RoleUtil;
import com.clustercontrol.accesscontrol.ejb.entity.UserBean;
import com.clustercontrol.accesscontrol.ejb.entity.UserPK;
import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * User(BMP Entity Bean)DAO饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserDAOImpl implements UserDAO {
	protected static Log m_log = LogFactory.getLog( UserDAOImpl.class );
	
	protected static final String OBJECTCLASS = "objectClass";
	protected static final String BASE_DN = "ou=hinemos,ou=people";
	protected static final String OBJECT_CLASS_USER = "ccUser";

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#init()
	 */
	public void init() {
		
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#load(com.clustercontrol.accesscontrol.ejb.entity.UserPK, com.clustercontrol.accesscontrol.ejb.entity.UserBean)
	 */
	public void load(UserPK pk, UserBean ejb) throws EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			clearBean(ejb);
			
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(pk.getDn());
			
			//dn
			ejb.setDn(pk.getDn());
			//uid
			ejb.setUid((String)attrs.get(UserAttributeConstant.UID).get(0));
			//cn
			if(attrs.get(UserAttributeConstant.CN) != null){
				ejb.setCn((String)attrs.get(UserAttributeConstant.CN).get(0));
			}
			//sn
			if(attrs.get(UserAttributeConstant.SN) != null){
				ejb.setSn((String)attrs.get(UserAttributeConstant.SN).get(0));
			}
			//userPassword
			if(attrs.get(UserAttributeConstant.USERPASSWORD) != null){
				byte[] passwordByte = (byte[])attrs.get(UserAttributeConstant.USERPASSWORD).get(0);
				String password = null;
				try {
					password = new String(passwordByte, "UTF-8");
				} catch (UnsupportedEncodingException e) {
				}
				ejb.setPassword(password);
			}
			//description
			if(attrs.get(UserAttributeConstant.DESCRIPTION) != null){
				ejb.setDescription((String)attrs.get(UserAttributeConstant.DESCRIPTION).get(0));
			}
			//ccCreateTimestamp
			if(attrs.get(UserAttributeConstant.CREATETIMESTAMP) != null){
				ejb.setCreateTimestamp(stringToDate((String)attrs.get(UserAttributeConstant.CREATETIMESTAMP).get(0)));
			}
			//ccCreatorsName
			if(attrs.get(UserAttributeConstant.CREATORSNAME) != null){
				ejb.setCreatorsName((String)attrs.get(UserAttributeConstant.CREATORSNAME).get(0));
			}
			//ccModifiersName
			if(attrs.get(UserAttributeConstant.MODIFIERSNAME) != null){
				ejb.setModifiersName((String)attrs.get(UserAttributeConstant.MODIFIERSNAME).get(0));
			}
			//ccModifyTimestamp
			if(attrs.get(UserAttributeConstant.MODIFYTIMESTAMP) != null){
				ejb.setModifyTimestamp(stringToDate((String)attrs.get(UserAttributeConstant.MODIFYTIMESTAMP).get(0)));
			}
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#store(com.clustercontrol.accesscontrol.ejb.entity.UserBean)
	 */
	public void store(UserBean ejb) throws EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(ejb.getDn());
			
			javax.naming.directory.Attributes addAttrs = 
				new javax.naming.directory.BasicAttributes();
			javax.naming.directory.Attributes replaceAttrs = 
				new javax.naming.directory.BasicAttributes();
			javax.naming.directory.Attributes removeAttrs = 
				new javax.naming.directory.BasicAttributes();
			
			//cn
			if(attrs.get(UserAttributeConstant.CN) == null && ejb.getCn() != null){
				addAttrs.put(UserAttributeConstant.CN, ejb.getCn());
			}
			else if(attrs.get(UserAttributeConstant.CN) != null && ejb.getCn() == null){
				removeAttrs.put(UserAttributeConstant.CN, null);
			}
			else if(attrs.get(UserAttributeConstant.CN) != null && ejb.getCn() != null){
				replaceAttrs.put(UserAttributeConstant.CN, ejb.getCn());
			}
			//sn
			if(attrs.get(UserAttributeConstant.SN) == null && ejb.getSn() != null){
				addAttrs.put(UserAttributeConstant.SN, ejb.getSn());
			}
			else if(attrs.get(UserAttributeConstant.SN) != null && ejb.getSn() == null){
				removeAttrs.put(UserAttributeConstant.SN, null);
			}
			else if(attrs.get(UserAttributeConstant.SN) != null && ejb.getSn() != null){
				replaceAttrs.put(UserAttributeConstant.SN, ejb.getSn());
			}
			//password
			if(attrs.get(UserAttributeConstant.USERPASSWORD) == null && ejb.getPassword() != null){
				addAttrs.put(UserAttributeConstant.USERPASSWORD, ejb.getPassword().getBytes());
			}
			else if(attrs.get(UserAttributeConstant.USERPASSWORD) != null && ejb.getPassword() == null){
				removeAttrs.put(UserAttributeConstant.USERPASSWORD, null);
			}
			else if(attrs.get(UserAttributeConstant.USERPASSWORD) != null && ejb.getPassword() != null){
				replaceAttrs.put(UserAttributeConstant.USERPASSWORD, ejb.getPassword().getBytes());
			}
			//description
			if(attrs.get(UserAttributeConstant.DESCRIPTION) == null && ejb.getDescription() != null){
				addAttrs.put(UserAttributeConstant.DESCRIPTION, ejb.getDescription());
			}
			else if(attrs.get(UserAttributeConstant.DESCRIPTION) != null && ejb.getDescription() == null){
				removeAttrs.put(UserAttributeConstant.DESCRIPTION, null);
			}
			else if(attrs.get(UserAttributeConstant.DESCRIPTION) != null && ejb.getDescription() != null){
				replaceAttrs.put(UserAttributeConstant.DESCRIPTION, ejb.getDescription());
			}
			//ccCreateTimestamp
			if(attrs.get(UserAttributeConstant.CREATETIMESTAMP) == null && ejb.getCreateTimestamp() != null){
				addAttrs.put(UserAttributeConstant.CREATETIMESTAMP, dateToString(ejb.getCreateTimestamp()));
			}
			else if(attrs.get(UserAttributeConstant.CREATETIMESTAMP) != null && ejb.getCreateTimestamp() == null){
				removeAttrs.put(UserAttributeConstant.CREATETIMESTAMP, null);
			}
			else if(attrs.get(UserAttributeConstant.CREATETIMESTAMP) != null && ejb.getCreateTimestamp() != null){
				replaceAttrs.put(UserAttributeConstant.CREATETIMESTAMP, dateToString(ejb.getCreateTimestamp()));
			}
			//ccCreatorsName
			if(attrs.get(UserAttributeConstant.CREATORSNAME) == null && ejb.getCreatorsName() != null){
				addAttrs.put(UserAttributeConstant.CREATORSNAME, ejb.getCreatorsName());
			}
			else if(attrs.get(UserAttributeConstant.CREATORSNAME) != null && ejb.getCreatorsName() == null){
				removeAttrs.put(UserAttributeConstant.CREATORSNAME, null);
			}
			else if(attrs.get(UserAttributeConstant.CREATORSNAME) != null && ejb.getCreatorsName() != null){
				replaceAttrs.put(UserAttributeConstant.CREATORSNAME, ejb.getCreatorsName());
			}
			//ccModifiersName
			if(attrs.get(UserAttributeConstant.MODIFIERSNAME) == null && ejb.getModifiersName() != null){
				addAttrs.put(UserAttributeConstant.MODIFIERSNAME, ejb.getModifiersName());
			}
			else if(attrs.get(UserAttributeConstant.MODIFIERSNAME) != null && ejb.getModifiersName() == null){
				removeAttrs.put(UserAttributeConstant.MODIFIERSNAME, null);
			}
			else if(attrs.get(UserAttributeConstant.MODIFIERSNAME) != null && ejb.getModifiersName() != null){
				replaceAttrs.put(UserAttributeConstant.MODIFIERSNAME, ejb.getModifiersName());
			}
			//ccModifyTimestamp
			if(attrs.get(UserAttributeConstant.MODIFYTIMESTAMP) == null && ejb.getModifyTimestamp() != null){
				addAttrs.put(UserAttributeConstant.MODIFYTIMESTAMP, dateToString(ejb.getModifyTimestamp()));
			}
			else if(attrs.get(UserAttributeConstant.MODIFYTIMESTAMP) != null && ejb.getModifyTimestamp() == null){
				removeAttrs.put(UserAttributeConstant.MODIFYTIMESTAMP, null);
			}
			else if(attrs.get(UserAttributeConstant.MODIFYTIMESTAMP) != null && ejb.getModifyTimestamp() != null){
				replaceAttrs.put(UserAttributeConstant.MODIFYTIMESTAMP, dateToString(ejb.getModifyTimestamp()));
			}
			//°ѹɲá
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.ADD_ATTRIBUTE, 
					addAttrs);
			//°ѹִ
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.REPLACE_ATTRIBUTE, 
					replaceAttrs);
			//°ѹʺ
			ctx.modifyAttributes(
					ejb.getDn(), 
					javax.naming.directory.DirContext.REMOVE_ATTRIBUTE, 
					removeAttrs);
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#remove(com.clustercontrol.accesscontrol.ejb.entity.UserPK)
	 */
	public void remove(UserPK pk) throws RemoveException, EJBException {
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//ȥ
			ctx.destroySubcontext(pk.getDn());
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {pk.getDn()};
            apllog.put("SYS", "003", args);
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#create(com.clustercontrol.accesscontrol.ejb.entity.UserBean)
	 */
	public UserPK create(UserBean ejb) throws CreateException, EJBException {
		UserPK pk = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			// Attributes for new entry
			javax.naming.directory.Attributes attrs =
				new javax.naming.directory.BasicAttributes();
			
			//objectClass
			javax.naming.directory.Attribute attr =
				new javax.naming.directory.BasicAttribute(OBJECTCLASS);
			attr.add(0, OBJECT_CLASS_USER);
			attrs.put(attr);
			
			//uid
			attrs.put(UserAttributeConstant.UID, ejb.getUid());
			// dnʸ
			StringBuffer dn = new StringBuffer();
			dn.append(UserAttributeConstant.UID);
			dn.append("=");
			dn.append(ejb.getUid());
			dn.append(",");
			dn.append(BASE_DN);
			
			//dn
			ejb.setDn(dn.toString());

			//ȥ
			ctx.createSubcontext(ejb.getDn(), attrs);

			pk = new UserPK(ejb.getDn());
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {ejb.getDn()};
            apllog.put("SYS", "002", args);
			throw new EJBException(ex);
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
		return pk;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		ArrayList<UserPK> ret = new ArrayList<UserPK>();

		m_log.debug("findAll()");
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_USER);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();

			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				m_log.debug("findAll() : No Search Result");
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				UserPK pk = new UserPK(aResult.getName() + "," + BASE_DN);
				ret.add(pk);
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findAll() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return ret;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#findByPrimaryKey(com.clustercontrol.accesscontrol.ejb.entity.UserPK)
	 */
	public UserPK findByPrimaryKey(UserPK pk) throws FinderException {
		javax.naming.directory.DirContext ctx = null;
		try {
			m_log.debug("findByPrimaryKey() : dn = " + pk.getDn());
			
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			//°
			javax.naming.directory.Attributes attrs = ctx.getAttributes(pk.getDn());
			attrs.hashCode();
			
			return pk;
		}
		catch ( javax.naming.NamingException ex ) {
		    if(ex instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByPrimaryKey() : " + ex.getMessage());
			throw new FinderException("dn=" + pk.getDn() + " not found.");
		}
		finally{
			try {
				if(ctx != null){
					ctx.close();
				}
			} catch (NamingException e) {
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#findByUid(java.lang.String)
	 */
	public UserPK findByUid(String uid) throws FinderException {
		m_log.debug("findByUid() : uid = " + uid);
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// ̾դ֥Ȥ򸡺
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_USER);
		search.append(")(");
		search.append(UserAttributeConstant.UID);
		search.append("=");
		search.append(uid);
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		UserPK pk = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				throw new FinderException("uid=" + uid + " not found.");
			}
			
			javax.naming.directory.SearchResult aResult = null;
			javax.naming.directory.Attributes attrs = null;
			while ( results.hasMoreElements() ) {
				aResult = (javax.naming.directory.SearchResult)results.nextElement();
				attrs = aResult.getAttributes();
				break;
			}
			
			if (attrs == null) {
				throw new FinderException("uid=" + uid + " not found.");
			}
			
			pk = new UserPK(aResult.getName() + "," + BASE_DN);
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findByUid() : " + e.getMessage());
			throw new FinderException("uid=" + uid + " not found.");
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return pk;
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.accesscontrol.dao.UserDAO#findUser(java.lang.String, java.lang.String, java.lang.String, java.util.List)
	 */
	public Collection findUser(
			String uid, 
			String name, 
			String description, 
			List accessList) throws FinderException {
		ArrayList<UserPK> ret = new ArrayList<UserPK>();

		m_log.debug("findUser()");
		
		// ȥθ
		javax.naming.directory.SearchControls constraints = 
			new javax.naming.directory.SearchControls();

		// BaseDNʲˤ֤鲼뤹٤ƤΥ٥򸡺о
		constraints.setSearchScope(javax.naming.directory.SearchControls.SUBTREE_SCOPE);

		// ʸ
		StringBuffer search = new StringBuffer();
		search.append("(&(");
		search.append(OBJECTCLASS);
		search.append("=");
		search.append(OBJECT_CLASS_USER);
		// UID򸡺ʸ
		if(uid != null && uid.compareTo("") != 0){
			search.append(")(");
			search.append(UserAttributeConstant.UID);
			search.append("=");
			search.append(uid);
		}
		// ̾򸡺ʸ
		if(name != null && name.compareTo("") != 0){
			search.append(")(");
			search.append(UserAttributeConstant.CN);
			search.append("=");
			search.append(name);
		}
		// 򸡺ʸ
		if(description != null && description.compareTo("") != 0){
			search.append(")(");
			search.append(UserAttributeConstant.DESCRIPTION);
			search.append("=");
			search.append(description);
		}
		search.append("))");
		
		//¹
		javax.naming.NamingEnumeration results = null;
		javax.naming.directory.DirContext ctx = null;
		try {
			// LDAPѤΥƥȤκ
			ctx = LdapConnectionManager.getConnectionManager().getDirContext();
			
			results = ctx.search(BASE_DN, search.toString(), constraints);
			
			if (results == null) {
				m_log.debug("findUser() : No Search Result");
				return ret;
			}

			//̤
			while ( results.hasMoreElements() ) {
				javax.naming.directory.SearchResult aResult = 
					(javax.naming.directory.SearchResult)results.nextElement();
				UserPK pk = new UserPK(aResult.getName() + "," + BASE_DN);
				
				boolean find = true;
				for(int i = 0; i < accessList.size(); i++){
					try {
						RoleLocal role = 
							RoleUtil.getLocalHome().findByCnAndMenber(
									(String)accessList.get(i), 
									pk.getDn());
						role.hashCode();
						
						find = true;
					} catch (FinderException e) {
						find = false;
						break;
					} catch (NamingException e) {
						find = false;
						break;
					}
				}
				if(find){
					ret.add(pk);
				}
			}
			
		} catch (NamingException e) {
		    if(e instanceof CommunicationException){
		        LdapConnectionManager.getConnectionManager().setDirContext(null);
		    }
		    m_log.debug("findUser() : " + e.getMessage());
		}
		finally{
			try {
				if(results != null)
					results.close();
				if(ctx != null)
					ctx.close();
			} catch (NamingException e) {
			}
		}

		return ret;
	}
	
	/**
	 * StringBooleanѴ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param value
	 * @return
	 */
	public Boolean stringToBoolean(String value) {
		Boolean ret = null;
		
		if(value.compareTo("TRUE") == 0){
			ret = new Boolean(true);
		}
		else{
			ret = new Boolean(false);;
		}
		
		return ret;
	}
	
	/**
	 * BooleanStringѴ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param value
	 * @return
	 */
	public String booleanToString(Boolean value) {
		String ret = null;
		
		if(value.booleanValue()){
			ret = "TRUE";
		}
		else{
			ret = "FALSE";
		}
		
		return ret;
	}
	
	/**
	 * StringDateѴ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param value
	 * @return
	 */
	public Date stringToDate(String value) {
		Date ret = null;
		
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");

		try {
			ret = formatter.parse(value);
		} catch (ParseException e) {
		}

		return ret;
	}
	
	/**
	 * DateStringѴ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param value
	 * @return
	 */
	public String dateToString(Date value) {
		String ret = null;
		
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");

		ret = formatter.format(value);


		return ret;
	}
	
	/**
	 * Beanꥢ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param ejb
	 */
	protected void clearBean(UserBean ejb){
	    ejb.setUid(null);
	    ejb.setDn(null);
	    ejb.setCn(null);
	    ejb.setSn(null);
	    ejb.setPassword(null);
	    ejb.setDescription(null);
	    ejb.setCreateTimestamp(null);
	    ejb.setCreatorsName(null);
	    ejb.setModifiersName(null);
	    ejb.setModifyTimestamp(null);
	}
}
