/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.agent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.agent.util.EjbConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * ȥᥤ󥯥饹
 * 
 * @version $Revision: 1.15 $
 * @since 1.0.0
 */
public class Agent {


	private Properties m_props;

	private EjbConnectionManager m_ejbConnectionManager;

	private ReceiveTopic m_receiveTopic;

	private SendQueue m_sendQueue;
	
	private UpdateRepositoryInfoReceiveTopic m_updateRepository;

	/** եƥIDѥޡ * */
	protected Timer m_timer = new Timer(true);

	private long m_cacheInterval = 600000;
	
	//
	static private Log log = LogFactory.getLog(Agent.class);

	
	
	/**
	 * ᥤ
	 * 
	 * @param args ץѥƥե̾
	 */
	public static void main(String[] args) throws Exception{

		Agent agent = new Agent(args[0]);

		//Ƚ
		agent.exec();

		
		//λԤ
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		while (true) {
			try {
				String line = br.readLine();
				if (line.equals("quit") ) {
					break;
				}
			} catch (Exception e) {
			}
			synchronized (agent) {
			    agent.wait();
            } 
		}
		

		//------------
		//-- λ
		//------------
		
		agent.terminate();
		
		
	}

	/**
	 * 󥹥ȥ饯
	 */
	public Agent(String propFileName) throws Exception{

		//------------
		//-- 
		//------------

		//ץѥƥեɤ߹
		m_props = new Properties();
		try {
			m_props.load(new FileInputStream(propFileName));
		} catch (Exception e) {
			log.error(e);
			throw e;
		}

		//եƥå幹󥿡Х
		String casheInterval = m_props.getProperty("facility.update.interval");
		if (casheInterval != null) {
			try {
				m_cacheInterval = Long.parseLong(casheInterval);
			} catch (NumberFormatException e) {
				log.error("facility.update.interval",e);
			}
		}
		
		m_ejbConnectionManager = new EjbConnectionManager(m_props);
		m_sendQueue = new SendQueue(m_props);

		//λƤӽФ
    	Runtime.getRuntime().addShutdownHook(new Thread() {
    	    public void run() { terminate(); }
    	});



	}

	
	/**
	 * Ƚ¹.
	 * ȥԥåؤ³Ԥ 
	 */
	public void exec() {
		//-----------------
		//-- ȥԥå³
		//-----------------
		if (log.isDebugEnabled())
			log.debug("ȥԥå³");

		//ɤΥեƥID

		m_receiveTopic = new ReceiveTopic(getFacility(), m_sendQueue, m_props);
		
		m_updateRepository = new UpdateRepositoryInfoReceiveTopic(this, m_props);

		//å幹ޡ
		m_timer.schedule(new ReflashFilterTask(), m_cacheInterval,
				m_cacheInterval);

		
		
	}
	
	/**
	 * եƥID.
	 * ɤIPɥ쥹ȡۥ̾ǥݥȥ꤫եƥID롣
	 * @returnեƥIDCollection
	 * @since
	 */
	public Collection getFacility() {

		//RepositoryController

		HashMap<String, String> map = new HashMap<String, String>();

		RepositoryController repository = null;
		try {
			repository = m_ejbConnectionManager.getRepositoryController();
		} catch (Exception e1) {
			return map.values();
		}

		try {
			//ͥåȥ
			Enumeration networkInterfaces = NetworkInterface
					.getNetworkInterfaces();
			if (null != networkInterfaces) {

				while (networkInterfaces.hasMoreElements()) {

					NetworkInterface ni = (NetworkInterface) networkInterfaces
							.nextElement();

					if (log.isDebugEnabled()) {
						try {
							log.debug("ͥåȥ:\t"
									+ new String(ni.getDisplayName().getBytes(
											"iso-8859-1")));
						} catch (UnsupportedEncodingException e) {
							log.debug("ͥåȥ:\t", e);
						}
					}

					Enumeration inetAddresses = ni.getInetAddresses();
					while (inetAddresses.hasMoreElements()) {

						InetAddress in4 = (InetAddress) inetAddresses.nextElement();

						if (log.isDebugEnabled())
							log.debug("IP/HOST:\t" + in4.getHostAddress()
									+ "/" + in4.getHostName());

						//ۥȰʳλ
						if (in4.getHostAddress().compareTo("127.0.0.1") != 0) {

							//IPȥۥ̾ǡեƥID
							ArrayList facilityIdList = repository.getFacilityIdList(in4.getHostName(), in4.getHostAddress());

							if (log.isDebugEnabled()) {
								if (facilityIdList.size() == 0) {
									log.debug("бեƥʤ");
								}
							}

							for (Iterator iter = facilityIdList.iterator(); iter.hasNext();) {
								String facilityId = (String) iter.next();

								if (log.isDebugEnabled())
									log.debug("бեƥ:" + facilityId);

								//եƥоݤɲ
								if (map.containsKey(facilityId) == false) {
									map.put(facilityId, facilityId);
								}
							}
						}
					}

				}
			}

		} catch (Exception e) {
			log.debug("եƥ");
			log.error(e);
			
		}

		return map.values();

	}

	/**
	 * λ.
	 */
	public void terminate() {

		m_receiveTopic.terminate();
		
		m_updateRepository.terminate();

		m_sendQueue.terminate();

		m_timer.cancel();

	}
	
	/**
	 * եƥIDƼޡ
	 */
	protected class ReflashFilterTask extends TimerTask {

		/**
		 * å幹
		 */
		public void run() {

			setFacility();

		}

	}

	/**
	 * å幹
	 */
	public void setFacility() {

		m_receiveTopic.setFacilityIdList(getFacility());

	}
}
