/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.util.apllog;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.message.LogOutputInfo;


/**
 * ץꥱ
 * 
 * AplLogger
 * @version $Revision$
 * @since 
 */
public class AplLogger {

    private static final String PRIORITY_UNKNOWN = "unknown";
    private static final String PRIORITY_INFO = "info";
    private static final String PRIORITY_WARNING = "warning";
    private static final String PRIORITY_CRITICAL = "critical";
    private String m_pluginID;
    private String m_aplID;
    private String m_aplName;
    static private SendQueue m_sendQueue = null;

    static private Map m_priorityMap = null;

    static private Map m_outPutMap = null;
    
	static Log FILE_LOGGER = LogFactory.getLog("hinemos.apllog");
	static Log log = LogFactory.getLog(AplLogger.class);

	
	
	/**	եѥեޥåȡ  ץ饰ID,ץꥱ,ƻID,åID,եƥID,å,ܺ٥å */
	private MessageFormat m_logfmt = new MessageFormat(
			"{0,date,yyyy/MM/dd HH:mm:ss}  {1},{2},{3},{4},{5},{6}");

	/**
	 * 󥯥饹.
	 * եϡåϤΥե饰ݻ
	 *
	 * OutPutInfo
	 * @version $Revision$
	 * @since
	 */
	private class OutPutInfo{
	
	    private static final String OUTPUT_BOTH = "both";
	    private static final String OUTPUT_FILE = "file";
	    private static final String OUTPUT_MSG = "msg";
	    
	    boolean isFileOutPut = true;
	    boolean isMsgOutPut = true;

        /**
         * @param isFileOutPut
         * @param isMsgOutPut
         */
        public OutPutInfo(String output) {

            if(output.equals(OUTPUT_FILE)){
                this.isFileOutPut = true;
                this.isMsgOutPut = false;
            }else if(output.equals(OUTPUT_MSG)){
                this.isFileOutPut = false;
                this.isMsgOutPut = true;
            }
                
        }
	    /**
         * @return isFileOutPut ᤷޤ
         */
        public boolean isFileOutPut() {
            return isFileOutPut;
        }
        /**
         * @return isMsgOutPut ᤷޤ
         */
        public boolean isMsgOutPut() {
            return isMsgOutPut;
        }
	}
	
	
    /**
     * 󥹥ȥ饯.
     * 
     * @param pluginID	ץ饰ID
     * @param aplId		ץꥱID
     */
    public AplLogger(String pluginID, String aplId) {
        super();
        m_pluginID = pluginID;
        m_aplID = aplId;
        
        //å饹
        if( m_sendQueue == null ){
            m_sendQueue = new SendQueue("queue/clustercontrol/Monitor/EventLog");
        }
        
        //ץꥱ̾
        m_aplName = PropertyUtil.getString(pluginID + "." + aplId);
        
        //ʸ
        if( m_priorityMap == null ){
            m_priorityMap = Collections.synchronizedMap(new HashMap());
            
            m_priorityMap.put(PRIORITY_CRITICAL, PropertyUtil.getString("priority.critical"));
            m_priorityMap.put(PRIORITY_WARNING, PropertyUtil.getString("priority.warning"));
            m_priorityMap.put(PRIORITY_INFO, PropertyUtil.getString("priority.info"));
            m_priorityMap.put(PRIORITY_UNKNOWN, PropertyUtil.getString("priority.unknown"));
            
        }
        
        //̽
        if( m_outPutMap == null ){
            m_outPutMap = Collections.synchronizedMap(new HashMap());
            
            m_outPutMap.put(PRIORITY_CRITICAL, new OutPutInfo( PropertyUtil.getString("priority.critical.output")));
            m_outPutMap.put(PRIORITY_WARNING, 	new OutPutInfo( PropertyUtil.getString("priority.warning.output")));
            m_outPutMap.put(PRIORITY_INFO, 	new OutPutInfo( PropertyUtil.getString("priority.info.output")));
            m_outPutMap.put(PRIORITY_UNKNOWN, 	new OutPutInfo( PropertyUtil.getString("priority.unknown.output")));
            
        }
        
        
    }

    public static void main(String[] args) {
        AplLogger apllog = new AplLogger("REP","rep");
        apllog.put("SYS","001");
        apllog.put("USR","001");
        apllog.put("USR","002");
        apllog.put("USR","003");
        
    }
    
    /**
     * 
     * .
     * 
     * @param moniterID		ƻID
     * @param msgID			åID
     * @param msgArgs		åִ
     * @param detailMsg		ܺ٥å
     * @since
     */
    public void put(String moniterID, String msgID, Object[] msgArgs, String detailMsg) {

        
        boolean isMsgOutPut = true;
        boolean isFileOutPut = true;

        //
        Date nowDate = new Date();

        //ƻIDȥץ饰IDǥ٥ȥåʥ꥽եˤ
        StringBuffer keyBase = new StringBuffer();
        keyBase.append(m_pluginID);
        keyBase.append(".");
        keyBase.append(moniterID);
        keyBase.append(".");
        keyBase.append(msgID);

        //٤
        StringBuffer keyPriority = new StringBuffer();
        keyPriority.append(keyBase);
        keyPriority.append(".");
        keyPriority.append("priority");
        
        String priority = PropertyUtil.getString(keyPriority.toString());

        //å롣
        StringBuffer keyMsg = new StringBuffer();
        keyMsg.append(keyBase);
        keyMsg.append(".");
        keyMsg.append("message");
        
        //åͤꤵƤ硢åιܤִ
        String msg = null;
        if(msgArgs != null && msgArgs.length != 0){
            msg = PropertyUtil.getString(keyMsg.toString(),msgArgs);
        }else{
            msg = PropertyUtil.getString(keyMsg.toString());
        }
        
        //٤ꤷơåϡ
        OutPutInfo outPutInfo = (OutPutInfo)m_outPutMap.get(priority);
        if(outPutInfo != null){
            isMsgOutPut = outPutInfo.isMsgOutPut();
            isFileOutPut = outPutInfo.isFileOutPut();
        }
        
        
        //å
        if( isMsgOutPut ){
            
            if( !putMsg(nowDate,moniterID,msgID,getPriority(priority),msg,detailMsg) ){
                //å˼Ԥ顢ե
                isFileOutPut = true;
            }
        }
        
        //ե
        if( isFileOutPut ){
            String priorityStr = (String)m_priorityMap.get(priority);
            if( priorityStr == null ){
                priorityStr = (String)m_priorityMap.get(PRIORITY_UNKNOWN);
            }
            putFile(nowDate,moniterID,msgID,priorityStr,msg,detailMsg);
        }
        
        
    }
    /**
     * .
     * 
     * @param moniterID		ƻID
     * @param msgID			åID
     * @since
     */
    public void put(String moniterID, String msgID) {

        put(moniterID, msgID,null,null);
    }
    /**
     * 
     * .
     * @param moniterID		ƻID
     * @param msgID			åID
     * @param msgArgs		åִ
     * @since
     */
    public void put(String moniterID, String msgID, Object[] msgArgs) {
        put(moniterID, msgID,msgArgs,null);

    }
    /**
     * .
     * 
     * @param moniterID		ƻID
     * @param msgID			åID
     * @param detailMsg		ܺ٥å
     * @since
     */
    public void put(String moniterID, String msgID, String detailMsg) {
        put(moniterID, msgID,null,detailMsg);

    }
    
    /**
     * ե.
     * եؤΥϤ.
     *  
     * @param genDate		
     * @param monitorId		ƻID
     * @param msgId			åID
     * @param priority		ʸ
     * @param msg			å
     * @param detailMsg		ܺ٥å
     * @since
     */
    public void putFile(Date genDate,String monitorId, String msgId, String priority, String msg, String detailMsg ) {

        //åԽ
        Object[] args ={genDate,m_pluginID, m_aplName, monitorId, msgId, priority, msg, detailMsg};
        String logmsg = m_logfmt.format(args);
        
        //ե
        FILE_LOGGER.info(logmsg);
        
    }

    /**
     * å.
     * å󥯥饹˥åȤơå.
     * 
     * @param genDate		
     * @param monitorId		ƻID
     * @param msgId			åID
     * @param priority		
     * @param msg			å
     * @param detailMsg		ܺ٥å
     * @return				true:/false
     * @since
     */
    private boolean putMsg(Date genDate,String monitorId, String msgId, int priority, String msg, String detailMsg) {

//    	Ͼ
//    	ץ饰ID			:󥹥ȥ饯
//    	ƻID			:󥹥ȥ饯
//    	եƥID		:SYSTEM 
//    					:ʤ
//    	ץꥱ		:󥹥ȥ饯꥽ե
//    	åID			:ѥ᡼
//    	å			:ѥ᡼꥽եʽ٤
//    	ꥸʥå	:ѥ᡼
//    					:ѥ᡼꥽ե
//    	ǧѤߥե饰		:NO
//    	ȯ				:᥽åɸƤӽФ˼
//    	ϥե饰		:true
//    	ơϥե饰	:false
//    	֡ʬ		:0
//    					:0
//    	ξ	:ʤ
//

        
        //å
		LogOutputInfo logOutput = new LogOutputInfo();
		logOutput.setPluginId(m_pluginID);
		logOutput.setMonitorId(monitorId);
		logOutput.setFacilityId("SYSTEM");
		logOutput.setScopeText("");
		logOutput.setApplication(m_aplName);
		logOutput.setMessageId(msgId);
		logOutput.setMessage(msg);
		logOutput.setMessageOrg(detailMsg == null ? "":detailMsg);
		logOutput.setPriority(priority);
		logOutput.setConfirmFlg( ConfirmConstant.booleanToType(false) );
		logOutput.setGenerationDate(genDate);
		logOutput.setEventLogFlg(true);
		logOutput.setStatusInfoFlg(false);
		logOutput.setExcludePeriod(0);
		logOutput.setExcludeNumber(0);
//		logOutput.setAddress(null);
		
		
        //å
        return m_sendQueue.put(logOutput);
    }

    /**
     * 
     * ʸ󤫤顢Priorityʬ
     * 
     * @param priority
     * @since
     */
    private int getPriority(String priority) {

        int ret = PriorityConstant.TYPE_UNKNOWN;

        if(priority.equals(PRIORITY_CRITICAL)){
            ret = PriorityConstant.TYPE_CRITICAL;
        }else if(priority.equals(PRIORITY_WARNING)){
            ret = PriorityConstant.TYPE_WARNING;
        }else if(priority.equals(PRIORITY_INFO)){
            ret = PriorityConstant.TYPE_INFO;
        }
        
        return ret;
        
    }
}
