/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.calendar.bean.AddListTableDefine;
import com.clustercontrol.calendar.bean.CalendarListTableDefine;
import com.clustercontrol.calendar.bean.ScheduleTableConstant;
import com.clustercontrol.calendar.bean.WeekdayListTableDefine;
import com.clustercontrol.calendar.factory.AddProperty;
import com.clustercontrol.calendar.factory.CalendarProperty;
import com.clustercontrol.calendar.factory.ModifyCalendar;
import com.clustercontrol.calendar.factory.SelectCalendar;
import com.clustercontrol.calendar.factory.WeekdayProperty;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="CalendarController"	
 *           jndi-name="CalendarController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class CalendarControllerBean implements javax.ejb.SessionBean {
    protected static Log m_log = LogFactory.getLog( CalendarControllerBean.class );
    
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * ơ֥
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getCalendarListTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(CalendarListTableDefine.CALENDAR_ID, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.CALENDAR_NAME, 
				new TableColumnInfo(Messages.getString("calendar.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.VALID_TIME_FROM, 
				new TableColumnInfo(Messages.getString("valid.time", locale) + "(" + Messages.getString("start", locale) + ")", 
						TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.VALID_TIME_TO, 
				new TableColumnInfo(Messages.getString("valid.time", locale) + "(" + Messages.getString("end", locale) + ")", 
						TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.CREATOR_NAME, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.MODIFIER_NAME, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.MODIFY_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.MODIFY_TIME + 1, 
				new TableColumnInfo("", TableColumnInfo.CHECKBOX, 0, SWT.LEFT));
		
		return tableDefine;
	}
	
	/**
	 * ̾ơ֥
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getWeekdayListTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(WeekdayListTableDefine.WEEKDAY, 
				new TableColumnInfo(Messages.getString("weekday", locale), TableColumnInfo.DAY_OF_WEEK, 80, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.TIME_FROM, 
				new TableColumnInfo(Messages.getString("timestamp", locale) + "(" + Messages.getString("start", locale) + ")", 
						TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.TIME_TO, 
				new TableColumnInfo(Messages.getString("timestamp", locale) + "(" + Messages.getString("end", locale) + ")", 
						TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATOR_NAME, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFIER_NAME, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFY_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ɲþơ֥
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getAddListTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(AddListTableDefine.EXECUTE, 
				new TableColumnInfo(Messages.getString("run", locale), TableColumnInfo.CHECKBOX, 50, SWT.LEFT));
		tableDefine.add(AddListTableDefine.TIME_FROM, 
				new TableColumnInfo(Messages.getString("time", locale) + "(" + Messages.getString("start", locale) + ")", 
						TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(AddListTableDefine.TIME_TO, 
				new TableColumnInfo(Messages.getString("time", locale) + "(" + Messages.getString("end", locale) + ")", 
						TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(AddListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATOR_NAME, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFIER_NAME, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFY_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ͽơ֥
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param base
	 * @param locale
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getScheduleTableDefine(Date base, Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(0, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 0, SWT.LEFT));
		for(int i = 0; i < ScheduleTableConstant.DAYS; i++){
			Calendar baseCalendar = Calendar.getInstance();
			baseCalendar.setTime(base);
			baseCalendar.add(Calendar.DAY_OF_MONTH, i);
			Date work = baseCalendar.getTime();
			tableDefine.add(i+1, 
					new TableColumnInfo(
							DateFormat.getDateInstance(DateFormat.SHORT, locale).format(work), 
							TableColumnInfo.SCHEDULE_ON_OFF, 70, SWT.LEFT));			
		}
		
		return tableDefine;
	}
	
	/**
	 * 
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return ֥Ȥ2
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getCalendarList() throws FinderException, NamingException {

		SelectCalendar select = new SelectCalendar();
		ArrayList list = select.getCalendarList();

		return list;
	}
	
	/**
	 * ̾
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return ֥Ȥ2
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getWeekdayList(String id) throws FinderException, NamingException {

		SelectCalendar select = new SelectCalendar();
		ArrayList list = select.getWeekdayList(id);

		return list;
	}
	
	/**
	 * ɲþ
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return ֥Ȥ2
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getAddList(String id) throws FinderException, NamingException {

		SelectCalendar select = new SelectCalendar();
		ArrayList list = select.getAddList(id);

		return list;
	}
	
	/**
	 * ͽ
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return ֥Ȥ2
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getSchedule(Date base) throws FinderException, NamingException {

		SelectCalendar select = new SelectCalendar();
		ArrayList list = select.getSchedule(base);

		return list;
	}
	
	/**
	 * ѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getCalendarProperty(String id, int mode, Locale locale) throws FinderException, NamingException {
		return new CalendarProperty().getProperty(id, mode, locale);
	}
	
	/**
	 * ɲ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * 
	 * @param property
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws NamingException 
	 */
	public void addCalendar(Property property) throws NamingException, CreateException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyCalendar modify = new ModifyCalendar();
		modify.addCalendar(property, pri.getName());
	}
	
	/**
	 * ѹ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param property
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public void modifyCalendar(Property property) throws NamingException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyCalendar modify = new ModifyCalendar();
		modify.modifyCalendar(property, pri.getName());
	}
		
	/**
	 * 
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws NamingException 
	 */
	public void deleteCalendar(String id) throws NamingException, RemoveException, FinderException  {
		ModifyCalendar modify = new ModifyCalendar();
		modify.deleteCalendar(id);
	}
	
	/**
	 * ̾ѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getWeekdayProperty(String id, Integer weekday, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
		return new WeekdayProperty().getProperty(id, weekday, from, to, mode, locale);
	}
	
	/**
	 * ̾ɲ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @param property
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws NamingException 
	 */
	public void addWeekday(String id, Property property) throws NamingException, CreateException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyCalendar modify = new ModifyCalendar();
		modify.addWeekday(id, property, pri.getName());
	}
	
	/**
	 * ̾ѹ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @param weekday
	 * @param from
	 * @param to
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws CreateException
	 */
	public void modifyWeekday(String id, Integer weekday, Date from, Date to, Property property) throws NamingException, FinderException, RemoveException, CreateException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyCalendar modify = new ModifyCalendar();
		modify.modifyWeekday(id, weekday, from, to, property, pri.getName());
	}
		
	/**
	 * ̾
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws NamingException 
	 */
	public void deleteWeekday(String id, Integer weekday, Date from, Date to) throws NamingException, RemoveException, FinderException  {
		ModifyCalendar modify = new ModifyCalendar();
		modify.deleteWeekday(id, weekday, from, to);
	}
	
	/**
	 * ɲþѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getAddInfoProperty(String id, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
		return new AddProperty().getProperty(id, from, to, mode, locale);
	}
	
	/**
	 * ɲþɲ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @param property
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws NamingException 
	 */
	public void addAddInfo(String id, Property property) throws NamingException, CreateException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyCalendar modify = new ModifyCalendar();
		modify.addAddInfo(id, property, pri.getName());
	}
	
	/**
	 * ɲþѹ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @param from
	 * @param to
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws CreateException
	 */
	public void modifyAddInfo(String id, Date from, Date to, Property property) throws NamingException, FinderException, RemoveException, CreateException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyCalendar modify = new ModifyCalendar();
		modify.modifyAddInfo(id, from, to, property, pri.getName());
	}
		
	/**
	 * ɲþ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws NamingException 
	 */
	public void deleteAddInfo(String id, Date from, Date to) throws NamingException, RemoveException, FinderException  {
		ModifyCalendar modify = new ModifyCalendar();
		modify.deleteAddInfo(id, from, to);
	}
	
	/**
	 * ¹ԥå
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param checkTimestamp
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Boolean isRun(String id, Date checkTimestamp) throws FinderException, NamingException {
		SelectCalendar select = new SelectCalendar();
		return select.isRun(id, checkTimestamp);
	}
	
	/**
	 * IDꥹȼå
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param checkTimestamp
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getCalendarIdList() throws FinderException, NamingException {
		SelectCalendar select = new SelectCalendar();
		ArrayList list = select.getCalendarIdList();

		return list;
	}
}
