/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.factory;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoPK;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ɲþѥץѥƥ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddProperty {
	/** (From) */
	public static final String TIME_FROM = "timeFrom";
	/** (To) */
	public static final String TIME_TO = "timeTo";
	/** ¹ */
	public static final String EXECUTE = "execute";
	/**  */
	public static final String DESCRIPTION = "description";
	/**  */
	public static final String CREATE_TIME = "createTimestamp";
	/**  */
	public static final String CREATOR_NAME = "creatorName";
	/**  */
	public static final String MODIFIER_NAME = "ModifierName";
	/**  */
	public static final String MODIFY_TIME = "ModifyTime";
	
	/**
	 * ɲþѥץѥƥ֤ޤ
	 * 
	 * @param id
	 * @param from
	 * @param to
	 * @param mode
	 * @param local
	 * @return ɲþѥץѥƥ
	 * @throws FinderException
	 * @throws NamingException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String id, Date from, Date to, int mode, Locale local) throws FinderException, NamingException {
		Property property = getProperty(mode, local);
		
		if(mode == PropertyConstant.MODE_MODIFY){
		    //̾
			CalendarAddInfoLocal info = 
				CalendarAddInfoUtil.getLocalHome().findByPrimaryKey(
						new CalendarAddInfoPK(id, from, to));
			
			if(info != null){
				//(From)
				ArrayList propertyList = PropertyUtil.getProperty(property, TIME_FROM);
				((Property)propertyList.get(0)).setValue(info.getTime_from());
				//(To)
				propertyList = PropertyUtil.getProperty(property, TIME_TO);
				((Property)propertyList.get(0)).setValue(info.getTime_to());
				//¹
				propertyList = PropertyUtil.getProperty(property, EXECUTE);
				((Property)propertyList.get(0)).setValue(new Boolean(ValidConstant.typeToBoolean(info.getExecute_flg().intValue())));
				//
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(info.getDescription() != null && info.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getDescription());
				}
				//Ͽ
				propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
				if(info.getReg_user() != null && info.getReg_user().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getReg_user());
				}
				//Ͽ
				propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
				if(info.getReg_date() != null){
					((Property)propertyList.get(0)).setValue(info.getReg_date());
				}
				//
				propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
				if(info.getUpdate_user() != null && info.getUpdate_user().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getUpdate_user());
				}
				//
				propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
				if(info.getUpdate_date() != null){
					((Property)propertyList.get(0)).setValue(info.getUpdate_date());
				}
			}
		}
		
		return property;
	}
	
	/**
	 * ɲþѥץѥƥ֤ޤ
	 * 
	 * @param mode
	 * @return ɲþѥץѥƥ
	 */
	public Property getProperty(int mode, Locale locale) {
		//(From)
		Property timeFrom =
			new Property(TIME_FROM, Messages.getString("time", locale) + "(" + Messages.getString("start", locale) + ")", 
					PropertyConstant.EDITOR_DATETIME);
		//(To)
		Property timeTo =
			new Property(TIME_TO, Messages.getString("time", locale) + "(" + Messages.getString("end", locale) + ")"
					, PropertyConstant.EDITOR_DATETIME);
	    //¹
		Property execute =
			new Property(EXECUTE, Messages.getString("run", locale), PropertyConstant.EDITOR_BOOL);
		//
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT);
		//Ͽ
		Property createTime =
			new Property(CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//Ͽ
		Property creatorName =
			new Property(CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT);
		//
		Property modifyTime =
			new Property(MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//
		Property modifierName =
			new Property(MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT);

		//ͤ
		timeFrom.setValue("");
		timeTo.setValue("");
		execute.setValue(new Boolean(true));
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");

		//⡼ɤˤꡢѹĵڤӥԡĤ
		if(mode == PropertyConstant.MODE_ADD){
			execute.setModify(PropertyConstant.MODIFY_OK);
			timeFrom.setModify(PropertyConstant.MODIFY_OK);
			timeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			execute.setModify(PropertyConstant.MODIFY_OK);
			timeFrom.setModify(PropertyConstant.MODIFY_OK);
			timeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(timeFrom);
		property.addChildren(timeTo);
		property.addChildren(execute);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);

		return property;
	}
}
