/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.factory;

import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoPK;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoUtil;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoUtil;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoPK;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyCalendar {
	protected static Log m_log = LogFactory.getLog(ModifyCalendar.class);

	/**
	 * ɲ
	 * 
	 * @param property
	 * @param userName
	 * @return
	 * @throws NamingException
	 * @throws CreateException
	 * @throws FinderException
	 */
	public void addCalendar(Property property, String userName) throws NamingException, CreateException, FinderException  {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	String id = null;
	    try {
			ArrayList values = null;
			//
			Date now = new Date();
			
			//ID
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.ID);
			id = (String)values.get(0);
			//̾
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.NAME);
			String name = (String)values.get(0);
			//
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.DESCRIPTION);
			String description = (String)values.get(0);
			//ͭ(From)
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.VALID_TIME_FROM);
			Date validTimeFrom = (Date)values.get(0);
			//ͭ(To)
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.VALID_TIME_TO);
			Date validTimeTo = (Date)values.get(0);
			
			//FROMTOå
			if(validTimeFrom.after(validTimeTo) || validTimeFrom.equals(validTimeTo)){
				throw new java.lang.IllegalArgumentException();
			}
			
			//
			CalendarInfoUtil.getLocalHome().create(
						id, 
						name,
						description, 
						null, 
						validTimeFrom, 
						validTimeTo, 
						now, 
						now, 
						userName, 
						userName);
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            String[] args = {id};
            apllog.put("SYS", "001", args);
            
            m_log.debug("addCalendar() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            String[] args = {id};
            apllog.put("SYS", "001", args);
            
            m_log.debug("addCalendar() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ѹ
	 * 
	 * @param property
	 * @param userName
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyCalendar(Property property, String userName) throws NamingException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	String id = null;
	    try {
			ArrayList values = null;
			Date now = new Date();
			
			//UID
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.ID);
			id = (String)values.get(0);
			
			//cal򸡺
			CalendarInfoLocal cal = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
			//̾cal
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.NAME);
			cal.setCalendar_name((String)values.get(0));
			//cal
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.DESCRIPTION);
			cal.setDescription((String)values.get(0));
			//ͭ(From)cal
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.VALID_TIME_FROM);
			cal.setValid_time_from((Date)values.get(0));
			//ͭ(To)cal
			values = PropertyUtil.getPropertyValue(property, CalendarProperty.VALID_TIME_TO);
			cal.setValid_time_to((Date)values.get(0));
			//Ԥcal
			cal.setUpdate_user(userName);
			//cal
			cal.setUpdate_date(now);
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            String[] args = {id};
            apllog.put("SYS", "002", args);
            
            m_log.debug("modifyCalendar() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            String[] args = {id};
            apllog.put("SYS", "002", args);
            
            m_log.debug("modifyCalendar() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * 
	 * 
	 * @param id
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void deleteCalendar(String id) throws NamingException, RemoveException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	try {
			//򸡺
			CalendarInfoLocal cal = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
			
			//ɲþ
			Collection addList = cal.getCalendarAddInfo();
            if(addList != null && addList.size() > 0){
                Object[] addArray = addList.toArray();
                for(int j = 0; j < addArray.length; j++){
                	CalendarAddInfoLocal add = 
                		(CalendarAddInfoLocal)addArray[j];
                    if(add != null){
                    	add.remove();
                    }
                }
            }
            
            //̾
			Collection weekdayList = cal.getCalendarWeekdayInfo();
            if(weekdayList != null && weekdayList.size() > 0){
                Object[] weekdayArray = weekdayList.toArray();
                for(int j = 0; j < weekdayArray.length; j++){
                	CalendarWeekdayInfoLocal weekday = 
                		(CalendarWeekdayInfoLocal)weekdayArray[j];
                    if(weekday != null){
                    	weekday.remove();
                    }
                }
            }
			
            //
			cal.remove();
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            String[] args = {id};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deleteCalendar() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            String[] args = {id};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deleteCalendar() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            String[] args = {id};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deleteCalendar() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ̾ɲ
	 * 
	 * @param id
	 * @param property
	 * @param userName
	 * @return
	 * @throws NamingException
	 * @throws CreateException
	 * @throws FinderException
	 */
	public void addWeekday(String id, Property property, String userName) throws NamingException, CreateException, FinderException  {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	int weekday = 0;
		Date from = null;
		Date to = null;
		try {
			ArrayList values = null;
			//
			Date now = new Date();
			
			//
			values = PropertyUtil.getPropertyValue(property, WeekdayProperty.WEEKDAY);
			weekday = DayOfWeekConstant.stringToType((String)values.get(0));
			//
			values = PropertyUtil.getPropertyValue(property, WeekdayProperty.DESCRIPTION);
			String description = (String)values.get(0);
			//ͭ(From)
			values = PropertyUtil.getPropertyValue(property, WeekdayProperty.TIME_FROM);
			from = (Date)values.get(0);
			//ͭ(To)
			values = PropertyUtil.getPropertyValue(property, WeekdayProperty.TIME_TO);
			to = (Date)values.get(0);
			
			//FROMTOå
			if(from.after(to) || from.equals(to)){
				throw new java.lang.IllegalArgumentException();
			}
			
			//Ӥνʣå
			Collection ct = 
				CalendarWeekdayInfoUtil.getLocalHome().findByTimeFromTo(
						id, new Integer(weekday), new Time(from.getTime()), new Time(to.getTime()));
			if(ct.size() > 0){
				throw new java.lang.IllegalArgumentException();
			}
			
			//̾
			CalendarWeekdayInfoUtil.getLocalHome().create(
						id, 
						new Integer(weekday),
						new Time(from.getTime()), 
						new Time(to.getTime()), 
						description, 
						now, 
						now, 
						userName, 
						userName);
			
		} catch (EJBException e) {
			AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, String.valueOf(weekday), formatter.format((Time)from), formatter.format((Time)to)};
			apllog.put("SYS", "004", args);
			
			m_log.debug("addWeekday() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("CAL", "cal");
			SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, String.valueOf(weekday), formatter.format((Time)from), formatter.format((Time)to)};
			apllog.put("SYS", "004", args);
			
			m_log.debug("addWeekday() : " + e.getMessage());
			throw e;
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("CAL", "cal");
			SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, String.valueOf(weekday), formatter.format((Time)from), formatter.format((Time)to)};
			apllog.put("SYS", "004", args);
			
			m_log.debug("addWeekday() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ̾ѹ
	 * 
	 * @param id
	 * @param property
	 * @param userName
	 * @return
	 * @throws NamingException
	 * @throws RemoveException
	 * @throws FinderException
	 */
	public void modifyWeekday(String id, Integer weekday, Date from, Date to, Property property, String userName) throws NamingException, RemoveException, CreateException, FinderException  {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	try {
			ArrayList values = null;
			//
			Date now = new Date();
			
			//̾
			CalendarWeekdayInfoLocal info = 
				CalendarWeekdayInfoUtil.getLocalHome().findByPrimaryKey(
						new CalendarWeekdayInfoPK(id, new Integer(weekday), new Time(from.getTime()), new Time(to.getTime())));
			Date createTimeStamp = info.getReg_date();
			String createUser = info.getReg_user();
			info.remove();
			
			//
			values = PropertyUtil.getPropertyValue(property, WeekdayProperty.WEEKDAY);
			int newWeekday = DayOfWeekConstant.stringToType((String)values.get(0));
			//
			values = PropertyUtil.getPropertyValue(property, WeekdayProperty.DESCRIPTION);
			String newDescription = (String)values.get(0);
			//ͭ(From)
			values = PropertyUtil.getPropertyValue(property, WeekdayProperty.TIME_FROM);
			Date newFrom = (Date)values.get(0);
			//ͭ(To)
			values = PropertyUtil.getPropertyValue(property, WeekdayProperty.TIME_TO);
			Date newTo = (Date)values.get(0);
			
			//Ӥνʣå
			Collection ct = 
				CalendarWeekdayInfoUtil.getLocalHome().findByTimeFromTo(
						id, new Integer(newWeekday), new Time(newFrom.getTime()), new Time(newTo.getTime()));
			if(ct.size() > 0){
				throw new java.lang.IllegalArgumentException();
			}
			
			//̾
			CalendarWeekdayInfoUtil.getLocalHome().create(
						id, 
						new Integer(newWeekday),
						new Time(newFrom.getTime()), 
						new Time(newTo.getTime()), 
						newDescription, 
						createTimeStamp, 
						now, 
						createUser, 
						userName);

		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, weekday.toString(), formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "006", args);
            
            m_log.debug("modifyWeekday() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, weekday.toString(), formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "006", args);
            
            m_log.debug("modifyWeekday() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, weekday.toString(), formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "006", args);
            
            m_log.debug("modifyWeekday() : " + e.getMessage());
			throw e;
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("CAL", "cal");
			SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, weekday.toString(), formatter.format((Time)from), formatter.format((Time)to)};
			apllog.put("SYS", "006", args);
			
			m_log.debug("modifyWeekday() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ̺
	 * 
	 * @param id
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void deleteWeekday(String id, Integer weekday, Date from, Date to) throws NamingException, RemoveException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	try {
			//̾
			CalendarWeekdayInfoLocal info = 
				CalendarWeekdayInfoUtil.getLocalHome().findByPrimaryKey(
						new CalendarWeekdayInfoPK(id, weekday, new Time(from.getTime()), new Time(to.getTime())));
			info.remove();

		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, String.valueOf(weekday), formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "005", args);
            
            m_log.debug("deleteWeekday() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, String.valueOf(weekday), formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "005", args);
            
            m_log.debug("deleteWeekday() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, String.valueOf(weekday), formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "005", args);
            
            m_log.debug("deleteWeekday() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ɲþɲ
	 * 
	 * @param id
	 * @param property
	 * @param userName
	 * @return
	 * @throws NamingException
	 * @throws CreateException
	 * @throws FinderException
	 */
	public void addAddInfo(String id, Property property, String userName) throws NamingException, CreateException, FinderException  {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	Date from = null;
		Date to = null;
		try {
			ArrayList values = null;
			//
			Date now = new Date();
			
			//
			values = PropertyUtil.getPropertyValue(property, AddProperty.DESCRIPTION);
			String description = (String)values.get(0);
			//ͭ(From)
			values = PropertyUtil.getPropertyValue(property, AddProperty.TIME_FROM);
			from = (Date)values.get(0);
			//ͭ(To)
			values = PropertyUtil.getPropertyValue(property, AddProperty.TIME_TO);
			to = (Date)values.get(0);
			//¹Լ
			values = PropertyUtil.getPropertyValue(property, AddProperty.EXECUTE);
			int execute = ValidConstant.booleanToType((Boolean)values.get(0));
			
			//FROMTOå
			if(from.after(to) || from.equals(to)){
				throw new java.lang.IllegalArgumentException();
			}
			
			//Ӥνʣå
			Collection ct = 
				CalendarAddInfoUtil.getLocalHome().findByTimeFromTo(
						id, from, to);
			if(ct.size() > 0){
				throw new java.lang.IllegalArgumentException();
			}
			
			//ɲþ
			CalendarAddInfoUtil.getLocalHome().create(
						id, 
						from, 
						to, 
						new Integer(execute),
						description, 
						now, 
						now, 
						userName, 
						userName);
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "007", args);
            
            m_log.debug("addAddInfo() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "007", args);
            
            m_log.debug("addAddInfo() : " + e.getMessage());
			throw e;
		} catch (CreateException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "007", args);
            
            m_log.debug("addAddInfo() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ɲþѹ
	 * 
	 * @param id
	 * @param property
	 * @param userName
	 * @return
	 * @throws NamingException
	 * @throws CreateException
	 * @throws FinderException
	 */
	public void modifyAddInfo(String id, Date from, Date to, Property property, String userName) throws NamingException, RemoveException, CreateException, FinderException  {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	try {
			ArrayList values = null;
			//
			Date now = new Date();
			
			//ɲþ
			CalendarAddInfoLocal info = 
				CalendarAddInfoUtil.getLocalHome().findByPrimaryKey(
						new CalendarAddInfoPK(id, from, to));
			Date createTimeStamp = info.getReg_date();
			String createUser = info.getReg_user();
			info.remove();
			
			//
			values = PropertyUtil.getPropertyValue(property, AddProperty.DESCRIPTION);
			String newDescription = (String)values.get(0);
			//ͭ(From)
			values = PropertyUtil.getPropertyValue(property, AddProperty.TIME_FROM);
			Date newFrom = (Date)values.get(0);
			//ͭ(To)
			values = PropertyUtil.getPropertyValue(property, AddProperty.TIME_TO);
			Date newTo = (Date)values.get(0);
			//¹Լ
			values = PropertyUtil.getPropertyValue(property, AddProperty.EXECUTE);
			int newExecute = ValidConstant.booleanToType((Boolean)values.get(0));
			
			//Ӥνʣå
			Collection ct = 
				CalendarAddInfoUtil.getLocalHome().findByTimeFromTo(
						id, newFrom, newTo);
			if(ct.size() > 0){
				throw new java.lang.IllegalArgumentException();
			}
			
			//ɲþ
			CalendarAddInfoUtil.getLocalHome().create(
						id, 
						newFrom, 
						newTo, 
						new Integer(newExecute),
						newDescription, 
						createTimeStamp, 
						now, 
						createUser, 
						userName);
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "009", args);
            
            m_log.debug("modifyAddInfo() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "009", args);
            
            m_log.debug("modifyAddInfo() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "009", args);
            
            m_log.debug("modifyAddInfo() : " + e.getMessage());
			throw e;
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("CAL", "cal");
			SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
			apllog.put("SYS", "009", args);
			
			m_log.debug("modifyAddInfo() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ɲú
	 * 
	 * @param id
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void deleteAddInfo(String id, Date from, Date to) throws NamingException, RemoveException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.CALENDER);
    	
    	try {
			//ɲþ
			CalendarAddInfoLocal info = 
				CalendarAddInfoUtil.getLocalHome().findByPrimaryKey(
						new CalendarAddInfoPK(id, from, to));
			info.remove();
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "008", args);
            
            m_log.debug("deleteAddInfo() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "008", args);
            
            m_log.debug("deleteAddInfo() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
			String[] args = {id, formatter.format((Time)from), formatter.format((Time)to)};
            apllog.put("SYS", "008", args);
            
            m_log.debug("deleteAddInfo() : " + e.getMessage());
			throw e;
		}
	}
}
