/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.factory;

import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.calendar.bean.RunConstant;
import com.clustercontrol.calendar.bean.ScheduleTableConstant;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoUtil;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoUtil;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoUtil;

/**
 * 饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SelectCalendar {

    /**
     * 
     * 
     * ֥Ȥ2Ȥ֤
     * 
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    @SuppressWarnings("unchecked")
	public ArrayList getCalendarList() throws FinderException, NamingException {
        ArrayList list = new ArrayList();
  
        //
        Collection ct = CalendarInfoUtil.getLocalHome().findAll();
        
	    if(ct != null){
            Iterator itr = ct.iterator();
            while(itr.hasNext()){
            	CalendarInfoLocal cal = (CalendarInfoLocal)itr.next();
                
                ArrayList info = new ArrayList();
                info.add(cal.getCalendar_id());
                info.add(cal.getCalendar_name());
                info.add(cal.getValid_time_from());
                info.add(cal.getValid_time_to());
                info.add(cal.getDescription());
                info.add(cal.getReg_user());
                info.add(cal.getReg_date());
                info.add(cal.getUpdate_user());
                info.add(cal.getUpdate_date());
                info.add(new Boolean(true));
                list.add(info);
            }
	    }
	    
        return list;
    }
    
    /**
     * ̾
     * 
     * ֥Ȥ2Ȥ֤
     * 
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    @SuppressWarnings("unchecked")
	public ArrayList getWeekdayList(String id) throws FinderException, NamingException {
        ArrayList list = new ArrayList();
  
        //ID̾
        Collection ct = CalendarWeekdayInfoUtil.getLocalHome().findByCalendarId(id);
        
	    if(ct != null){
            Iterator itr = ct.iterator();
            while(itr.hasNext()){
            	CalendarWeekdayInfoLocal cal = (CalendarWeekdayInfoLocal)itr.next();
                
                ArrayList info = new ArrayList();
                info.add(cal.getWeekday());
                info.add(cal.getTime_from());
                info.add(cal.getTime_to());
                info.add(cal.getDescription());
                info.add(cal.getReg_user());
                info.add(cal.getReg_date());
                info.add(cal.getUpdate_user());
                info.add(cal.getUpdate_date());
                list.add(info);
            }
	    }
	    
        return list;
    }
    
    /**
     * ɲþ
     * 
     * ֥Ȥ2Ȥ֤
     * 
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    @SuppressWarnings("unchecked")
	public ArrayList getAddList(String id) throws FinderException, NamingException {
        ArrayList list = new ArrayList();
  
        //IDɲþ
        Collection ct = CalendarAddInfoUtil.getLocalHome().findByCalendarId(id);
        
	    if(ct != null){
            Iterator itr = ct.iterator();
            while(itr.hasNext()){
            	CalendarAddInfoLocal cal = (CalendarAddInfoLocal)itr.next();
                
                ArrayList info = new ArrayList();
                info.add(new Boolean(RunConstant.typeToBoolean(cal.getExecute_flg().intValue())));
                info.add(cal.getTime_from());
                info.add(cal.getTime_to());
                info.add(cal.getDescription());
                info.add(cal.getReg_user());
                info.add(cal.getReg_date());
                info.add(cal.getUpdate_user());
                info.add(cal.getUpdate_date());
                list.add(info);
            }
	    }
	    
        return list;
    }
    
    /**
     * ɲþ
     * 
     * ֥Ȥ2Ȥ֤
     * 
     * @param base
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    @SuppressWarnings("unchecked")
	public ArrayList getSchedule(Date base) throws FinderException, NamingException {
        ArrayList list = new ArrayList();
  
        //
        Collection ct = CalendarInfoUtil.getLocalHome().findAll();
        
	    if(ct != null){
            Iterator itr = ct.iterator();
            while(itr.hasNext()){
            	CalendarInfoLocal cal = (CalendarInfoLocal)itr.next();
                
                ArrayList info = new ArrayList();
                info.add(cal.getCalendar_id());
                
        		for(int i = 0; i < ScheduleTableConstant.DAYS; i++){
            		Calendar baseCalendar = Calendar.getInstance();
            		baseCalendar.setTime(base);
        			baseCalendar.add(Calendar.DAY_OF_MONTH, i);
        			Date work = baseCalendar.getTime();
        			if(isSchedule(cal.getCalendar_id(), work)){
        				info.add(work);
        			}
        			else{
        				info.add(null);
        			}
        		}
        		list.add(info);
            }
	    }
	    
        return list;
    }
    
    /**
     * ¹ԥå
     * 
     * ꥫˤơꤷ¹ԲǽåBool֤ͤ
     * 
     * @param id
     * @param checkTimestamp
     * @return 
     * @throws FinderException
     * @throws NamingException
     */
	public Boolean isRun(String id, Date checkTimestamp) throws FinderException, NamingException {
    	Boolean run = new Boolean(false);
  
        //
    	CalendarInfoLocal cal = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
        if(cal != null){
        	if(checkTimestamp.after(cal.getValid_time_from()) && 
        			checkTimestamp.before(cal.getValid_time_to())){

	        	//ɲþ
	        	Collection ct = cal.getCalendarAddInfo();
	            Iterator itr = ct.iterator();
	            while(itr.hasNext()){
	            	CalendarAddInfoLocal add = (CalendarAddInfoLocal)itr.next();
	            	Boolean check = isRunByAddInfo(add, checkTimestamp);
	                if(check != null){
	                	if(check.booleanValue()){
	                		run = new Boolean(true);
	                	}
	                	else{
	                		run = new Boolean(false);
	                	}
	                	return run;
	                }
	            }
	            
	        	//̾
	        	ct = cal.getCalendarWeekdayInfo();
	            itr = ct.iterator();
	            while(itr.hasNext()){
	            	CalendarWeekdayInfoLocal weekday = (CalendarWeekdayInfoLocal)itr.next();
	                if(isRunByWeekdayInfo(weekday, checkTimestamp)){
	                	run = new Boolean(true);
	                	return run;
	                }
	            }
        	}
	    }
	    
        return run;
    }
    
    /**
     * ¹ԥåɲþ
     * 
     * ꥫɲþˤơꤷ¹ԲǽåBool֤ͤ
     * 
     * @param id
     * @param checkTimestamp
     * @return 
     * @throws FinderException
     * @throws NamingException
     */
	protected Boolean isRunByAddInfo(CalendarAddInfoLocal add, Date checkTimestamp) {
    	Boolean run = null;
  
        if(add != null){
        	if(checkTimestamp.after(add.getTime_from()) && 
        			checkTimestamp.before(add.getTime_to())){
        		run = new Boolean(RunConstant.typeToBoolean(add.getExecute_flg().intValue()));
        	}
	    }
	    
        return run;
    }
	
    /**
     * ¹ԥå̾
     * 
     * ꥫ̾ˤơꤷ¹ԲǽåBool֤ͤ
     * 
     * @param id
     * @param checkTimestamp
     * @return 
     * @throws FinderException
     * @throws NamingException
     */
	protected Boolean isRunByWeekdayInfo(CalendarWeekdayInfoLocal weekday, Date checkTimestamp) {
    	Boolean run = new Boolean(false);
    	
    	Calendar work = Calendar.getInstance();
    	work.setTime(checkTimestamp);
    	int dayOfWeek = work.get(Calendar.DAY_OF_WEEK);
    	
    	Calendar checkCalendar = Calendar.getInstance();
    	checkCalendar.set(Calendar.YEAR, 1970);
    	checkCalendar.set(Calendar.MONTH, 0);
    	checkCalendar.set(Calendar.DAY_OF_MONTH, 1);
    	checkCalendar.set(Calendar.HOUR_OF_DAY, work.get(Calendar.HOUR_OF_DAY));
    	checkCalendar.set(Calendar.MINUTE, work.get(Calendar.MINUTE));
    	checkCalendar.set(Calendar.SECOND, work.get(Calendar.SECOND));
        Time checkTime = new Time(checkCalendar.getTime().getTime());

        if(weekday != null && dayOfWeek == weekday.getWeekday().intValue()){
        	if(checkTime.after(weekday.getTime_from()) && 
        			checkTime.before(weekday.getTime_to())){
        		run = new Boolean(true);
        	}
	    }
	    
        return run;
    }
	
    /**
     * ͽå
     * 
     * ꥫˤơꤷդ˼¹ԲǽʻӤ뤫åBool֤ͤ
     * 
	 * @param id
	 * @param checkTimestamp
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Boolean isSchedule(String id, Date checkTimestamp) throws FinderException, NamingException {
    	Boolean run = new Boolean(false);
  
        //
    	CalendarInfoLocal cal = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
        if(cal != null){
        	if(checkTimestamp.after(cal.getValid_time_from()) && 
        			checkTimestamp.before(cal.getValid_time_to())){
		    	//ɲþ
		        if(isScheduleByAddInfo(id, checkTimestamp)){
		        	run = new Boolean(true);
		        	return run;
		        }
		        
		    	//̾
		        if(isScheduleByWeekdayInfo(id, checkTimestamp)){
		        	run = new Boolean(true);
		        	return run;
		        }
        	}
        }
	    
        return run;
    }
	
    /**
     * ͽåɲþ
     * 
     * ꥫɲþˤơꤷդ˼¹ԲǽʻӤ뤫åBool֤ͤ
     * 
     * @param id
     * @param checkTimestamp
     * @return 
     * @throws FinderException
     * @throws NamingException
     */
	protected Boolean isScheduleByAddInfo(String id, Date checkTimestamp) {
    	Boolean run = new Boolean(false);
  
		try {
			if(id != null && id.length() > 0){
				Collection ct = CalendarAddInfoUtil.getLocalHome().selectSchdule(id, checkTimestamp);
				if(ct.size() > 0){
					run = new Boolean(true);
				}
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
            
        return run;
    }
	
    /**
     * ͽå̾
     * 
     * ꥫ̾ˤơꤷդ˼¹ԲǽʻӤ뤫åBool֤ͤ
     * 
     * @param id
     * @param checkTimestamp
     * @return 
     * @throws FinderException
     * @throws NamingException
     */
	protected Boolean isScheduleByWeekdayInfo(String id, Date checkTimestamp) {
    	Boolean run = new Boolean(false);
    	
    	Calendar work = Calendar.getInstance();
    	work.setTime(checkTimestamp);
    	int dayOfWeek = work.get(Calendar.DAY_OF_WEEK);

		try {
			if(id != null && id.length() > 0){
				Collection ct = CalendarWeekdayInfoUtil.getLocalHome().findByWeekday(id, new Integer(dayOfWeek));
				if(ct.size() > 0){
					
					Iterator itr = ct.iterator();
					while(itr.hasNext()){
						// 
						CalendarWeekdayInfoLocal weekday = (CalendarWeekdayInfoLocal)itr.next();
						
						long timeFrom = weekday.getTime_from().getTime();
						long timeTo = weekday.getTime_to().getTime();
						
						// ꥫɲþˤơꤷդ˼¹ԲǽʻӤ뤫å
						Calendar baseCalendar = Calendar.getInstance();
						baseCalendar.setTimeInMillis(timeFrom);
						work.set(Calendar.HOUR_OF_DAY, baseCalendar.get(Calendar.HOUR_OF_DAY));
						work.set(Calendar.MINUTE, baseCalendar.get(Calendar.MINUTE));
						work.set(Calendar.SECOND,baseCalendar.get(Calendar.SECOND));
						work.set(Calendar.MILLISECOND,0);
				        Date start = work.getTime();
				        
				        baseCalendar.setTimeInMillis(timeTo);
				        work.set(Calendar.HOUR_OF_DAY, baseCalendar.get(Calendar.HOUR_OF_DAY));
				        work.set(Calendar.MINUTE, baseCalendar.get(Calendar.MINUTE));
				        work.set(Calendar.SECOND, baseCalendar.get(Calendar.SECOND));
				        work.set(Calendar.MILLISECOND,0);
				        Date end = work.getTime();
						
				        Collection ctNo = CalendarAddInfoUtil.getLocalHome().selectNoSchdule(id, start, end);
						if(ctNo.size() <= 0){
							run = new Boolean(true);
							return run;
						}
					}
				}
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
        return run;
    }
	
    /**
     * ID
     * 
     * @return
     * @throws FinderException
     * @throws NamingException
     */
	@SuppressWarnings("unchecked")
	public ArrayList getCalendarIdList() throws FinderException, NamingException {
        ArrayList list = new ArrayList();
  
        //
        Collection ct = CalendarInfoUtil.getLocalHome().findAll();
        
	    if(ct != null){
            Iterator itr = ct.iterator();
            while(itr.hasNext()){
            	CalendarInfoLocal cal = (CalendarInfoLocal)itr.next();

                list.add(cal.getCalendar_id());
            }
	    }
	    
        return list;
    }
}
