/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * CommonTableTreeViewer饹Ѥ˥ĥ꡼¤뤿Υ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonTableTreeItem implements Serializable {
    /**  */
    private CommonTableTreeItem parent = null;

    /** 󥪥֥ */
    private ArrayList data = null;

    /** ҤγǼꥹ */
    private List childrens = null;

    /**
     * ξݻ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ֥
     * @param data
     *            ׾󥪥֥
     */
    public CommonTableTreeItem(CommonTableTreeItem parent, ArrayList data) {

        this.setParent(parent);
        this.setData(data);

        if (parent != null) {
            parent.addChildren(this);
        }

        this.childrens = new ArrayList();
    }

    /**
     * Ƥ֤ޤ
     * 
     * @return 
     */
    public CommonTableTreeItem getParent() {
        return this.parent;
    }

    /**
     * Ƥꤷޤ
     * <p>
     * 
     * 󥹥󥹲κݤ˿ƤشطդƤ뤿ᡢҤ᥽åɤ ˲Ļ()礷Ʋ <br>
     * ޤƤؤδطդԤ褦˼Ʋ
     * 
     * @return 
     */
    public void setParent(CommonTableTreeItem parent) {
        this.parent = parent;
    }

    /**
     * ֤ޤ
     * 
     * @return 
     */
    public ArrayList getData() {
        return this.data;
    }

    /**
     * ꤷޤ
     * 
     * @param data
     *            
     */
    public void setData(ArrayList data) {
        this.data = data;
    }

    /**
     * Ҥɲäޤ
     * <p>
     * 
     * κݡchildeοƤϤΥ֥ȤȤꤵޤ
     * 
     * @param child
     *            
     */
    public void addChildren(CommonTableTreeItem child) {
        child.setParent(this);
        childrens.add(child);
    }

    /**
     * Ҥο֤ޤ
     * 
     * @return Ҥο
     */
    public int size() {
        return childrens.size();
    }

    /**
     * ƤλҤ֤ޤ
     * <p>
     * 
     * ¤ӽϡɲä줿ȤʤäƤޤ
     * 
     * @return Ƥλҡ
     */
    public CommonTableTreeItem[] getChildren() {
        CommonTableTreeItem[] result = new CommonTableTreeItem[this.size()];
        return (CommonTableTreeItem[]) childrens.toArray(result);
    }
}