/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * ǧ/̤ǧ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ConfirmConstant {
    /** ǧ */
    public static final int TYPE_CONFIRMED = 1;

    /** ̤ǧ */
    public static final int TYPE_UNCONFIRMED = 0;

    /** ǧ */
    public static final String STRING_CONFIRMED = Messages
            .getString("monitor.confirmed");

    /** ̤ǧ */
    public static final String STRING_UNCONFIRMED = Messages
            .getString("monitor.unconfirmed");

    /** ǧ */
    public static final boolean BOOLEAN_CONFIRMED = true;

    /** ̤ǧ */
    public static final boolean BOOLEAN_UNCONFIRMED = false;

    /**
     * ̤ʸѴ
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_CONFIRMED) {
            return STRING_CONFIRMED;
        } else if (type == TYPE_UNCONFIRMED) {
            return STRING_UNCONFIRMED;
        }
        return "";
    }

    /**
     * ʸ󤫤̤Ѵ
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_CONFIRMED)) {
            return TYPE_CONFIRMED;
        } else if (string.equals(STRING_UNCONFIRMED)) {
            return TYPE_UNCONFIRMED;
        }
        return -1;
    }

    /**
     * ̤booleanѴ
     * 
     * @param type
     * @return
     */
    public static boolean typeToBoolean(int type) {
        if (type == TYPE_CONFIRMED) {
            return BOOLEAN_CONFIRMED;
        } else if (type == TYPE_UNCONFIRMED) {
            return BOOLEAN_UNCONFIRMED;
        }
        return false;
    }

    /**
     * boolean̤Ѵ
     * 
     * @param bool
     * @return
     */
    public static int booleanToType(boolean bool) {
        if (bool == BOOLEAN_CONFIRMED) {
            return TYPE_CONFIRMED;
        } else if (bool == BOOLEAN_UNCONFIRMED) {
            return TYPE_UNCONFIRMED;
        }
        return -1;
    }
}