/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

/**
 * ׾ĥ꡼¤뤿Υ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityPath {
    protected String separator;

    public FacilityPath(String separator) {
        this.separator = separator;
    }

    /**
     * ĥ꡼ƥοƻҴطɽѥʸ֤ޤ
     * <p>
     * 
     * getPath()  "⥷ƥ>ܵҴ>WEB"
     * 
     * @param separator
     *            ѥ졼
     * @return ѥʸ
     */
    public String getPath(FacilityTreeItem item) {

        if (item == null) {
            return "";
        }

        // ȥå("")ξϡʸϤޤ
        if (item.getData().getType() == FacilityConstant.TYPE_COMPOSITE) {
            return "";
        }

        StringBuffer buffer = new StringBuffer();

        buffer.append(item.getData().getFacilityName());

        // פξϡǸ">"ɲ
        if (item.getData().getType() == FacilityConstant.TYPE_SCOPE) {
            FacilityTreeItem parent = item.getParent();
            while (parent != null
                    && parent.getData().getType() != FacilityConstant.TYPE_COMPOSITE) {

                buffer.insert(0, separator);
                buffer.insert(0, parent.getData().getFacilityName());
                parent = parent.getParent();
            }
            buffer.append(separator);
        }

        return buffer.toString();
    }

    /**
     * @return Returns the separator.
     */
    public String getSeparator() {
        return separator;
    }

    /**
     * @param separator
     *            The separator to set.
     */
    public void setSeparator(String separator) {
        this.separator = separator;
    }
}