/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;

import org.eclipse.jface.viewers.CellEditor;

/**
 * ץѥƥ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
abstract public class PropertyDefine implements Serializable {
    /** ǻѤCellEditor */
    protected CellEditor m_cellEditor;

    /**
     * ơ֥ɽʸ
     * 
     * @param value
     *            ץѥƥ
     * @return ɽʸ
     * @since 1.0.0
     */
    abstract public String getColumnText(Object value);

    /**
     * ǥϤͤǥ֤
     * 
     * @param element
     *            ץѥƥ
     * @return ǥ
     * @since 1.0.0
     */
    abstract public Object getValue(Property element);

    /**
     * ǥˤäѹ줿ͤǥ˳Ǽ
     * 
     * @param element
     *            ץѥƥ
     * @param value
     *            ǥ
     * @since 1.0.0
     */
    abstract public void modify(Property element, Object value);

    /**
     * ǥνԤ
     * PropertySheetModifiercellEditor.create(composite);μ¹Ը˸ƤӽФ롣
     * 
     * @since 1.0.0
     */
    abstract public void initEditer();

    /**
     * CellEditor
     * 
     * @return cellEditor
     * @since 1.0.0
     */
    public CellEditor getCellEditor() {
        return m_cellEditor;
    }

    /**
     * CellEditor
     * 
     * @param cellEditor
     * @since 1.0.0
     */
    public void setCellEditor(CellEditor cellEditor) {
        m_cellEditor = cellEditor;
    }

}