/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * ץѥƥѥĥ꡼ƥ९饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class PropertyTreeItem implements Serializable {
    /** ƥץѥƥ */
    protected PropertyTreeItem m_Parent;

    /** ҥץѥƥ */
    protected List m_Children = new ArrayList();

    /** ץѥƥID */
    protected String m_ID;

    /** ץѥƥ̾ */
    protected String m_Name;

    /**
     * @return children ᤷޤ
     * @since 1.0.0
     */
    public Object[] getChildren() {
        return m_Children.toArray();
    }

    /**
     * @return children ᤷޤ
     * @since 1.0.0
     */
    public void removeChildren() {
        for (int i = 0; i < m_Children.size(); i++) {
            ((Property) m_Children.get(i)).setParent(null);
        }
        m_Children.removeAll(m_Children);
    }

    /**
     * @param child
     * @since 1.0.0
     */
    public void removeChildren(PropertyTreeItem child) {
        m_Children.remove(child);
    }

    /**
     * @param children
     *            children ꡣ
     * @since 1.0.0
     */
    public void addChildren(PropertyTreeItem child) {
        m_Children.add(child);
        child.setParent(this);
    }

    /**
     * @param children
     *            children ꡣ
     * @param index
     *            ɲð
     * @since 1.0.0
     */
    public void addChildren(PropertyTreeItem child, int index) {
        m_Children.add(index, child);
        child.setParent(this);
    }

    /**
     * @return iD ᤷޤ
     * @since 1.0.0
     */
    public String getID() {
        return m_ID;
    }

    /**
     * @param id
     *            iD ꡣ
     * @since 1.0.0
     */
    public void setID(String id) {
        m_ID = id;
    }

    /**
     * @return name ᤷޤ
     * @since 1.0.0
     */
    public String getName() {
        return m_Name;
    }

    /**
     * @param name
     *            name ꡣ
     * @since 1.0.0
     */
    public void setName(String name) {
        m_Name = name;
    }

    /**
     * @return parent ᤷޤ
     * @since 1.0.0
     */
    public PropertyTreeItem getParent() {
        return m_Parent;
    }

    /**
     * @param parent
     *            parent ꡣ
     * @since 1.0.0
     */
    public void setParent(PropertyTreeItem parent) {
        m_Parent = parent;
    }

    /**
     * @param ҥץѥƥᤷޤ
     * @since 1.0.0
     */
    public int size() {
        return m_Children.size();
    }
}