/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * 饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ValidConstant {
    /** ͭ(ͭ/̵μ) */
    public static final int TYPE_VALID = 1;

    /** ̵(ͭ/̵μ) */
    public static final int TYPE_INVALID = 0;

    /** ͭ(ͭ/̵μ) */
    public static final String STRING_VALID = Messages.getString("valid");

    /** ̵(ͭ/̵μ) */
    public static final String STRING_INVALID = Messages.getString("invalid");

    /** ͭ(ͭ/̵μ) */
    public static final boolean BOOLEAN_VALID = true;

    /** ̵(ͭ/̵μ) */
    public static final boolean BOOLEAN_INVALID = false;

    /**
     * ̤ʸѴ
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_VALID) {
            return STRING_VALID;
        } else if (type == TYPE_INVALID) {
            return STRING_INVALID;
        }
        return "";
    }

    /**
     * ʸ󤫤̤Ѵ
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_VALID)) {
            return TYPE_VALID;
        } else if (string.equals(STRING_INVALID)) {
            return TYPE_INVALID;
        }
        return -1;
    }

    /**
     * ̤booleanѴ
     * 
     * @param type
     * @return
     */
    public static boolean typeToBoolean(int type) {
        if (type == TYPE_VALID) {
            return BOOLEAN_VALID;
        } else if (type == TYPE_INVALID) {
            return BOOLEAN_INVALID;
        }
        return false;
    }

    /**
     * boolean̤Ѵ
     * 
     * @param bool
     * @return
     */
    public static int booleanToType(boolean bool) {
        if (bool == BOOLEAN_VALID) {
            return TYPE_VALID;
        } else if (bool == BOOLEAN_INVALID) {
            return TYPE_INVALID;
        }
        return -1;
    }
}