/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * 饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class YesNoConstant {
    /** Yes */
    public static final int TYPE_YES = 1;

    /** No */
    public static final int TYPE_NO = 0;

    /** Yes */
    public static final String STRING_YES = Messages.getString("yes");

    /** No */
    public static final String STRING_NO = Messages.getString("no");

    /** Yes */
    public static final boolean BOOLEAN_YES = true;

    /** No */
    public static final boolean BOOLEAN_NO = false;

    /**
     * ̤ʸѴ
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_YES) {
            return STRING_YES;
        } else if (type == TYPE_NO) {
            return STRING_NO;
        }
        return "";
    }

    /**
     * ʸ󤫤̤Ѵ
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_YES)) {
            return TYPE_YES;
        } else if (string.equals(STRING_NO)) {
            return TYPE_NO;
        }
        return -1;
    }

    /**
     * ̤booleanѴ
     * 
     * @param type
     * @return
     */
    public static boolean typeToBoolean(int type) {
        if (type == TYPE_YES) {
            return BOOLEAN_YES;
        } else if (type == TYPE_NO) {
            return BOOLEAN_NO;
        }
        return false;
    }

    /**
     * boolean̤Ѵ
     * 
     * @param bool
     * @return
     */
    public static int booleanToType(boolean bool) {
        if (bool == BOOLEAN_YES) {
            return TYPE_YES;
        } else if (bool == BOOLEAN_NO) {
            return TYPE_NO;
        }
        return -1;
    }
}