/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.Messages;

/**
 * 桼饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetUserList {

    // ----- instance ᥽å ----- //

    /**
     * ƤΥ桼֤ޤ
     * 
     * @return 桼
     */
    public ArrayList getAll() {
    	AccessController access = EjbConnectionManager
        .getConnectionManager().getAccessController();

        ArrayList records = null;
        try {
            records = access.getUserList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }

    /**
     * propertyξ˥ҥåȤΡɤΰ֤ޤ
     * 
     * @param property
     * @return Ρɰ
     */
    public ArrayList get(Property property) {
    	AccessController access = EjbConnectionManager
        .getConnectionManager().getAccessController();

        ArrayList records = null;
        try {
        	records = access.getUserList(property);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}