/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.Messages;

/**
 * 桼ѹ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyUserProperty {

    /**
     * ꤷ桼ˤĤơ°ѹԤޤ
     * 
     * @param property °
     * @return ѹ硢true
     */
    public boolean edit(Property property) {
		AccessController access = 
			EjbConnectionManager.getConnectionManager().getAccessController();
		
        try {
        	access.modifyUser(property);
            return true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NamingException e) {
        } catch (FinderException e) {
        }
        return false;
    }
}