/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.util.Messages;

/**
 * 饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class LoginDialog extends Dialog {
    protected Text m_uidText = null;
    protected Text m_passwordText = null;
    protected String m_uid = null;
    protected String m_password = null;

    protected Shell m_shell = null;

    public LoginDialog(Shell parent) {
        super(parent);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets.Composite)
     */
    protected Control createContents(Composite parent) {
        Composite composite = (Composite) super.createContents(parent);

        // ꥢΥޥ
        this.customizeDialog((Composite) this.getDialogArea());

        // ϣ˥ܥΥƥѹ
        String okText = this.getOkButtonText();
        if (okText != null) {
            Button button = this.getButton(IDialogConstants.OK_ID);
            if (button != null) {
                button.setText(okText);
            }
        }

        // 󥻥ܥΥƥѹ
        String cancelText = this.getCancelButtonText();
        if (cancelText != null) {
            Button button = this.getButton(IDialogConstants.CANCEL_ID);
            if (button != null) {
                button.setText(cancelText);
            }
        }

        return composite;
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        m_shell = this.getShell();
        
        m_shell.setText(Messages
                .getString("dialog.accesscontrol.login"));

        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        parent.setLayout(layout);

        Composite composite = null;
        RowLayout rowLayout = null;

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label uidTitle = new Label(composite, SWT.NONE);
        uidTitle.setText(Messages.getString("user.id") + " : ");
        uidTitle.setLayoutData(new RowData(80, SizeConstant.SIZE_LABEL_HEIGHT));
        m_uidText = new Text(composite, SWT.BORDER);
        m_uidText.setLayoutData(new RowData(150, SizeConstant.SIZE_TEXT_HEIGHT));

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label passwordTitle = new Label(composite, SWT.NONE);
        passwordTitle.setText(Messages.getString("password") + " : ");
        passwordTitle.setLayoutData(new RowData(80, SizeConstant.SIZE_LABEL_HEIGHT));
        m_passwordText = new Text(composite, SWT.BORDER | SWT.PASSWORD);
        m_passwordText.setLayoutData(new RowData(150, SizeConstant.SIZE_TEXT_HEIGHT));

        new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);

        // 
        Display display = m_shell.getDisplay();
        m_shell.setLocation(
                (display.getBounds().width - m_shell.getSize().x) / 2, (display
                        .getBounds().height - m_shell.getSize().y) / 2);

        //桼IDȿ
        reflectUID();
    }
    
    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("login");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /**
     * 桼IDȿ
     * @since 1.0.0
     */
    private void reflectUID() {

    }
    
    /**
     * ϣ˥ܥ󤬲줿˸ƤФ᥽åɤǡͥå»ܤޤ
     * <p>
     * 
     * 顼ξ硢Ĥ˥顼ƤΤޤ
     */
    protected void okPressed() {
        ValidateResult result = this.validate();

        if (result == null || result.isValid()) {
            super.okPressed();
        } else {
            this.displayError(result);
        }
    }

    /**
     * ͥåԤޤ
     * 
     * ɬפ˱ơͥåƲ
     * 
     * @return ValidateResult֥
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        //桼ID
        if (m_uidText.getText().length() > 0) {
        	setUserid(m_uidText.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.accesscontrol.1"));
            return result;
        }
        
        //ѥɼ
        if (m_passwordText.getText().length() > 0) {
        	setPassword(m_passwordText.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.accesscontrol.2"));
            return result;
        }

        return null;
    }
    
    /**
     * 顼ƤΤޤ
     * <p>
     * 
     * ٹåܥåˤơ饤ȤΤޤ
     * 
     * @param result
     *            ValidateResult֥
     */
    protected void displayError(ValidateResult result) {
        MessageBox messageBox = new MessageBox(this.getShell(), SWT.OK
                | SWT.ICON_WARNING);

        messageBox.setText(result.getID());
        messageBox.setMessage(result.getMessage());

        messageBox.open();
    }

	public String getPassword() {
		return m_password;
	}

	public void setPassword(String password) {
		m_password = password;
	}

	public String getUserid() {
		return m_uid;
	}

	public void setUserid(String uid) {
		m_uid = uid;
	}
}