/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.logtransfer.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ž륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetLogTransfer {
	
	/**
	 * ž֤ޤ
	 * 
	 * @param transferId žID
	 * @return ž
	 */
	public LogTransferInfo getLogTransfer(String transferId) {
		
		LogTransferController logTransfer = EjbConnectionManager.getConnectionManager()
		.getLogTransferController();
		
		LogTransferInfo info = null;
		try {
			info = logTransfer.getLogTransfer(transferId);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return info;
	}
	
	/**
	 * ž֤ޤ
	 * 
	 * @return ž
	 */
	public ArrayList getLogTransferList() {
		
		LogTransferController logTransfer = EjbConnectionManager.getConnectionManager()
		.getLogTransferController();
		
		ArrayList records = null;
		try {
			records = logTransfer.getLogTransferList();
		} catch (RemoteException e) {
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return records;
	}
}