/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.logtransfer.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ž򹹿륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyLogTransfer {
	
	/**
	 * ž򹹿ޤ
	 * 
	 * @param info ž
	 * @return 硢true
	 */
	public boolean modify(LogTransferInfo info) {
		
		LogTransferController logTransfer = EjbConnectionManager.getConnectionManager().getLogTransferController();
		
		boolean result = false;
		try {
			result = logTransfer.modifyLogTransfer(info);
			return result;
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (RemoveException e) {
		} catch (NamingException e) {
		} catch (JMSException e) {
		}
		return false;
	}
}