/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.dialog;

import java.text.ParseException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.accesscontrol.action.AddUserProperty;
import com.clustercontrol.accesscontrol.action.GetUserProperty;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * 桼κѹ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserDialog extends CommonDialog {
    /** UID */
    private String uid = "";

    /** ѹѥȽ̥ե饰 */
    private boolean isModifyDialog = false;

    /** Ρ°ץѥƥ */
    private PropertySheet propertySheet = null;
    /**
     * ꤷΥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param uid
     *            桼ID
     * @param isModifyDialog
     *            ѹѥȤѤϡtrue
     */
    public UserDialog(Shell parent, String uid, boolean isModifyDialog) {
        super(parent);

        this.uid = uid;
        this.isModifyDialog = isModifyDialog;
    }
    
    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages
                .getString("dialog.accesscontrol.user.create.modify"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * °ץѥƥ
         */

        // ٥
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // ץѥƥ
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);
        this.propertySheet.setCopy(true);

        // ץѥƥڤ
        Property property = null;
        if (this.isModifyDialog) {
            property = new GetUserProperty().getProperty(this.uid,
                    PropertyConstant.MODE_MODIFY);
        } else {
            property = new GetUserProperty().getProperty(this.uid,
                    PropertyConstant.MODE_ADD);
        }
        this.propertySheet.setInput(property);
        this.propertySheet.expandAll();

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {

        return super.validate();
    }

    /**
     * ѹѥʤΤ֤ޤ
     * 
     * @return ѹѥξ硢true
     */
    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    /**
     * ͤݻǡǥޤ
     * 
     * @return ǡǥ
     */
    public Property getInputData() {
        return (Property) this.propertySheet.getInput();
    }

    /**
     * ͤݻǡǥꤷޤ
     * 
     * @param property
     */
    public void setInputData(Property property) {
        propertySheet.setInput(property);
    }

    /**
     * @return Returns the uid.
     */
    public String getUid() {
        return this.uid;
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        if (isModifyDialog()) {
            return Messages.getString("modify");
        } else {
            return Messages.getString("register");
        }
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

	@Override
	protected void okPressed() {
        ValidateResult result = this.validate();

        if (result == null || result.isValid()) {
        	//ѹ
        	if(this.isModifyDialog){
        		super.okPressed();
        	}
        	else{
        		Property addUserProperty = PropertyUtil.copy(getInputData());
                PropertyUtil.deletePropertyDefine(addUserProperty);
                try {
                	if (new AddUserProperty().add(addUserProperty)) {
                        // 
                        MessageBox box = new MessageBox(this.getShell(), SWT.ICON_INFORMATION);
                        box.setText(Messages.getString("successful"));
                        box.setMessage(Messages.getString("message.accesscontrol.7"));
                        box.open();
                    } else {
                        // 
                        MessageBox box = new MessageBox(this.getShell(), SWT.ICON_ERROR);
                        box.setText(Messages.getString("failed"));
                        box.setMessage(Messages.getString("message.accesscontrol.8"));
                        box.open();
                    }
				} catch (ParseException e) {
					// 桼ID˻ԲĤʸ󤬻ꤵƤ硢顼ɽ
					MessageDialog.openInformation(null, Messages.getString("message"),
		                    Messages.getString("message.accesscontrol.19"));
				}
        	}
        } else {
            this.displayError(result);
        }
	}
}