/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.etc.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.accesscontrol.dialog.LoginDialog;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PerspectiveUtil;

/**
 * 󥢥󥯥饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class LoginAction implements IWorkbenchWindowActionDelegate {
	public static final String ID = "com.clustercontrol.accesscontrol.etc.action.LoginAction";
	
	private IWorkbenchWindow m_window;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		m_window = window;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		
		if(LoginManager.getContextManager().isLogin()){
			// ƥǧ
    		MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), SWT.ICON_QUESTION|SWT.YES|SWT.NO);
            box.setText(Messages.getString("confirmed"));
            box.setMessage(Messages.getString("message.accesscontrol.17"));
            if (box.open() == SWT.NO) {
            	return;
            }
		}

		//ɽ
        LoginDialog dialog = 
        	new LoginDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());

        //ɽ
        if (dialog.open() == IDialogConstants.OK_ID) {
        	try {
        		//
        		LoginManager.getContextManager().logout();
        		
        		//HinemosPerspective򤹤٤Ĥ
        		PerspectiveUtil.closeAllHinemosPerspective();
        		
        		//
				LoginManager.getContextManager().login(dialog.getUserid(), dialog.getPassword());
				
	            // 
	            MessageBox box = new MessageBox(m_window.getShell(), SWT.ICON_INFORMATION);
	            box.setText(Messages.getString("successful"));
	            box.setMessage(Messages.getString("message.accesscontrol.5"));
	            box.open();
			} catch (Exception e) {
                // ԥ
                MessageBox box = new MessageBox(m_window.getShell(), SWT.ICON_ERROR);
                box.setText(Messages.getString("failed"));
                box.setMessage(Messages.getString("message.accesscontrol.6"));
                box.open();
			}
        }
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

	}

}
