/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.accesscontrol.composite.UserListComposite;
import com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction;
import com.clustercontrol.accesscontrol.view.action.UserAddAction;
import com.clustercontrol.accesscontrol.view.action.UserDeleteAction;
import com.clustercontrol.accesscontrol.view.action.UserModifyAction;
import com.clustercontrol.bean.Property;
import com.clustercontrol.view.CommonViewPart;

/**
 * 桼ӥ塼饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.accesscontrol.view.UserListView";

    private UserListComposite m_userList = null;

    /** ե륿 */
    private Property m_condition = null;

    /**
     * 󥹥ȥ饯
     */
    public UserListView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_userList = new UserListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_userList.setLayoutData(gridData);

        //ݥåץåץ˥塼
        createContextMenu();

        //ӥ塼򹹿
        this.update();
    }

    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_userList.getTable());
        m_userList.getTable().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
    	//ӥ塼ΥΥ󥹥󥹤
    	IToolBarManager toolbar = 
    		this.getViewSite().getActionBars().getToolBarManager();
    	ActionContributionItem userAdd = 
    		(ActionContributionItem) toolbar.find(UserAddAction.ID);
    	ActionContributionItem userModify = 
    		(ActionContributionItem) toolbar.find(UserModifyAction.ID);
    	ActionContributionItem userDelete = 
    		(ActionContributionItem) toolbar.find(UserDeleteAction.ID);
    	ActionContributionItem modifyPassword = 
    		(ActionContributionItem) toolbar.find(ModifyPasswordAction.ID);
    	
    	//ݥåץåץ˥塼˥ɲ
    	manager.add(userAdd.getAction());
    	manager.add(userModify.getAction());
    	manager.add(userDelete.getAction());
    	manager.add(modifyPassword.getAction());
    }

    /**
     * ե륿
     * 
     * @return ե륿
     */
    public Property getFilterCondition() {
        return m_condition;
    }

    /**
     * ե륿
     * 
     * @param condition
     *            ե륿
     */
    public void setFilterCondition(Property condition) {
        m_condition = condition;
    }

    /**
     * 桼ӥ塼
     */
    public void update() {
        if (m_condition == null) {
        	m_userList.update();
        } else {
        	m_userList.update(m_condition);
        }
    }

    /**
     * ˥ҥåȤ桼ΰɽޤ
     * 
     * conditionnullξ硢桼ɽޤ
     * 
     * @param condition 
     */
    public void update(Property condition) {
        this.m_condition = condition;

        this.update();
    }

    /**
     * ݥåȼ
     * 
     * @return
     */
    public UserListComposite getComposite() {
        return m_userList;
    }
}