/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view;

import java.util.Calendar;
import java.util.Date;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.calendar.composite.CalendarListComposite;
import com.clustercontrol.calendar.composite.CalendarScheduleComposite;
import com.clustercontrol.calendar.view.action.CalendarAddAction;
import com.clustercontrol.calendar.view.action.CalendarDeleteAction;
import com.clustercontrol.calendar.view.action.CalendarModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * ӥ塼饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.calendar.view.CalendarListView";

	private SashForm m_sash = null;
	
    private CalendarListComposite m_calendarList = null;
    
	private CalendarScheduleComposite m_schedule = null;
	
    protected Date m_base = null;
	
    /**
     * 󥹥ȥ饯
     */
    public CalendarListView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

		// åեڤ
        m_sash = new SashForm(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		m_sash.setLayoutData(gridData);
		
        m_calendarList = new CalendarListComposite(m_sash, SWT.NONE);

        Calendar baseCalendar = Calendar.getInstance();
        baseCalendar.setTime(new Date());
        baseCalendar.add(Calendar.WEEK_OF_MONTH, -1);
        m_base = new Date();
        m_schedule = new CalendarScheduleComposite(m_sash, SWT.NONE, baseCalendar.getTime());
        
		// SashζĴ 50% 50%
//        m_sash.setWeights(new int[] { 5, 5 });
		
        //ݥåץåץ˥塼
        createContextMenu();

        //ӥ塼򹹿
        this.update();
    }

    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_calendarList.getTable());
        m_calendarList.getTable().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
    	ActionContributionItem add = 
    		(ActionContributionItem) toolbar.find(CalendarAddAction.ID);
    	ActionContributionItem modify = 
    		(ActionContributionItem) toolbar.find(CalendarModifyAction.ID);
    	ActionContributionItem delete = 
    		(ActionContributionItem) toolbar.find(CalendarDeleteAction.ID);
    	
    	//ݥåץåץ˥塼˥ɲ
    	manager.add(add.getAction());
    	manager.add(modify.getAction());
    	manager.add(delete.getAction());
    }

    /**
     * ӥ塼
     */
    public void update() {
    	m_calendarList.update();
    	
    	Calendar now = Calendar.getInstance();
    	
		Calendar baseCalendar = Calendar.getInstance();
		baseCalendar.setTime(m_base);
		baseCalendar.set(Calendar.HOUR, now.get(Calendar.HOUR));
		baseCalendar.set(Calendar.MINUTE, now.get(Calendar.MINUTE));
		baseCalendar.set(Calendar.SECOND, now.get(Calendar.SECOND));
		m_base = baseCalendar.getTime();
		
    	if(!m_base.equals(m_schedule.getBaseDate())){
    		//ScheduleComposite
    		CreateScheduleComposite();
    	}
    	
    	m_schedule.update();
    }
    
    /**
     * ScheduleComposite
     */
    public void CreateScheduleComposite() {
		//ScheduleComposite
    	m_schedule.dispose();
		
        m_schedule = new CalendarScheduleComposite(m_sash, SWT.NONE, m_base);
	    
	    //SashForm
        m_sash.layout(true, true);
    }
    
    /**
     * ݥåȼ
     * 
     * @return
     */
    public CalendarListComposite getListComposite() {
        return m_calendarList;
    }
    
    /**
     * ݥåȼ
     * 
     * @return
     */
    public CalendarScheduleComposite getScheduleComposite() {
        return m_schedule;
    }
    
	/**
	 * ɽޤ
	 */
	public void showSchedule() {
		m_sash.setMaximizedControl(null);
	}
	
	/**
	 * ޤ
	 */
	public void hideSchedule() {
		m_sash.setMaximizedControl(m_calendarList);
	}
    
	/**
	 * @return
	 */
	public Date getBaseDate() {
		return m_base;
	}
	
	/**
	 * @param base
	 */
	public void setBaseDate(Date base) {
		m_base = base;
	}
}