/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view.action;

import java.util.Date;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.action.ModifyAddInfoProperty;
import com.clustercontrol.calendar.bean.AddListTableDefine;
import com.clustercontrol.calendar.dialog.AddInfoDialog;
import com.clustercontrol.calendar.view.AddInfoListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ɲþκѹˤ롢ɲþѹԤ󥯥饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddInfoModifyAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.calendar.view.action.AddInfoModifyAction";
	
    private IViewPart viewPart;

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        //ID
        AddInfoListView view = 
        	(AddInfoListView)this.viewPart.getAdapter(AddInfoListView.class);
        String calendarId = view.getComposite().getCalendarId();

        StructuredSelection selection = (StructuredSelection) view
                .getComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        Date from = null;
        Date to = null;
        if (list != null) {
        	from = (Date)list.get(AddListTableDefine.TIME_FROM);
        	to = (Date)list.get(AddListTableDefine.TIME_TO);
        }

        if (calendarId != null & from != null & to != null) {
            // 
        	AddInfoDialog dialog = new AddInfoDialog(this.viewPart
                    .getSite().getShell(), calendarId, from, to, PropertyConstant.MODE_MODIFY);

            // ˤѹ򤵤줿硢ƤäƹԤ
            if (dialog.open() == IDialogConstants.OK_ID) {
                Property property = dialog.getInputData();

                PropertyUtil.deletePropertyDefine(property);
                if (new ModifyAddInfoProperty().edit(calendarId, from, to, property)) {
                    // 
                    MessageBox box = new MessageBox(this.viewPart.getSite()
                            .getShell(), SWT.ICON_INFORMATION);
                    box.setText(Messages.getString("successful"));
                    box.setMessage(Messages.getString("message.calendar.17"));
                    box.open();
                } else {
                    // 
                    MessageBox box = new MessageBox(this.viewPart.getSite()
                            .getShell(), SWT.ICON_ERROR);
                    box.setText(Messages.getString("failed"));
                    box.setMessage(Messages.getString("message.calendar.18"));
                    box.open();
                }

                view.update(calendarId);
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}