/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view.action;

import java.util.Date;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.calendar.action.DeleteWeekdayInfoProperty;
import com.clustercontrol.calendar.bean.WeekdayListTableDefine;
import com.clustercontrol.calendar.view.WeekdayInfoListView;
import com.clustercontrol.util.Messages;

/**
 * ̾κԤ󥯥饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class WeekdayInfoDeleteAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.calendar.view.action.WeekdayInfoDeleteAction";
	
    private IViewPart viewPart;

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        //ID
        WeekdayInfoListView view = 
        	(WeekdayInfoListView)this.viewPart.getAdapter(WeekdayInfoListView.class);
        String calendarId = view.getComposite().getCalendarId();

        StructuredSelection selection = (StructuredSelection) view
                .getComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        Integer weekday = null;
        Date from = null;
        Date to = null;
        if (list != null) {
        	weekday = (Integer)list.get(WeekdayListTableDefine.WEEKDAY);
        	from = (Date)list.get(WeekdayListTableDefine.TIME_FROM);
        	to = (Date)list.get(WeekdayListTableDefine.TIME_TO);
        }

        if (calendarId != null & weekday != null & from != null & to != null) {
            // ǧ
            MessageBox box = new MessageBox(this.viewPart.getSite().getShell(),
                    SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
            box.setText(Messages.getString("confirmed"));
            String[] args = { calendarId };
            box.setMessage(Messages.getString("message.calendar.14", args));

            // ˤѹ򤵤줿硢Ԥ
            if (box.open() == SWT.OK) {

                if (new DeleteWeekdayInfoProperty().delete(calendarId, weekday, from, to)) {
                    // 
                    box = new MessageBox(this.viewPart.getSite().getShell(),
                            SWT.ICON_INFORMATION);
                    box.setText(Messages.getString("successful"));
                    box.setMessage(Messages.getString("message.calendar.12"));
                    box.open();
                } else {
                    // 
                    box = new MessageBox(this.viewPart.getSite().getShell(),
                            SWT.ICON_ERROR);
                    box.setText(Messages.getString("failed"));
                    box.setMessage(Messages.getString("message.calendar.13"));
                    box.open();
                }

                // ӥ塼򹹿
                view.update(calendarId);
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}