/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.bean.CheckBoxImageConstant;
import com.clustercontrol.bean.CollectiveRunStatusConstant;
import com.clustercontrol.bean.CollectiveRunStatusImageConstant;
import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.EndStatusImageConstant;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityImageConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JobImageConstant;
import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ScheduleConstant;
import com.clustercontrol.bean.ScheduleOnOffImageConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.StatusImageConstant;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.util.Messages;

/**
 * CommonTableViewer饹ѤLabelProvider饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonTableLabelProvider extends LabelProvider implements
        ICommonTableLabelProvider {
    protected CommonTableViewer m_viewer;

    /**
     * 󥹥ȥ饯
     * 
     * 󥤥᡼
     * 
     * @param viewer
     * @since 1.0.0
     */
    public CommonTableLabelProvider(CommonTableViewer viewer) {
        m_viewer = viewer;
    }

    /**
     * ʸ
     * 
     * @since 1.0.0
     * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object,
     *      int)
     */
    public String getColumnText(Object element, int columnIndex) {
        ArrayList tableColumnList = m_viewer.getTableColumnList();

        ArrayList list = (ArrayList) element;
        Object item = list.get(columnIndex);

        TableColumnInfo tableColumn = (TableColumnInfo) tableColumnList
                .get(columnIndex);

        if (item == null) {
            return "";
        }

        if (tableColumn.getType() == TableColumnInfo.JOB) {
            //ǡפ֥֡פν
            return JobConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.STATE) {
            //ǡפ־֡פν
            return StatusConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.CRUN_STATUS) {
            //ǡפְ֡פν
            return CollectiveRunStatusConstant.typeToString(((Number) item)
                    .intValue());
        } else if (tableColumn.getType() == TableColumnInfo.PRIORITY) {
            //ǡפֽ١פν
            return PriorityConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.VALID) {
            //ǡפͭ/̵פν
            return ValidConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.JUDGMENT_OBJECT) {
            //ǡפȽоݡפν
            return JudgmentObjectConstant.typeToString(((Number) item)
                    .intValue());
        } else if (tableColumn.getType() == TableColumnInfo.WAIT_RULE_VALUE) {
            //ǡפֳϾ͡פν
            Class itemClass = item.getClass();

            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");

            if (itemClass == Date.class) {
                return formatter.format((Date) item);
            } else if (itemClass == String.class) {
                return String.valueOf(item);
            } else if (itemClass.getSuperclass() == Number.class) {
                return ((Number) item).toString();
            }
        } else if (tableColumn.getType() == TableColumnInfo.SCHEDULE) {
            //ǡפ֥塼פν
            Schedule schedule = (Schedule) item;

            String scheduleString = "";
            if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd HH:mm");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = formatter
                            .format((Date) schedule.getDate());
                }
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH) {
                SimpleDateFormat formatter = new SimpleDateFormat("dd'"
                        + Messages.getString("monthday") + "' HH:mm");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = formatter
                            .format((Date) schedule.getDate());
                }
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_DAY) {
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = formatter
                            .format((Date) schedule.getDate());
                }
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_HOUR) {
                SimpleDateFormat formatter = new SimpleDateFormat("mm'"
                        + Messages.getString("minute") + "'");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = formatter
                            .format((Date) schedule.getDate());
                }
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_WEEK) {
                SimpleDateFormat formatter = new SimpleDateFormat(" HH:mm");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = DayOfWeekConstant.typeToString(schedule
                            .getDayOfWeek())
                            + formatter.format((Date) schedule.getDate());
                }
            }
            return scheduleString;
        } else if (tableColumn.getType() == TableColumnInfo.CONFIRM) {
            //ǡפֳǧ/̤ǧפν
            return ConfirmConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.WAIT_RULE) {
            //ǡפԤפν
            return YesNoConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.PROCESS) {
            //ǡפֽפν
            return ProcessConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.END_STATUS) {
            //ǡפֽλ֡פν
            return EndStatusConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.CHECKBOX) {
            //ǡפ֥åܥåפν
            return "";
        } else if (tableColumn.getType() == TableColumnInfo.DAY_OF_WEEK) {
            //ǡפפν
            return DayOfWeekConstant.typeToString(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.SCHEDULE_ON_OFF) {
            //ǡפͽפν
            return "";
        } else if (tableColumn.getType() == TableColumnInfo.JOB_PARAM_TYPE) {
            //ǡפ֥֥ѥ᡼̡פν
        	return JobParamTypeConstant.typeToString(((Number) item).intValue());
        } else {
            //嵭ʳΥǡפν
            Class itemClass = item.getClass();

            if (itemClass == String.class) {
                return String.valueOf(item);
            } else if (itemClass == Date.class) {
                return DateFormat.getDateTimeInstance().format((Date) item);
            } else if (itemClass == Time.class) {
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
                return formatter.format((Time) item);
            } else if (itemClass.getSuperclass() == Number.class) {
                return ((Number) item).toString();
            }
        }
        return "";
    }

    /**
     * ।᡼()
     * 
     * @since 1.0.0
     * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object,
     *      int)
     */
    public Image getColumnImage(Object element, int columnIndex) {
        ArrayList tableColumnList = m_viewer.getTableColumnList();

        ArrayList list = (ArrayList) element;
        Object item = list.get(columnIndex);

        TableColumnInfo tableColumn = (TableColumnInfo) tableColumnList
                .get(columnIndex);

        if (item == null) {
            return null;
        }

        if (tableColumn.getType() == TableColumnInfo.JOB) {
            //ǡפ֥֡פν
            return JobImageConstant.typeToImage(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.FACILITY) {
            //ǡפ֥եƥפν
            // TODO פȥΡɤȽˡ׸Ƥ
            Pattern p = Pattern.compile(".*>");
            Matcher m = p.matcher((String) item);
            if (m.matches()) {
                return FacilityImageConstant
                        .typeToImage(FacilityConstant.TYPE_SCOPE);
            } else {
                return FacilityImageConstant
                        .typeToImage(FacilityConstant.TYPE_NODE);
            }

        } else if (tableColumn.getType() == TableColumnInfo.STATE) {
            //ǡפ־֡פν
            return StatusImageConstant.typeToImage(((Number) item).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.CRUN_STATUS) {
            //ǡפְ֡פν
            return CollectiveRunStatusImageConstant.typeToImage(((Number) item)
                    .intValue());
        } else if (tableColumn.getType() == TableColumnInfo.END_STATUS) {
            //ǡפֽλ֡פν
            return EndStatusImageConstant.typeToImage(((Number) item)
                    .intValue());
        } else if (tableColumn.getType() == TableColumnInfo.CHECKBOX) {
            //ǡפ֥åܥåפν
            return CheckBoxImageConstant.typeToImage(((Boolean) item)
                    .booleanValue());
        } else if (tableColumn.getType() == TableColumnInfo.SCHEDULE_ON_OFF) {
            //ǡפͽפν
            return ScheduleOnOffImageConstant.dateToImage(((Date) item));
        }

        return null;
    }

    /**
     * ५顼
     * 
     * @since 1.0.0
     * @see com.clustercontrol.composite.ICommonTableLabelProvider#getColumnColor(java.lang.Object,
     *      int)
     */
    public Color getColumnColor(Object element, int columnIndex) {
        ArrayList tableColumnList = m_viewer.getTableColumnList();

        ArrayList list = (ArrayList) element;
        Object item = list.get(columnIndex);

        TableColumnInfo tableColumn = (TableColumnInfo) tableColumnList
                .get(columnIndex);

        if (item == null) {
            return null;
        }

        if (tableColumn.getType() == TableColumnInfo.PRIORITY) {
            //ǡפֽ١פν
            return PriorityColorConstant
                    .typeToColor(((Number) item).intValue());
        }

        return null;
    }
}