/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

/**
 * KeyListener饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NumberKeyListener implements KeyListener {
    protected static String numberChar = "0123456789-";

    protected static String minusChar = "-";

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.KeyListener#keyPressed(org.eclipse.swt.events.KeyEvent)
     */
    public void keyPressed(KeyEvent e) {
        //ϰʳͭˤ
        if (e.keyCode == 0) {
            return;
        }
        //BackspaceDelete줿Ȥϡͭˤ
        if (e.character == SWT.BS || e.character == SWT.DEL) {
            return;
        }
        //'-'ʳ̵ˤ
        if (numberChar.indexOf(Character.toString(e.character)) == -1) {
            e.doit = false;
        }
        //'-'ξϤǤ˿ϤƤ̵ˤ
        if (minusChar.indexOf(Character.toString(e.character)) == 0) {
            if (e.getSource() instanceof Text) {
                Text text = (Text) e.getSource();
                if (text.getText().length() > 0) {
                    e.doit = false;
                }
            } else if (e.getSource() instanceof Combo) {
                Combo combo = (Combo) e.getSource();
                if (combo.getText().length() > 0) {
                    e.doit = false;
                }
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.KeyListener#keyReleased(org.eclipse.swt.events.KeyEvent)
     */
    public void keyReleased(KeyEvent e) {

    }
}