/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

/**
 * μ¿VerifyListener饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PositiveRealNumberVerifyListener implements VerifyListener {
    protected static String numberChar = "0123456789.";
    
    protected static String dotChar = ".";

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.VerifyListener#verifyText(org.eclipse.swt.events.VerifyEvent)
     */
    public void verifyText(VerifyEvent e) {
        //ϰʳͭˤ
        if (e.keyCode == 0) {
            return;
        }
        //BackspaceDelete줿Ȥϡͭˤ
        if (e.character == SWT.BS || e.character == SWT.DEL) {
            return;
        }
        //'.'ʳ̵ˤ
        if (numberChar.indexOf(Character.toString(e.character)) == -1) {
            e.doit = false;
        }
        //'.'ξϤǤ˿ϤƤʤ ޤ Ǥ'.'ϤƤ̵ˤ
        if (dotChar.indexOf(Character.toString(e.character)) == 0) {
            Text text = (Text) e.getSource();
            if (text.getText().length() > 0) {
            	if (text.getText().indexOf(dotChar) != -1) {
            		e.doit = false;
            	}
            }
            else{
            	e.doit = false;
            }
        }
    }
}