/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Control;

import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.TextAreaDialog;

/**
 * ƥȥꥢ륨ǥ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class TextAreaDialogCellEditor extends DialogCellEditor {
	
	/** ƥȥꥢ ȥ */
	protected String m_title = null;
    
    /** ץѥƥѹβ/Բ */
    protected boolean m_modify = false;
    
    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.DialogCellEditor#openDialogBox(org.eclipse.swt.widgets.Control)
     */
    protected Object openDialogBox(Control cellEditorWindow) {
    	
        //ƥȥꥢɽ
    	TextAreaDialog dialog = new TextAreaDialog(cellEditorWindow.getShell(), m_title, m_modify);
    	if (this.getValue() instanceof String) {
    		dialog.setText((String)this.getValue());
        }
    	dialog.open();
    	
        //Ϥʸ
        String text = null;
        if (dialog.getReturnCode() == ScopeTreeDialog.OK) {
        	text = dialog.getText();
        }
        return text;
    }
    
    /**
     * ȥ
     * 
     * @param title Υȥ
     */
    public void setTitle(String title) {
    	m_title = title;
    }

    /**
     * ȥ
     * 
     * @return m_title
     */
    public String getTitle() {
        return m_title;
    }
    
    /**
     * ץѥƥѹβ/Բ
     * 
     * @param title ץѥƥѹβ/Բ
     */
    public void setModify(boolean modify) {
    	m_modify = modify;
    }

    /**
     * ץѥƥѹβ/Բļ
     * 
     * @return m_modify
     */
    public boolean getmodify() {
        return m_modify;
    }
}