/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.jface.viewers.TextCellEditor;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;

/**
 * ץѥƥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class TimePropertyDefine extends PropertyDefine implements Serializable {

    /**
     * 󥹥ȥ饯
     * 
     * @since 1.0.0
     */
    public TimePropertyDefine() {
        m_cellEditor = new TextCellEditor();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getColumnText(java.lang.Object)
     */
    public String getColumnText(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            return formatter.format((Date) value);
        }
        return "";
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getValue(com.clustercontrol.bean.Property)
     */
    public Object getValue(Property element) {
        Object value = element.getValue();
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            return formatter.format((Date) value);
        }
        return "";
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#modify(com.clustercontrol.bean.Property,
     *      java.lang.Object)
     */
    public void modify(Property element, Object value) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date date;
        try {
            date = formatter.parse((String) value);
            element.setValue(date);
            return;
        } catch (ParseException e) {

        }
        
        formatter = new SimpleDateFormat("HH:mm");
        try {
            date = formatter.parse((String) value);
            element.setValue(date);
        } catch (ParseException e) {

        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#initEditer()
     */
    public void initEditer() {

    }
}