/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ץѥƥԡ󥯥饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CopyPropertyAction extends Action {
    PropertySheet m_viewer;

    /**
     * 󥹥ȥ饯
     * 
     * @param viewer
     */
    public CopyPropertyAction(PropertySheet viewer) {
        super();

        setText(Messages.getString("copy"));

        //PropertySheetݻ
        m_viewer = viewer;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run() {
        //򤵤줿ץѥƥ
        StructuredSelection selection = (StructuredSelection) m_viewer
                .getSelection();
        Property property = (Property) selection.getFirstElement();

        if (property.getCopy() == PropertyConstant.COPY_OK) {
            //򤵤줿ץѥƥΥԡ
            Property clone = PropertyUtil.copy(property);

            //ԡץѥƥ򤷤ץѥƥľɲä
            int index = PropertyUtil.getPropertyIndex((Property) property
                    .getParent(), property);
            if (index != -1) {
                property.getParent().addChildren(clone, index + 1);
            } else {
                property.getParent().addChildren(clone);
            }
        }

        //PropertySheet
        m_viewer.refresh();
    }
}