/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.etc.action;

import org.eclipse.swt.widgets.Display;

/**
 * UI˴ؤԤ򡢻ꤷֳ֤Ȥ˥Хå饦ɤǼ¹Ԥ륯 Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class BackGroundAction {

    // ----- instance ե ----- //

    /** Хå饦ɼ¹ԥ */
    private Runnable task = null;

    /** ¹Դֳ(ߥ) */
    private long interval = 0;

    /** ¹ԥե饰 */
    private boolean canStarted = false;

    /** Display֥(asyncExec) */
    private Display display = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * UI˴ؤtaskintervalߥäδֳ֤Ƿ֤Хå ɼ¹Ԥ륤󥹥󥹤֤ޤ
     * <p>
     * 
     * ޤintervalߥԵ塢intervalߥäδֳ֤Ƿ֤¹ ޤ
     * 
     * @param display
     *            Display֥
     * @param task
     *            Хå饦ɼ¹ԥ
     * @param interval
     *            ¹Դֳ(ߥ)
     */
    public BackGroundAction(Display display, Runnable task, long interval) {
        this.display = display;
        this.task = task;
        this.interval = interval;
    }

    // ----- instance ᥽å ----- //

    /**
     * Хå饦ɽ򳫻Ϥޤ
     */
    public void start() {

        this.canStarted = true;

        // ¹ѥå
        Thread thread = new Thread() {
            public void run() {
                while (canStarted) {
                    try {
                        Thread.sleep(interval);
                    } catch (Exception e) {
                    }

                    if (canStarted) {
                        if (display.isDisposed()) {
                            return;
                        } else {
                            display.asyncExec(task);
                        }
                    }
                }
            }
        };

        // ¹Ԥޤ
        thread.setPriority(Thread.MIN_PRIORITY);
        thread.setDaemon(true);
        thread.start();
    }

    /**
     * Хå饦ɽߤޤ
     */
    public void stop() {
        this.canStarted = false;
    }

    /**
     * Хå饦ɽ¹Ǥ뤫֤ޤ
     * 
     * @return Хå饦ɽ¹Ǥ硢true
     */
    public boolean isStarted() {
        return this.canStarted;
    }

    /**
     * ¹Դֳ(ߥ)֤ޤ
     * 
     * @return ¹Դֳ(ߥ)
     */
    public long getInterval() {
        return this.interval;
    }
}