/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.common.composite;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.accesscontrol.action.CheckPermission;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.common.dialog.JobTreeDialog;
import com.clustercontrol.util.Messages;

/**
 * IDȥܥSelectionAdapter饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobIdSelectionListener extends SelectionAdapter {
	
	/** ID */
	private Text m_textJobId = null;
	
	
	public JobIdSelectionListener(Text jobId) {
		super();
		
		m_textJobId = jobId;
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	@Override
	public void widgetSelected(SelectionEvent e) {
		
		// ߤΥ桼ּ¹Ը¤ʤ硢֥ĥ꡼ɽʤ
		boolean permission = new CheckPermission().check("JobManagementExecute");
		if(!permission){
			// ʤξ硢顼ɽ
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
			return;
		}
		
		//
		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
		
		// ֥ĥ꡼ɽ
		JobTreeDialog dialog = new JobTreeDialog(shell);
		if (dialog.open() == IDialogConstants.OK_ID) {
			JobTreeItem selectItem = dialog.getSelectItem();
			if (selectItem.getData().getType() != JobConstant.TYPE_COMPOSITE) {
				m_textJobId.setText(selectItem.getData().getId());
			} else {
				m_textJobId.setText("");
			}
		}
	}
}