/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.logtransfer.action.GetLogTransfer;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.composite.LogTransferFileListComposite;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;

/**
 * žѹ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class LogTransferCreateDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 3;
	public static final int WIDTH_VALUE = 8;
	
	
	// ----- instance ե ----- //
	
	/** ͤݻ륪֥ */
	private LogTransferInfo m_inputData = null;
	
	/** ͤݻ륪֥ */
	private ValidateResult m_validateResult = null;
	
	/** ѹоݤžID */
	private String m_transferId = null;
	
	/** žID */
	private Text m_textTransferId = null;
	
	/**  */
	private Text m_textDescription = null;
	
	/**  */
	protected Text m_textScope = null;
	
	/** ׻ȥܥ */
	protected Button m_buttonScope = null;
	
	/** 򤵤줿פΥեƥID */
	protected String m_facilityId = null;
	
	/** žоݥե */
    LogTransferFileListComposite m_fileList = null;
	
	/** ͭˤ */
	private Button m_valid = null;
	
	
	// ----- 󥹥ȥ饯 ----- //
	
	/**
	 * ѥΥ󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥ륪֥
	 */
	public LogTransferCreateDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}
	
	/**
	 * ѹѥΥ󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥ륪֥
	 * @param transferId ѹžID
	 */
	public LogTransferCreateDialog(Shell parent, String transferId) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
		
		this.m_transferId = transferId;
	}
	
	/**
	 * ν֤ޤ
	 * 
	 * @return 
	 */
	protected Point getInitialSize() {
		return new Point(700, 500);
	}
	
	// ----- instance ᥽å ----- //
	
	/**
	 * ꥢޤ
	 * 
	 * @param parent ƤΥ󥹥
	 */
	protected void customizeDialog(Composite parent) {
		Shell shell = this.getShell();
		
		// ȥ
		shell.setText(Messages.getString("dialog.logtransfer.create.modify"));
		
		// ѿȤѤ٥
		Label label = null;
		// ѿȤѤ륰åɥǡ
		GridData gridData = null;
		
		// 쥤
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		layout.numColumns = 15;
		parent.setLayout(layout);
		
		/*
		 * žID
		 */
		// ٥
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("logtransfer.id") + " : ");
		// ƥ
		this.m_textTransferId = new Text(parent, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_VALUE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_textTransferId.setLayoutData(gridData);
		if(this.m_transferId != null && !"".equals(this.m_transferId.trim())){
			this.m_textTransferId.setEnabled(false);
		}
		// 
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		
		/*
		 * 
		 */
		// ٥
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("description") + " : ");
		// ƥ
		this.m_textDescription = new Text(parent, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_VALUE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_textDescription.setLayoutData(gridData);
		// 
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		
		/*
		 * 
		 */
		// ٥
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("scope") + " : ");
		// ƥ
		this.m_textScope = new Text(parent, SWT.BORDER | SWT.LEFT | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 6;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_textScope.setLayoutData(gridData);
		// ȥܥ
		m_buttonScope = new Button(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_buttonScope.setLayoutData(gridData);
		m_buttonScope.setText(Messages.getString("refer"));
		m_buttonScope.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				// 
				Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
				
				ScopeTreeDialog dialog = new ScopeTreeDialog(shell);
				if (dialog.open() == IDialogConstants.OK_ID) {
					FacilityTreeItem item = dialog.getSelectItem();
					FacilityInfo info = item.getData();
					m_facilityId = info.getFacilityId();
					if (info.getType() == FacilityConstant.TYPE_NODE) {
						m_textScope.setText(info.getFacilityName());
					} else {
						FacilityPath path = new FacilityPath(
								ClusterControlUIPlugin.getDefault()
								.getSeparator());
						m_textScope.setText(path.getPath(item));
					}
				}
			}
		});
		// 
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		
		// 롼
		Composite composite = new Composite(parent, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		layout.numColumns = 15;
		composite.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite.setLayoutData(gridData);
		
		/*
		 * žоݥե
		 */
        m_fileList = new LogTransferFileListComposite(composite, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_fileList.setLayoutData(gridData);
		
		/*
		 * ̵ͭ
		 */
		this.m_valid = new Button(parent, SWT.CHECK);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_valid.setLayoutData(gridData);
		this.m_valid.setText(Messages.getString("setting.valid.confirmed"));
		
		// 饤
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		line.setLayoutData(gridData);
		
		// 
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);
		
		// žIDꤵƤ硢ξɽ롣
		LogTransferInfo info = null; 
		if(this.m_transferId != null){
			info = new GetLogTransfer().getLogTransfer(this.m_transferId);        	
		}
		else{
			info = new LogTransferInfo();
		}
		this.setInputData(info);
		
	}
	
	/**
	 * Ƥ֤ޤ
	 * 
	 * @return Ƥݻž
	 */
	public LogTransferInfo getInputData() {
		return this.m_inputData;
	}
	
	/**
	 * ƹܤͤꤷޤ
	 * 
	 * @param info ͤȤѤž
	 */
	protected void setInputData(LogTransferInfo info) {
		
		this.m_inputData = info;
		
		// ƹܤȿ
		if (info.getTransferId() != null) {
			this.m_textTransferId.setText(info.getTransferId());
			this.m_textTransferId.setEnabled(false);
		}
		if (info.getDescription() != null) {
			this.m_textDescription.setText(info.getDescription());
		}
		if (info.getScope() != null) {
			this.m_textScope.setText(info.getScope());
		}
		if (info.getFacilityId() != null) {
			this.m_facilityId = info.getFacilityId();
		}
		if (info.getFileInfo() != null) {
			this.m_fileList.setInputData(info);
		}
		
		// ̵ͭ
		if (info.getValid() == ValidConstant.TYPE_VALID) {
			this.m_valid.setSelection(true);
		}
	}
	
	/**
	 * ͤѤƥžޤ
	 * 
	 * @return ͤݻž
	 */
	protected LogTransferInfo createInputData() {
		LogTransferInfo info = new LogTransferInfo();
		
		if (this.m_textTransferId.getText() != null
				&& !"".equals((this.m_textTransferId.getText()).trim())) {
			info.setTransferId(this.m_textTransferId.getText());
		} else {
			this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.logtransfer.8"));
			return null;
		}
		if (this.m_textDescription.getText() != null
				&& !"".equals((this.m_textDescription.getText()).trim())) {
			info.setDescription(this.m_textDescription.getText());
		}
		if (this.m_textScope.getText() != null
				&& !"".equals((this.m_textScope.getText()).trim())) {
			info.setFacilityId(this.m_facilityId);
		}
		else{
			this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.logtransfer.10"));
			return null;
		}
		
		this.m_validateResult = this.m_fileList.createInputData(info);
		if(this.m_validateResult != null){
			return null;
		}
		
		// ͭ/̵
		if (this.m_valid.getSelection()) {
			info.setValid(ValidConstant.TYPE_VALID);
		} else {
			info.setValid(ValidConstant.TYPE_INVALID);
		}
		
		return info;
	}
	
	/**
	 * ͥå򤷤ޤ
	 * 
	 * @return ڷ
	 */
	protected ValidateResult validate() {
		// 
		this.m_inputData = this.createInputData();
		
		if (this.m_inputData != null) {
			return super.validate();
		} else {
			return m_validateResult;
		}
	}
	
	/**
	 * ϣ˥ܥΥƥȤ֤ޤ
	 * 
	 * @return ϣ˥ܥΥƥ
	 */
	protected String getOkButtonText() {
		return Messages.getString("ok");
	}
	
	/**
	 * 󥻥ܥΥƥȤ֤ޤ
	 * 
	 * @return 󥻥ܥΥƥ
	 */
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}
	
	/**
	 * ̵ͤξꤷޤ
	 *  
	 */
	private void setValidateResult(String id, String message) {
		
		this.m_validateResult = new ValidateResult();
		this.m_validateResult.setValid(false);
		this.m_validateResult.setID(id);
		this.m_validateResult.setMessage(message);
	}
}