/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.dialog;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.logtransfer.action.LogTransferFileProperty;
import com.clustercontrol.logtransfer.bean.LogTransferFileTabelDefine;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * žоݥե饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */

public class LogTransferFileDialog extends CommonDialog {
	
	/** ץѥƥ */
	protected PropertySheet m_propertySheet = null;
	
	private Shell m_shell = null;
	
	private ArrayList m_fileList = null;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param parent
	 */
	public LogTransferFileDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {
		m_shell = this.getShell();
		
		// ȥ
		m_shell.setText(Messages.getString("logtransfer.file"));
		
		// ѿȤѤ٥
		Label label = null;
		// ѿȤѤ륰åɥǡ
		GridData gridData = null;
		
		// 쥤
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		parent.setLayout(layout);
		
		/*
		 * °ץѥƥ
		 */
		// ٥
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 1;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("attribute") + " : ");
		
		// ץѥƥ
		TableTree table = new TableTree(parent, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.MULTI);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		table.setLayoutData(gridData);
		
		m_propertySheet = new PropertySheet(table);
		m_propertySheet.setInput(new LogTransferFileProperty().getProperty());
		
		// 饤
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 1;
		line.setLayoutData(gridData);
		
		// 
		Display display = m_shell.getDisplay();
		m_shell.setLocation(
				(display.getBounds().width - m_shell.getSize().x) / 2, (display
						.getBounds().height - m_shell.getSize().y) / 2);
		
		// žоݥե
		reflectLogTransferFile();
		
		m_propertySheet.expandAll();
	}
	
	/**
	 * žоݥե
	 *  
	 */
	private void reflectLogTransferFile() {
		Property property = null;
		
		if (m_fileList instanceof ArrayList) {
			
			property = new LogTransferFileProperty().getProperty();
			
			// եѥ
			ArrayList propertyList = PropertyUtil.getProperty(property, LogTransferFileProperty.FILE_PATH);
			String filePath = (String) m_fileList.get(LogTransferFileTabelDefine.FILE_PATH);
			((Property) propertyList.get(0)).setValue(filePath);
			
			// ưֳ
			propertyList = PropertyUtil.getProperty(property, LogTransferFileProperty.RUN_INTERVAL);
			Integer runInterval = (Integer) m_fileList.get(LogTransferFileTabelDefine.RUN_INTERVAL);
			((Property) propertyList.get(0)).setValue(runInterval);
			
			// ǽ˥եå
			propertyList = PropertyUtil.getProperty(property, LogTransferFileProperty.EXISTENCE_FLG);
			Boolean existenceFlg = (Boolean) m_fileList.get(LogTransferFileTabelDefine.FILE_EXISTENCE_CHECK);
			((Property) propertyList.get(0)).setValue(existenceFlg);
			
			// ͭ
			propertyList = PropertyUtil.getProperty(property, LogTransferFileProperty.VALID);
			Integer valid = (Integer) m_fileList.get(LogTransferFileTabelDefine.VALID_FLG);
			((Property) propertyList.get(0)).setValue(ValidConstant.typeToString(valid.intValue()));
			
			m_propertySheet.setInput(property);
			
			//ӥ塼
			m_propertySheet.refresh();
		}
	}
	
	/**
	 * žоݥե
	 *  
	 */
	@SuppressWarnings("unchecked")
	private ValidateResult createLogTransferFile() {
		
		ValidateResult result = null;
		
		m_fileList = new ArrayList();
		
		Property property = (Property) m_propertySheet.getInput();
		
		// եѥ
		String filePath = null;
		ArrayList values = PropertyUtil.getPropertyValue(property, LogTransferFileProperty.FILE_PATH);
		if (values.get(0) instanceof String) {
			filePath = (String) values.get(0);
		}
		if (filePath == null || filePath.length() == 0) {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("message.logtransfer.12"));
			return result;
		}
		m_fileList.add(filePath);
		
		// ưֳ
		Integer runInterval = null;
		values = PropertyUtil.getPropertyValue(property, LogTransferFileProperty.RUN_INTERVAL);
		if (values.get(0) instanceof Integer) {
			runInterval = (Integer) values.get(0);
		}
		if (runInterval == null) {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("message.logtransfer.13"));
			return result;
		}
		m_fileList.add(runInterval);
		
		// ǽ˥եå
		Boolean existenceFlg = new Boolean(true);
		values = PropertyUtil.getPropertyValue(property, LogTransferFileProperty.EXISTENCE_FLG);
		if (values.get(0) instanceof Boolean) {
			existenceFlg = (Boolean) values.get(0);
		}
		m_fileList.add(existenceFlg);
		
		// ͭ
		Integer valid = Integer.valueOf(ValidConstant.TYPE_VALID);
		values = PropertyUtil.getPropertyValue(property, LogTransferFileProperty.VALID);
		if (values.get(0) instanceof String) {
			valid = Integer.valueOf(ValidConstant.stringToType((String)values.get(0)));
		}
		m_fileList.add(valid);
		
		return null;
	}
	
	/**
	 * ν֤ޤ
	 * 
	 * @return 
	 */
	protected Point getInitialSize() {
		return new Point(500, 400);
	}
	
	/**
	 * ͤꤹ
	 * 
	 * @param list
	 * @return
	 */
	public void setInputData(ArrayList list) {
		m_fileList = list;
	}
	
	/**
	 * ͤ
	 * 
	 * @return
	 */
	public ArrayList getInputData() {
		return m_fileList;
	}
	
	/**
	 * ϣ˥ܥƥȼ
	 * 
	 * @return ϣ˥ܥΥƥ
	 */
	protected String getOkButtonText() {
		return Messages.getString("ok");
	}
	
	/**
	 * 󥻥ܥƥȼ
	 * 
	 * @return 󥻥ܥΥƥ
	 */
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#validate()
	 */
	protected ValidateResult validate() {
		ValidateResult result = null;
		
		result = createLogTransferFile();
		if (result != null) {
			return result;
		}
		
		return null;
	}
}