/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.dialog;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.logtransfer.action.AddLogTransfer;
import com.clustercontrol.logtransfer.action.DeleteLogTransfer;
import com.clustercontrol.logtransfer.action.ModifyLogTransfer;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.bean.LogTransferTabelDefine;
import com.clustercontrol.logtransfer.composite.LogTransferListComposite;
import com.clustercontrol.util.Messages;

/**
 * ž饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class LogTransferListDialog extends CommonDialog {
	
	// ----- instance ե ----- //
	
	/** ž */
	private LogTransferListComposite logTransferList = null;
	
	/** ɲåܥ */
	private Button buttonAdd = null;
	
	/** ѹܥ */
	private Button buttonModify = null;
	
	/** ܥ */
	private Button buttonDelete = null;
	
	
	// ----- 󥹥ȥ饯 ----- //
	
	/**
	 * Υ󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥ륪֥
	 */
	public LogTransferListDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}
	
	// ----- instance ᥽å ----- //
	
	/**
	 * ν֤ޤ
	 * 
	 * @return 
	 */
	protected Point getInitialSize() {
		return new Point(800, 350);
	}
	
	/**
	 * ꥢޤ
	 * 
	 * @param parent ƤΥ󥹥
	 */
	protected void customizeDialog(Composite parent) {
		Shell shell = this.getShell();
		
		// ȥ
		shell.setText(Messages.getString("dialog.logtransfer.list"));
		
		// 쥤
		GridLayout layout = new GridLayout(8, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		layout.numColumns = 8;
		parent.setLayout(layout);
		
		/*
		 * ž
		 */
		this.logTransferList = new LogTransferListComposite(parent, SWT.BORDER);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 7;
		this.logTransferList.setLayoutData(gridData);
		
		/*
		 * ܥ
		 */
		Composite composite = new Composite(parent, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.numColumns = 1;
		composite.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		composite.setLayoutData(gridData);
		
		// ɲåܥ
		this.buttonAdd = this
		.createButton(composite, Messages.getString("add"));
		this.buttonAdd.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				LogTransferCreateDialog dialog = new LogTransferCreateDialog(getParentShell());
				if (dialog.open() == IDialogConstants.OK_ID) {
					
					LogTransferInfo info = dialog.getInputData();
					if(info != null){
						boolean result = new AddLogTransfer().add(info);
						String[] args = { info.getTransferId() };
						if(result){
							MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
							box.setText(Messages.getString("successful"));
							box.setMessage(Messages.getString("message.logtransfer.1",args));
							box.open();
							
							logTransferList.update();
						}
						else{
							MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
							box.setText(Messages.getString("failed"));
							box.setMessage(Messages.getString("message.logtransfer.2",args));
							box.open();
						}
					}
				}
			}
		});
		
		// ѹܥ
		Label dummy = new Label(composite, SWT.NONE);
		this.buttonModify = this.createButton(composite, Messages.getString("modify"));
		this.buttonModify.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				
				String transferId = null;
				
				Table table = logTransferList.getTableViewer().getTable();
				TableItem[] item = table.getSelection();
				
				if(item != null && item.length>0){
					try{
						transferId = (String)((ArrayList)item[0].getData()).get(LogTransferTabelDefine.TRANSFER_ID);
					}
					catch(Exception ex){
					}
				}
				
				if (transferId != null) {
					LogTransferCreateDialog dialog = new LogTransferCreateDialog(getParentShell(), transferId);
					if (dialog.open() == IDialogConstants.OK_ID) {
						boolean result = new ModifyLogTransfer().modify(dialog.getInputData());
						String[] args = { transferId };
						if(result){
							MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
							box.setText(Messages.getString("successful"));
							box.setMessage(Messages.getString("message.logtransfer.3",args));
							box.open();
							
							int selectIndex = table.getSelectionIndex();
							logTransferList.update();
							table.setSelection(selectIndex);
						}
						else{
							MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
							box.setText(Messages.getString("failed"));
							box.setMessage(Messages.getString("message.logtransfer.4",args));
							box.open();
						}
					}
				}
				else{
					MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
					box.setText(Messages.getString("warning"));
					box.setMessage(Messages.getString("message.logtransfer.8"));
					box.open();
				}
			}
		});
		
		// ܥ
		dummy = new Label(composite, SWT.NONE);
		this.buttonDelete = this.createButton(composite, Messages.getString("delete"));
		this.buttonDelete.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				
				String transferId = null;
				
				Table table = logTransferList.getTableViewer().getTable();
				TableItem[] item = table.getSelection();
				
				if(item != null && item.length>0){
					try{
						transferId = (String)((ArrayList)item[0].getData()).get(LogTransferTabelDefine.TRANSFER_ID);
					}
					catch(Exception ex){
					}
				}
				
				if (transferId != null) {
					
					MessageBox confirmBox = new MessageBox(getShell(), SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
					confirmBox.setText(Messages.getString("confirmed"));
					String[] args = { transferId };
					String message = Messages.getString("message.logtransfer.7",args);
					confirmBox.setMessage(message);
					
					if (confirmBox.open() == SWT.OK) {
						boolean result = new DeleteLogTransfer().delete(transferId);
						if(result){
							MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
							box.setText(Messages.getString("successful"));
							box.setMessage(Messages.getString("message.logtransfer.5", args));
							box.open();
							
							logTransferList.update();
						}
						else{
							MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
							box.setText(Messages.getString("failed"));
							box.setMessage(Messages.getString("message.logtransfer.6", args));
							box.open();
						}
					}
				}
				else{
					MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
					box.setText(Messages.getString("warning"));
					box.setMessage(Messages.getString("message.logtransfer.8"));
					box.open();
				}
			}
		});
		
		// 饤
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 8;
		line.setLayoutData(gridData);
		
		// 
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);
	}
	
	/**
	 * ͥå򤷤ޤ
	 * 
	 * @return ڷ
	 */
	protected ValidateResult validate() {
		return super.validate();
	}
	
	/**
	 * ̤Υܥޤ
	 * 
	 * @param parent ƤΥݥå
	 * @param label ܥΥ٥
	 * @return 줿ܥ
	 */
	private Button createButton(Composite parent, String label) {
		Button button = new Button(parent, SWT.NONE);
		
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		button.setLayoutData(gridData);
		
		button.setText(label);
		
		return button;
	}
	
	/**
	 * Ĥܥޤ
	 * 
	 * @param parent ܥСݥå
	 */
	protected void createButtonsForButtonBar(Composite parent) {
		
		// Ĥܥ
		this.createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CLOSE_LABEL, false);
	}
	
}