/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;

/**
 * դƻ󥳥ݥåȥ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class MonitorBasicScopeComposite extends MonitorBasicComposite {
	
    // ----- instance ե ----- //

	/**  */
	protected Text m_textScope = null;
    
    /** ׻ȥܥ */
    protected Button m_buttonScope = null;
    
    /** 򤵤줿פΥեƥID */
    protected String m_facilityId = null;


    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     */
    public MonitorBasicScopeComposite(Composite parent, int style) {
        super(parent, style);
        
        this.initialize();
    }
    
    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
    	
    	// ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;
        this.setLayout(layout);
        
        /*
         * 
         */
        // ٥
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("scope") + " : ");
        // ƥ
        this.m_textScope = new Text(this, SWT.BORDER | SWT.LEFT | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textScope.setLayoutData(gridData);
        // ȥܥ
        m_buttonScope = new Button(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_buttonScope.setLayoutData(gridData);
        m_buttonScope.setText(Messages.getString("refer"));
        m_buttonScope.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	// 
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            	
                ScopeTreeDialog dialog = new ScopeTreeDialog(shell);
                if (dialog.open() == IDialogConstants.OK_ID) {
                    FacilityTreeItem item = dialog.getSelectItem();
                    FacilityInfo info = item.getData();
                    m_facilityId = info.getFacilityId();
                    if (info.getType() == FacilityConstant.TYPE_NODE) {
                        m_textScope.setText(info.getFacilityName());
                    } else {
                        FacilityPath path = new FacilityPath(
                                ClusterControlUIPlugin.getDefault()
                                        .getSeparator());
                        m_textScope.setText(path.getPath(item));
                    }
                }
            }
        });
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param info ͤȤѤƻ
     */
	public void setInputData(MonitorInfo info) {
		
		super.setInputData(info);
		
		if(info != null){
			if (info.getScope() != null) {
	            this.m_textScope.setText(info.getScope());
	        }
			if (info.getFacilityId() != null) {
				this.m_facilityId = info.getFacilityId();
	        }
			
		}
	}

	/**
     * ͤѤƴƻޤ
     * 
     * @return ڷ
     */
	public ValidateResult createInputData(MonitorInfo info) {
		
		if(info != null){
			
			ValidateResult validateResult = super.createInputData(info);
			
			if(validateResult != null){
				return validateResult;
			}
			else{
				if (this.m_textScope.getText() != null
		                && !"".equals((this.m_textScope.getText()).trim())) {
					info.setFacilityId(this.m_facilityId);
				}
				else{
					 return setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.hinemos.3"));
				 }
			}
		}
		return null;
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		super.setEnabled(enabled);
		this.m_textScope.setEnabled(enabled);
		this.m_buttonScope.setEnabled(enabled);
	}
	
	/**
     * ̵ͤξꤷޤ
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }
}