/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.composite.PositiveRealNumberVerifyListener;
import com.clustercontrol.composite.RealNumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.util.Messages;

/**
 * ʹƻȽ Ρñ̤νپ󥳥ݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class NumericValueInfoComposite extends Composite {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;
	
	/** ϸڡ */
	public static final int INPUT_VERIFICATION_INTEGER_NUMBER = 0;
    /** ϸڡ¿ */
	public static final int INPUT_VERIFICATION_REAL_NUMBER = 1;
    /** ϸڡ */
	public static final int INPUT_VERIFICATION_POSITIVE_INTEGER = 2;
    /** ϸڡμ¿ */
	public static final int INPUT_VERIFICATION_POSITIVE_REAL = 3;

    // ----- instance ե ----- //
	
	/** ϰȽե饰 */
    private boolean m_rangeFlg = false;
	
	/** Ƚܣ */
    private String m_itemName1 = null;
    
    /** Ƚܣ */
    private String m_itemName2 = null;
    
    /** ȽʸȽܣ */
    private String m_criterion1 = Messages.getString("greater");
    
    /** ȽʸȽܣ */
    private String m_criterion2 = Messages.getString("less");
    
    /** ƥȥܥåϸڥסȽܣ */
    private int m_inputVerifyType1 = INPUT_VERIFICATION_INTEGER_NUMBER;
    
    /** ƥȥܥåϸڥסȽܣ */
    private int m_inputVerifyType2 = INPUT_VERIFICATION_INTEGER_NUMBER;
    
    /** ƥȥܥåͲ¡Ƚܣ */
    private Float m_inputFloor1 = null;
    
    /** ƥȥܥå;¡Ƚܣ */
    private Float m_inputCeiling1 = null;
    
    /** ƥȥܥåͲ¡Ƚܣ */
    private Float m_inputFloor2 = null;
    
    /** ƥȥܥå;¡Ƚܣ */
    private Float m_inputCeiling2 = null;

    /** ͤβ¡ */
    private Text m_textInfoThresholdLowerLimit = null;
    
    /** ͤξ¡ */
    private Text m_textInfoThresholdUpperLimit = null;
    
    /** ͤβ¡ٹ */
    private Text m_textWarnThresholdLowerLimit = null;

    /** ͤξ¡ٹ */
    private Text m_textWarnThresholdUpperLimit = null;

    /** ͼμԻ */
    private Combo m_comboFailurePriority = null;
    

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param range ϰȽե饰
     * @param item1 Ƚ̾
     * @param item2 Ƚ̾
     */
    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2) {
        super(parent, style);
        
        m_rangeFlg = rangeFlg;
        m_itemName1 = item1;
        m_itemName2 = item2;
        
        this.initialize();
    }
    
    /**
     * 󥹥󥹤֤ޤ
     * <p> 
	 * 
	 * ꤵ줿ϸڥפǡƤΥƥȥܥåϸڤԤޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param range ϰȽե饰
     * @param item1 Ƚ̾
     * @param item2 Ƚ̾
     * @param inputVerifyType ƥȥܥåϸڥסȽܣ,
     */
    public NumericValueInfoComposite(Composite parent, 
    		int style, 
    		boolean rangeFlg, 
    		String item1, 
    		String item2, 
    		int inputVerifyType) {
    	
        super(parent, style);
        
        m_rangeFlg = rangeFlg;
        m_itemName1 = item1;
        m_itemName2 = item2;
        m_inputVerifyType1 = inputVerifyType;
        m_inputVerifyType2 = inputVerifyType;
        
        this.initialize();
    }
    
    /**
     * 󥹥󥹤֤ޤ
     * <p> 
	 * 
	 * ȽܤȤ˻ꤵ줿ϸڥפǡƥƥȥܥåϸڤԤޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param range ϰȽե饰
     * @param item1 Ƚ̾
     * @param item2 Ƚ̾
     * @param inputVerifyType1 ƥȥܥåϸڥסȽܣ
     * @param inputVerifyType2 ƥȥܥåϸڥסȽܣ
     */
    public NumericValueInfoComposite(Composite parent, 
    		int style, 
    		boolean rangeFlg, 
    		String item1, 
    		String item2, 
    		int inputVerifyType1,
    		int inputVerifyType2) {
    	
        super(parent, style);
        
        m_rangeFlg = rangeFlg;
        m_itemName1 = item1;
        m_itemName2 = item2;
        m_inputVerifyType1 = inputVerifyType1;
        m_inputVerifyType2 = inputVerifyType2;
        
        this.initialize();
    }
    
    /**
     * 󥹥󥹤֤ޤ
     * <p> 
	 * 
	 * ȽܤȤ˻ꤵ줿ϸڥפǡƥƥȥܥåϸڤԤޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param range ϰȽե饰
     * @param item1 Ƚ̾
     * @param item2 Ƚ̾
     * @param criterion1 ȽʸȽܣ
     * @param criterion2 ȽʸȽܣ
     * @param inputVerifyType1 ƥȥܥåϸڥסȽܣ
     * @param inputVerifyType2 ƥȥܥåϸڥסȽܣ
     */
    public NumericValueInfoComposite(Composite parent, 
    		int style, 
    		boolean rangeFlg, 
    		String item1, 
    		String item2,
    		String criterion1,
    		String criterion2,
    		int inputVerifyType1,
    		int inputVerifyType2) {
    	
        super(parent, style);
        
        m_rangeFlg = rangeFlg;
        m_itemName1 = item1;
        m_itemName2 = item2;
        m_criterion1 = criterion1;
        m_criterion2 = criterion2;
        m_inputVerifyType1 = inputVerifyType1;
        m_inputVerifyType2 = inputVerifyType2;
        
        this.initialize();
    }
    
    /**
     * 󥹥󥹤֤ޤ
     * <p> 
	 * 
	 * ꤵ줿ϸڥס  ͤǡƤΥƥȥܥåϸڤԤޤ
	 * 
     * @param parent ƤΥݥå
     * @param style 
     * @param range ϰȽե饰
     * @param item1 Ƚ̾
     * @param item2 Ƚ̾
     * @param inputVerifyType ƥȥܥåϸڥסȽܣ,
     * @param inputFloor ƥȥܥåͲ¡Ƚܣ,
     * @param inputCeiling ƥȥܥå;¡Ƚܣ,
     */
    public NumericValueInfoComposite(Composite parent, 
    		int style, 
    		boolean rangeFlg, 
    		String item1, 
    		String item2, 
    		int inputVerifyType, 
    		Float inputFloor, 
    		Float inputCeiling) {
    	
        super(parent, style);
        
        m_rangeFlg = rangeFlg;
        m_itemName1 = item1;
        m_itemName2 = item2;
        m_inputVerifyType1 = inputVerifyType;
        m_inputVerifyType2 = inputVerifyType;
        m_inputFloor1 = inputFloor;
        m_inputFloor2 = inputFloor;
        m_inputCeiling1 = inputCeiling;
        m_inputCeiling2 = inputCeiling;
        
        this.initialize();
    }
    
    /**
     * 󥹥󥹤֤ޤ
     * <p> 
	 * 
	 * ꤵ줿ϸڥפȡȽܤȤ˻ꤵ줿  ͤǡƥȥܥåϸڤԤޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param range ϰȽե饰
     * @param item1 Ƚ̾
     * @param item2 Ƚ̾
     * @param inputVerifyType1 ƥȥܥåϸڥסȽܣ
     * @param inputVerifyType2 ƥȥܥåϸڥסȽܣ
     * @param inputFloor1 ƥȥܥåͲ¡Ƚܣ
     * @param inputCeiling1 ƥȥܥå;¡Ƚܣ
     * @param inputFloor2 ƥȥܥåͲ¡Ƚܣ
     * @param inputCeiling2 ƥȥܥå;¡Ƚܣ
     */
    public NumericValueInfoComposite(Composite parent, 
    		int style, 
    		boolean rangeFlg, 
    		String item1, 
    		String item2, 
    		int inputVerifyType1, 
    		int inputVerifyType2,
    		Float inputFloor1,
    		Float inputCeiling1,
    		Float inputFloor2,
    		Float inputCeiling2) {
    	
        super(parent, style);
        
        m_rangeFlg = rangeFlg;
        m_itemName1 = item1;
        m_itemName2 = item2;
        m_inputVerifyType1 = inputVerifyType1;
        m_inputVerifyType2 = inputVerifyType2;
        m_inputFloor1 = inputFloor1;
        m_inputFloor2 = inputFloor2;
        m_inputCeiling1 = inputCeiling1;
        m_inputCeiling2 = inputCeiling2;
        
        this.initialize();
    }
    
    /**
     * 󥹥󥹤֤ޤ
     * <p> 
	 * 
	 * ꤵ줿ϸڥפȡȽܤȤ˻ꤵ줿  ͤǡƥȥܥåϸڤԤޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param range ϰȽե饰
     * @param item1 Ƚ̾
     * @param item2 Ƚ̾
     * @param criterion1 ȽʸȽܣ
     * @param criterion2 ȽʸȽܣ
     * @param inputVerifyType1 ƥȥܥåϸڥסȽܣ
     * @param inputVerifyType2 ƥȥܥåϸڥסȽܣ
     * @param inputFloor1 ƥȥܥåͲ¡Ƚܣ
     * @param inputCeiling1 ƥȥܥå;¡Ƚܣ
     * @param inputFloor2 ƥȥܥåͲ¡Ƚܣ
     * @param inputCeiling2 ƥȥܥå;¡Ƚܣ
     */
    public NumericValueInfoComposite(Composite parent, 
    		int style, 
    		boolean rangeFlg, 
    		String item1, 
    		String item2,
    		String criterion1,
    		String criterion2,
    		int inputVerifyType1, 
    		int inputVerifyType2,
    		Float inputFloor1,
    		Float inputCeiling1,
    		Float inputFloor2,
    		Float inputCeiling2) {
    	
        super(parent, style);
        
        m_rangeFlg = rangeFlg;
        m_itemName1 = item1;
        m_itemName2 = item2;
        m_criterion1 = criterion1;
        m_criterion2 = criterion2;
        m_inputVerifyType1 = inputVerifyType1;
        m_inputVerifyType2 = inputVerifyType2;
        m_inputFloor1 = inputFloor1;
        m_inputFloor2 = inputFloor2;
        m_inputCeiling1 = inputCeiling1;
        m_inputCeiling2 = inputCeiling2;
        
        this.initialize();
    }
    
    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
    	
    	// ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;
        this.setLayout(layout);
        
        // ٥
        // ͼ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("successful.select.value") + " : ");
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("priority"));
        
        // ͤβ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE*2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(m_itemName1);

        // ͤξ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE*2;
        gridData.horizontalAlignment = GridData.BEGINNING;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(m_itemName2);

        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
    	// ƥȥܥåϸ
        VerifyListener verifyListener1 = null;
        if(m_inputVerifyType1 == INPUT_VERIFICATION_REAL_NUMBER){
        	verifyListener1 = new RealNumberVerifyListener();
        }
		else if(m_inputVerifyType1 == INPUT_VERIFICATION_POSITIVE_INTEGER){
			verifyListener1 = new PositiveNumberVerifyListener();
		}
		else if(m_inputVerifyType1 == INPUT_VERIFICATION_POSITIVE_REAL){
			verifyListener1 = new PositiveRealNumberVerifyListener();
		}
		else{
			verifyListener1 = new NumberVerifyListener();
        }
        
        // ƥȥܥåϸ
        VerifyListener verifyListener2 = null;
        if(m_inputVerifyType2 == INPUT_VERIFICATION_REAL_NUMBER){
        	verifyListener2 = new RealNumberVerifyListener();
        }
		else if(m_inputVerifyType2 == INPUT_VERIFICATION_POSITIVE_INTEGER){
			verifyListener2 = new PositiveNumberVerifyListener();
		}
		else if(m_inputVerifyType2 == INPUT_VERIFICATION_POSITIVE_REAL){
			verifyListener2 = new PositiveRealNumberVerifyListener();
		}
		else{
			verifyListener2 = new NumberVerifyListener();
        }
        
        // ١
        label = this.getLabelPriority(this, Messages.getString("info"),PriorityColorConstant.COLOR_INFO);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ͤβ
        this.m_textInfoThresholdLowerLimit = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textInfoThresholdLowerLimit.addVerifyListener(verifyListener1);
        this.m_textInfoThresholdLowerLimit.setLayoutData(gridData);
        
        // ʾ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(m_criterion1);
        
        // ͤξ
        this.m_textInfoThresholdUpperLimit = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textInfoThresholdUpperLimit.addVerifyListener(verifyListener2);
        this.m_textInfoThresholdUpperLimit.setLayoutData(gridData);
        
        // ʲ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(m_criterion2);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
                
        // ١ٹ
        label = this.getLabelPriority(this, Messages.getString("warning"),PriorityColorConstant.COLOR_WARNING);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ͤβ
        this.m_textWarnThresholdLowerLimit = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textWarnThresholdLowerLimit.addVerifyListener(verifyListener1);
        this.m_textWarnThresholdLowerLimit.setLayoutData(gridData);
        
        // ʾ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(m_criterion1);
        
        // ͤξ
        this.m_textWarnThresholdUpperLimit = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textWarnThresholdUpperLimit.addVerifyListener(verifyListener2);
        this.m_textWarnThresholdUpperLimit.setLayoutData(gridData);
        
        // ʲ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(m_criterion2);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        // ١۾
        label = this.getLabelPriority(this, Messages.getString("critical"),PriorityColorConstant.COLOR_CRITICAL);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // Ρٹʳ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE*2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("other.priority"));
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ͼμԻ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("failure.select.value") + " : ");
        
        // 
        this.m_comboFailurePriority = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFailurePriority.setLayoutData(gridData);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_INFO);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFailurePriority.setText(PriorityConstant.STRING_WARNING);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param info ͤȤѤƻ
     */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
			
	        ArrayList list = info.getJudgementInfo();
	        if(list != null){
	            for(int index=0; index<list.size(); index++){
	            	MonitorNumericValueInfo numericValueInfo = (MonitorNumericValueInfo)list.get(index);
	            	if(numericValueInfo != null){
	                	if(PriorityConstant.TYPE_INFO ==  numericValueInfo.getPriority()){
	                		String lower = "";
	                		String upper = "";
	                		if(m_inputVerifyType1  == INPUT_VERIFICATION_INTEGER_NUMBER || 
	                				m_inputVerifyType1  == INPUT_VERIFICATION_POSITIVE_INTEGER){
	                			lower = Long.toString(Float.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue());
	                		}
	                		else{
	                			lower = Float.toString(numericValueInfo.getThresholdLowerLimit());
	                		}
	                		if(m_inputVerifyType2  == INPUT_VERIFICATION_INTEGER_NUMBER || 
	                				m_inputVerifyType2  == INPUT_VERIFICATION_POSITIVE_INTEGER){
	                			upper = Long.toString(Float.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue());
	                		}
	                		else{
	                			upper = Float.toString(numericValueInfo.getThresholdUpperLimit());
	                		}
	                		this.m_textInfoThresholdLowerLimit.setText(lower);
	                		this.m_textInfoThresholdUpperLimit.setText(upper);
	                	}
	                	else if(PriorityConstant.TYPE_WARNING ==  numericValueInfo.getPriority()){
	                		String lower = "";
	                		String upper = "";
	                		if(m_inputVerifyType1  == INPUT_VERIFICATION_INTEGER_NUMBER || 
	                				m_inputVerifyType1  == INPUT_VERIFICATION_POSITIVE_INTEGER){
	                			lower = Long.toString(Float.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue());
	                		}
	                		else{
	                			lower = Float.toString(numericValueInfo.getThresholdLowerLimit());
	                		}
	                		if(m_inputVerifyType2  == INPUT_VERIFICATION_INTEGER_NUMBER || 
	                				m_inputVerifyType2  == INPUT_VERIFICATION_POSITIVE_INTEGER){
	                			upper = Long.toString(Float.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue());
	                		}
	                		else{
	                			upper = Float.toString(numericValueInfo.getThresholdUpperLimit());
	                		}
	                		this.m_textWarnThresholdLowerLimit.setText(lower);
	                		this.m_textWarnThresholdUpperLimit.setText(upper);
	                	}
	            	}
	            }
	        }
	        this.m_comboFailurePriority.setText(PriorityConstant.typeToString(info.getFailurePriority()));
		}
	}

	/**
     * ͤѤƥΡñ̤ηȽޤ
     * 
     * @return ڷ
     */
	public ValidateResult createInputData(MonitorInfo info) {
		
        ArrayList<MonitorNumericValueInfo> valueList = new ArrayList<MonitorNumericValueInfo>();
        
        String lowerText = null;
        String upperText = null;
        Float lower = null;
        Float upper = null;
        
        // ١
        MonitorNumericValueInfo valueInfo = getDefaultValueInfo(info, PriorityConstant.TYPE_INFO);
        
        lowerText = this.m_textInfoThresholdLowerLimit.getText();
        upperText = this.m_textInfoThresholdUpperLimit.getText();

        if (lowerText != null && !"".equals(lowerText.trim())) {
        	try{
        		lower = new Float(lowerText);
        		if(m_inputFloor1 != null && m_inputCeiling1 != null){
        			if(lower < m_inputFloor1 || lower > m_inputCeiling1){
        				String[] args = { m_itemName1, m_inputFloor1.toString(), m_inputCeiling1.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.19", args));
        			}
        		}
        		else if(m_inputFloor1 != null && m_inputCeiling1 == null){
        			if(lower < m_inputFloor1){
        				String[] args = { m_itemName1, m_inputFloor1.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.20", args));
        			}
        		}
        		else if(m_inputFloor1 == null && m_inputCeiling1 != null){
        			if(lower > m_inputCeiling1){
        				String[] args = { m_itemName1, m_inputCeiling1.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.21", args));
        			}
        		}
        		valueInfo.setThresholdLowerLimit(lower);
        	}
        	catch(NumberFormatException e){
        		String[] args = { m_itemName1 };
        		return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.3", args));
        	}
        }
        else{
        	String[] args = { m_itemName1 };
        	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.3", args));
        }
        if (upperText != null && !"".equals(upperText.trim())) {
        	try{
            	upper = new Float(upperText);
            	if(m_inputFloor2 != null && m_inputCeiling2 != null){
        			if(upper < m_inputFloor2 || upper > m_inputCeiling2){
        				String[] args = { m_itemName2, m_inputFloor2.toString(), m_inputCeiling2.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.19", args));
        			}
        		}
        		else if(m_inputFloor2 != null && m_inputCeiling2 == null){
        			if(upper < m_inputFloor2){
        				String[] args = { m_itemName2, m_inputFloor2.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.20", args));
        			}
        		}
        		else if(m_inputFloor2 == null && m_inputCeiling2 != null){
        			if(upper > m_inputCeiling2){
        				String[] args = { m_itemName2, m_inputCeiling2.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.21", args));
        			}
        		}
            	valueInfo.setThresholdUpperLimit(upper);
        	}
        	catch(NumberFormatException e){
        		String[] args = { m_itemName2 };
        		return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.4", args));
        	}
        }
        else{
        	String[] args = { m_itemName2 };
        	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.4", args));
        }
        if(m_rangeFlg){
        	if(upper.floatValue() < lower.floatValue()){
                return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.7"));
            }
        }
        valueList.add(valueInfo);
        
        // ١ٹ
        MonitorNumericValueInfo valueWarn = getDefaultValueInfo(info, PriorityConstant.TYPE_WARNING);
        
        lowerText = this.m_textWarnThresholdLowerLimit.getText();
        upperText = this.m_textWarnThresholdUpperLimit.getText();
        
        if (lowerText != null
                && !"".equals(lowerText.trim())) {
        	try{
        		lower = new Float(lowerText);
        		if(m_inputFloor1 != null && m_inputCeiling1 != null){
        			if(lower < m_inputFloor1 || lower > m_inputCeiling1){
        				String[] args = { m_itemName1, m_inputFloor1.toString(), m_inputCeiling1.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.22", args));
        			}
        		}
        		else if(m_inputFloor1 != null && m_inputCeiling1 == null){
        			if(lower < m_inputFloor1){
        				String[] args = { m_itemName1, m_inputFloor1.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.23", args));
        			}
        		}
        		else if(m_inputFloor1 == null && m_inputCeiling1 != null){
        			if(lower > m_inputCeiling1){
        				String[] args = { m_itemName1, m_inputCeiling1.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.24", args));
        			}
        		}
        		valueWarn.setThresholdLowerLimit(lower);	
        	}
        	catch(NumberFormatException e){
        		String[] args = { m_itemName1 };
            	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.5", args));
        	}
        }
        else{
        	String[] args = { m_itemName1 };
        	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.5", args));
        }
        if (this.m_textWarnThresholdUpperLimit.getText() != null
                && !"".equals((this.m_textWarnThresholdUpperLimit.getText()).trim())) {
        	try{
            	upper = new Float(upperText);
            	if(m_inputFloor2 != null && m_inputCeiling2 != null){
        			if(upper < m_inputFloor2 || upper > m_inputCeiling2){
        				String[] args = { m_itemName2, m_inputFloor2.toString(), m_inputCeiling2.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.22", args));
        			}
        		}
        		else if(m_inputFloor2 != null && m_inputCeiling2 == null){
        			if(upper < m_inputFloor2){
        				String[] args = { m_itemName2, m_inputFloor2.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.23", args));
        			}
        		}
        		else if(m_inputFloor2 == null && m_inputCeiling2 != null){
        			if(upper > m_inputCeiling2){
        				String[] args = { m_itemName2, m_inputCeiling2.toString() };
        				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.24", args));
        			}
        		}
            	valueWarn.setThresholdUpperLimit(upper);
        	}
        	catch(NumberFormatException e){
        		String[] args = { m_itemName2 };
            	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.6", args));
        	}
        }
        else{
        	String[] args = { m_itemName2 };
        	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.6", args));
        }
        if(m_rangeFlg){
        	if(upper.floatValue() < lower.floatValue()){
            	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.8"));
            }
        }
        valueList.add(valueWarn);
        
        // ١
        MonitorNumericValueInfo valueCritical = getDefaultValueInfo(info, PriorityConstant.TYPE_CRITICAL);
        valueCritical.setThresholdLowerLimit(Float.valueOf(0));
        valueCritical.setThresholdUpperLimit(Float.valueOf(0));
        valueList.add(valueCritical);
        
        // ١
        MonitorNumericValueInfo valueUnknown = getDefaultValueInfo(info, PriorityConstant.TYPE_UNKNOWN);
        valueUnknown.setThresholdLowerLimit(Float.valueOf(0));
        valueUnknown.setThresholdUpperLimit(Float.valueOf(0));
        valueList.add(valueUnknown);
        
        info.setJudgementInfo(valueList);
        
        // ͼμԻ
        info.setFailurePriority(PriorityConstant.stringToType(this.m_comboFailurePriority.getText()));
        
		return null;
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		this.m_textInfoThresholdLowerLimit.setEnabled(enabled);
		this.m_textInfoThresholdUpperLimit.setEnabled(enabled);
		this.m_textWarnThresholdLowerLimit.setEnabled(enabled);
		this.m_textWarnThresholdUpperLimit.setEnabled(enabled);
		this.m_comboFailurePriority.setEnabled(enabled);
	}
	
	/**
     * ٥ƥȤ֤ޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected Label getLabelPriority(Composite parent,
    		String text,
    		Color background
    		) {
    	
    	// ٥ʽ١
    	Label label = new Label(parent, SWT.NONE);
    	GridData gridData = new GridData();
    	gridData.horizontalSpan = 2;
    	gridData.horizontalAlignment = GridData.FILL;
    	gridData.grabExcessHorizontalSpace = true;
    	label.setLayoutData(gridData);
    	label.setText(text + " : ");
    	label.setBackground(background);
        
        return label;
    }
	
	/**
     * ̵ͤξꤷޤ
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }
    
    /**
     * ʹƻȽ֤ޤ
     *  
     * @param info ƻ
     * @param priority 
     * @return ʹƻȽ
     */
    protected MonitorNumericValueInfo getDefaultValueInfo(MonitorInfo info, int priority) {

    	MonitorNumericValueInfo value = new MonitorNumericValueInfo();
    	value.setMonitorId(info.getMonitorId());
    	value.setMonitorTypeId(info.getMonitorTypeId());
    	value.setPriority(Integer.valueOf(priority));
        
        return value;
    }
}