/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.common.composite.JobIdSelectionListener;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.bean.TruthConstant;
import com.clustercontrol.util.Messages;

/**
 * ƻȽ ¹ԥ־󥳥ݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TruthRunJobComposite extends Composite {
	
	public static final int WIDTH_PRIORITY = 3;
	public static final int WIDTH_JOB_RUN	 = 1;
	public static final int WIDTH_JOB_ID	 = 4;
	public static final int WIDTH_REF_BTN = 2;
	public static final int WIDTH_INHIBITION_FLG = 3;
	public static final int WIDTH_FAILURE_PRIORITY = 2;
	
	/** Ƚܣ */
	private String m_itemTrue = null;
	/** Ƚܣ */
	private String m_itemFalse = null;
	
	/** ¹ԡTrue */ 
	private Button m_checkJobRunTrue = null;
	/** IDTrue */
	private Text m_textJobIdTrue = null;
	/** ȥܥTrue */
	private Button m_buttonReferTrue = null;
	/** ϢưTrue */ 
	private Button m_checkInhibitionFlgTrue = null;
	/** ƤӽФԻ١True */ 
	private Combo m_comboFailurePriorityTrue = null;
	
	/** ¹ԡFalse */
	private Button m_checkJobRunFalse = null;
	/** IDFalse */
	private Text m_textJobIdFalse = null;
	/** ȥܥFalse */
	private Button m_buttonReferFalse = null;
	/** ϢưFalse */
	private Button m_checkInhibitionFlgFalse = null;
	/** ƤӽФԻ١False */
	private Combo m_comboFailurePriorityFalse = null;
	
//	/** ¹ԡͼμԻ */ 
//	private Button m_checkJobRunFailure = null;
//	/** IDͼμԻ */
//	private Text m_textJobIdFailure = null;
//	/** ȥܥͼμԻ */
//	private Button m_buttonReferFailure = null;
//	/** ϢưͼμԻ */
//	private Button m_checkInhibitionFlgFailure = null;
//	/** ƤӽФԻ١ͼμԻ */ 
//	private Combo m_comboFailurePriorityFailure = null;
	
	
	/**
	 * 󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥݥå
	 * @param style 
	 */
	public TruthRunJobComposite(Composite parent, int style, String itemTrue, String itemFalse) {
		super(parent, style);
		
		m_itemTrue = itemTrue;
		m_itemFalse = itemFalse;
		
		this.initialize();
	}
	
	/**
	 * ݥåȤۤޤ
	 */
	private void initialize() {
		
		// ѿȤѤ٥
		Label label = null;
		// ѿȤѤ륰åɥǡ
		GridData gridData = null;
		
		GridLayout layout = new GridLayout(1, true);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.numColumns = 15;	
		this.setLayout(layout);
		
		// 
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_PRIORITY;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("value"));
		
		// ¹
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_JOB_RUN;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("run"));
		
		// ID
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_JOB_ID + WIDTH_REF_BTN;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("job.id"));
		
		// Ϣư
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_INHIBITION_FLG;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("couple.with.notify.inhibition"));
		
		// ƽмԻ
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_FAILURE_PRIORITY;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("failure.call.value"));
		
		
		/*
         * ͤTrueξ
         */
		label = this.getLabelPriority(this, Messages.getString(m_itemTrue), WIDTH_PRIORITY);
		this.m_checkJobRunTrue = this.getCheckBox(this, WIDTH_JOB_RUN);
		this.m_textJobIdTrue = this.getTextJobId(this, WIDTH_JOB_ID);
		this.m_buttonReferTrue = this.getButtonRefer(this, WIDTH_REF_BTN);
		this.m_checkInhibitionFlgTrue = this.getCheckBox(this, WIDTH_INHIBITION_FLG);
		this.m_comboFailurePriorityTrue = this.getComboPriority(this, WIDTH_FAILURE_PRIORITY);
		
		this.m_checkJobRunTrue.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				setEnabled(m_checkJobRunTrue.getSelection(), m_textJobIdTrue, m_buttonReferTrue, m_checkInhibitionFlgTrue, m_comboFailurePriorityTrue);
			}
		});
		m_buttonReferTrue.addSelectionListener(new JobIdSelectionListener(m_textJobIdTrue));
		
		/*
         * ͤFalseξ
         */
		label = this.getLabelPriority(this, Messages.getString(m_itemFalse), WIDTH_PRIORITY);
		this.m_checkJobRunFalse = this.getCheckBox(this, WIDTH_JOB_RUN);
		this.m_textJobIdFalse = this.getTextJobId(this, WIDTH_JOB_ID);
		this.m_buttonReferFalse = this.getButtonRefer(this, WIDTH_REF_BTN);
		this.m_checkInhibitionFlgFalse = this.getCheckBox(this, WIDTH_INHIBITION_FLG);
		this.m_comboFailurePriorityFalse = this.getComboPriority(this, WIDTH_FAILURE_PRIORITY);
		
		this.m_checkJobRunFalse.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				setEnabled(m_checkJobRunFalse.getSelection(), m_textJobIdFalse, m_buttonReferFalse, m_checkInhibitionFlgFalse, m_comboFailurePriorityFalse);
			}
		});
		m_buttonReferFalse.addSelectionListener(new JobIdSelectionListener(m_textJobIdFalse));
		
//		// ͼμԻ
//		label = this.getLabelPriority(this, Messages.getString("failure.select.value"), WIDTH_PRIORITY);
//		this.m_checkJobRunFailure = this.getCheckBox(this, WIDTH_JOB_RUN);
//		this.m_textJobIdFailure = this.getTextJobId(this, WIDTH_JOB_ID);
//		this.m_buttonReferFailure = this.getButtonRefer(this, WIDTH_REF_BTN);
//		this.m_checkInhibitionFlgFailure = this.getCheckBox(this, WIDTH_INHIBITION_FLG);
//		this.m_comboFailurePriorityFailure = this.getComboPriority(this, WIDTH_FAILURE_PRIORITY);
//		
//		this.m_checkJobRunFailure.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent e) {
//				setEnabled(m_checkJobRunFailure.getSelection(), m_textJobIdFailure, m_buttonReferFailure, m_checkInhibitionFlgFailure, m_comboFailurePriorityFailure);
//			}
//		});
//		m_buttonReferFailure.addSelectionListener(new JobIdSelectionListener(m_textJobIdFailure));
	}
	
	/**
	 * ƹܤͤꤷޤ
	 * 
	 * @param info ͤȤѤƻ
	 */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
			ArrayList list = info.getJudgementInfo();
			if(list != null){
				for(int index=0; index<list.size(); index++){
					MonitorTruthValueInfo truthValueInfo = (MonitorTruthValueInfo)list.get(index);
					if(truthValueInfo != null){
						if(TruthConstant.TYPE_TRUE ==  truthValueInfo.getTruthValue()){
							this.m_checkJobRunTrue.setSelection(YesNoConstant.typeToBoolean(truthValueInfo.getJobRun()));
							if(truthValueInfo.getJobId() != null){
								this.m_textJobIdTrue.setText(truthValueInfo.getJobId());
							}
							this.m_checkInhibitionFlgTrue.setSelection(YesNoConstant.typeToBoolean(truthValueInfo.getJobInhibitionFlg()));
							this.m_comboFailurePriorityTrue.setText(PriorityConstant.typeToString(truthValueInfo.getJobFailurePriority()));
						}
						else if(TruthConstant.TYPE_FALSE ==  truthValueInfo.getTruthValue()){
							this.m_checkJobRunFalse.setSelection(YesNoConstant.typeToBoolean(truthValueInfo.getJobRun()));
							if(truthValueInfo.getJobId() != null){
								this.m_textJobIdFalse.setText(truthValueInfo.getJobId());
							}
							this.m_checkInhibitionFlgFalse.setSelection(YesNoConstant.typeToBoolean(truthValueInfo.getJobInhibitionFlg()));
							this.m_comboFailurePriorityFalse.setText(PriorityConstant.typeToString(truthValueInfo.getJobFailurePriority()));
						}
					}
				}
			}
			
//			this.m_checkJobRunFailure.setSelection(YesNoConstant.typeToBoolean(info.getFailureJobRun()));
//			if(info.getFailureJobId() != null){
//				this.m_textJobIdFailure.setText(info.getFailureJobId());
//			}
//			this.m_checkInhibitionFlgFailure.setSelection(YesNoConstant.typeToBoolean(info.getFailureJobInhibitionFlg()));
//			this.m_comboFailurePriorityFailure.setText(PriorityConstant.typeToString(info.getFailureJobFailurePriority()));
		}
	}
	
	/**
	 * ͤѤƴƻޤ
	 * 
	 * @return ڷ
	 */
	public ValidateResult createInputData(MonitorInfo info) {
		
		ValidateResult validateResult = null;
		
		// ͡OK
		validateResult = setMonitorTruthValueInfo(info, this.m_checkJobRunTrue, this.m_textJobIdTrue, this.m_checkInhibitionFlgTrue, this.m_comboFailurePriorityTrue, TruthConstant.TYPE_TRUE);
		if(validateResult != null){
			return validateResult;
		}
		
		// ͡NG
		validateResult = setMonitorTruthValueInfo(info, this.m_checkJobRunFalse, this.m_textJobIdFalse, this.m_checkInhibitionFlgFalse, this.m_comboFailurePriorityFalse, TruthConstant.TYPE_FALSE);
		if(validateResult != null){
			return validateResult;
		}
		
//		// ͼμԻ
//		info.setFailureJobRun(Integer.valueOf(YesNoConstant.booleanToType(this.m_checkJobRunFailure.getSelection())));
//		if (this.m_textJobIdFailure.getText() != null && !"".equals(this.m_textJobIdFailure.getText().trim())) {
//			info.setFailureJobId(this.m_textJobIdFailure.getText());	
//		}
//		else{
//			if(info.getJobRun() == YesNoConstant.TYPE_YES){
//				if(this.m_checkJobRunFailure.getSelection()){
//					String[] args = { "(" + Messages.getString("failure.select.value") + ")" };
//					return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.25", args));
//				}
//			}
//		}
//		info.setFailureJobInhibitionFlg(Integer.valueOf(YesNoConstant.booleanToType(this.m_checkInhibitionFlgFailure.getSelection())));
//		info.setFailureJobFailurePriority(PriorityConstant.stringToType(this.m_comboFailurePriorityFailure.getText()));
		
		return null;
	}
	
	/**
	 * ͤѤƥּ¹ԡIDϢư ڤ ƽмԻꤷޤ
	 * 
	 * @param info ƻ
	 * @param checkJobRun ּ¹ԥåܥå
	 * @param textJobId IDƥȥܥå
	 * @param buttonRefer ȥܥ
	 * @param checkInhibitionFlg ȤϢư
	 * @param comboFailurePriority	ƽмԻ
	 * @param truthValue 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult setMonitorTruthValueInfo(MonitorInfo info, Button checkRunJob, Text textJobId, Button checkInhibitionFlg, Combo comboFailurePriority, int truthValue) {
		
		Integer jobRun = Integer.valueOf(YesNoConstant.booleanToType(checkRunJob.getSelection()));
		String jobId = textJobId.getText();
		Integer jobInhibitionFlg = Integer.valueOf(YesNoConstant.booleanToType(checkInhibitionFlg.getSelection()));
		Integer jobFailurePriority = PriorityConstant.stringToType(comboFailurePriority.getText());
		
		boolean find = false;
		MonitorTruthValueInfo truthValueInfo = null;
		
		ArrayList list = info.getJudgementInfo();
		if(list != null){
			for(int index=0; index<list.size(); index++){
				truthValueInfo = (MonitorTruthValueInfo)list.get(index);
				if(truthValueInfo != null){
					if(truthValue == truthValueInfo.getTruthValue()){
						find = true;
						break;
					}
				}
			}
		}
		
		if(!find){
			truthValueInfo = new MonitorTruthValueInfo();
			truthValueInfo.setMonitorId(info.getMonitorId());
			truthValueInfo.setMonitorTypeId(info.getMonitorTypeId());
			truthValueInfo.setTruthValue(truthValue);
		}
		
		// ּ¹
		truthValueInfo.setJobRun(jobRun);
		
		// ID
		if (jobId != null && !"".equals(jobId.trim())) {
			truthValueInfo.setJobId(jobId);	
		}
		else{
			if(info.getJobRun() == YesNoConstant.TYPE_YES){
				if(checkRunJob.getSelection()){
					String tmp = null;
					if(truthValue == TruthConstant.TYPE_TRUE){
						tmp = m_itemTrue;
					}
					else if(truthValue == TruthConstant.TYPE_FALSE){
						tmp = m_itemFalse;
					}
					String[] args = { "(" + tmp + ")" };
					return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.25", args));
				}
			}
		}
		
		// Ϣư
		truthValueInfo.setJobInhibitionFlg(jobInhibitionFlg);
		// ƽмԻ
		truthValueInfo.setJobFailurePriority(jobFailurePriority);
		
		if(!find){
			list.add(truthValueInfo);
		}
		info.setJudgementInfo(list);
		
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		setEnabled(enabled, m_checkJobRunTrue, m_textJobIdTrue, m_buttonReferTrue, m_checkInhibitionFlgTrue, m_comboFailurePriorityTrue);
		setEnabled(enabled, m_checkJobRunFalse, m_textJobIdFalse, m_buttonReferFalse, m_checkInhibitionFlgFalse, m_comboFailurePriorityFalse);
//		setEnabled(enabled, m_checkJobRunFailure, m_textJobIdFailure, m_buttonReferFailure, m_checkInhibitionFlgFailure, m_comboFailurePriorityFailure);
	}
	
	/**
	 * ݥåȤEnabledꤷޤ
	 * 
	 * @param enabled
	 * @param checkJobRun ּ¹ԥåܥå
	 * @param textJobId IDƥȥܥå
	 * @param buttonRefer ȥܥ
	 * @param checkInhibitionFlg ȤϢư
	 * @param comboFailurePriority	ƽмԻ
	 */
	public void setEnabled(boolean enabled,
			Button checkJobRun,
			Text textJobId,
			Button buttonRefer,
			Button checkInhibitionFlg,
			Combo comboFailurePriority
	) {
		
		checkJobRun.setEnabled(enabled);
		
		if(enabled){
			setEnabled(checkJobRun.getSelection(), textJobId, buttonRefer, checkInhibitionFlg, comboFailurePriority);
		}
		else{
			setEnabled(enabled, textJobId, buttonRefer, checkInhibitionFlg, comboFailurePriority);
		}
	}
	
	/**
	 * ݥåȤEnabledꤷޤ
	 * 
	 * @param enabled
	 * @param textJobId IDƥȥܥå
	 * @param buttonRefer ȥܥ
	 * @param checkInhibitionFlg ȤϢư
	 * @param comboFailurePriority	ƽмԻ
	 */
	public void setEnabled(boolean enabled,
			Text textJobId,
			Button buttonRefer,
			Button checkInhibitionFlg,
			Combo comboFailurePriority
	) {
		
		textJobId.setEnabled(enabled);
		buttonRefer.setEnabled(enabled);
		checkInhibitionFlg.setEnabled(enabled);
		comboFailurePriority.setEnabled(enabled);
	}
	
	/**
	 * ٥ƥȤ֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param text ٥ƥ
	 * @param horizontalSpan 
	 * @return
	 */
	protected Label getLabelPriority(Composite parent,
			String text,
			int horizontalSpan
	) {
		
		// ٥ʽ١
		Label label = new Label(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(text + " : ");
		
		return label;
	}
	
	/**
	 * ٥ܥܥå֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param horizontalSpan 
	 * @return
	 */
	protected Combo getComboPriority(Composite parent, int horizontalSpan) {
		
		Combo combo = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		combo.setLayoutData(gridData);
		combo.add(PriorityConstant.STRING_CRITICAL);
		combo.add(PriorityConstant.STRING_WARNING);
		combo.add(PriorityConstant.STRING_INFO);
		combo.add(PriorityConstant.STRING_UNKNOWN);
		combo.setText(PriorityConstant.STRING_UNKNOWN);
		
		return combo;
	}
	
	/**
	 * åܥå֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param horizontalSpan 
	 * @return
	 */
	protected Button getCheckBox(Composite parent, int horizontalSpan) {
		
		// åܥå
		Button button = new Button(parent, SWT.CHECK);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.CENTER;
		gridData.grabExcessHorizontalSpace = true;
		button.setLayoutData(gridData);
		
		return button;
	}
	
	/**
	 * IDƥȥܥå֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param horizontalSpan 
	 * @return
	 */
	protected Text getTextJobId(Composite parent, int horizontalSpan) {
		
		Text text = new Text(this, SWT.BORDER | SWT.LEFT | SWT.READ_ONLY);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		text.setLayoutData(gridData);
		
		return text;
	}
	
	/**
	 * ȥܥ֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param horizontalSpan 
	 * @return
	 */
	protected Button getButtonRefer(Composite parent, int horizontalSpan) {
		
		Button button = new Button(this, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		button.setLayoutData(gridData);
		button.setText(Messages.getString("refer"));
		
		return button;
	}
	
	
	/**
	 * ̵ͤξꤷޤ
	 *  
	 */
	protected ValidateResult setValidateResult(String id, String message) {
		
		ValidateResult validateResult = new ValidateResult();
		validateResult.setValid(false);
		validateResult.setID(id);
		validateResult.setMessage(message);
		
		return validateResult;
	}
}