/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;

/**
 * ʸƻȽ륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StringValueInfoManager {
	
	// ----- static ե ----- //
	
	/** ͣΥ󥹥 */
	private static StringValueInfoManager INSTANCE = null;
	
	// ----- static ᥽å ----- //
	
	/**
	 * ͣΥ󥹥󥹤֤ޤ
	 * 
	 * @return 󥹥
	 */
	public static StringValueInfoManager getInstance() {
		if (INSTANCE == null) {
			synchronized (StringValueInfoManager.class) {
				if (INSTANCE == null) {
					INSTANCE = new StringValueInfoManager();
				}
			}
		}
		
		return INSTANCE;
	}
	
	// ----- instance ե ----- //
	
	/** Υå */
	private Map<String, MonitorStringValueInfo> m_cashe = null;
	
	/** ꥹ */
	private ArrayList<MonitorStringValueInfo> m_orderList = null;
	
	/** ƻ */
	private MonitorInfo m_monitorInfo = null;

	
	// ----- 󥹥ȥ饯 ----- //
	
	/**
	 * ػߤޤ
	 */
	private StringValueInfoManager() {
	}
	
	/**
	 * 
	 * 
	 * @param monitorInfo ƻ
	 */
	public void initialize(MonitorInfo monitorInfo) {
		
		m_monitorInfo = monitorInfo;
		this.loadLog();
	}
	
	// ----- instance ᥽å ----- //
	
	/**
	 * ƤʸƻȽ֤ޤ
	 * 
	 * @return ʸƻȽ
	 */
	public Object[] get() {
		
		Object[] records = this.m_orderList.toArray();
		return records;
	}
	
	/**
	 * ƤʸƻȽ֤ޤ
	 * 
	 * @return ʸƻȽ
	 */
	public ArrayList getMonitorStringValueInfo() {
		return m_orderList;
	}
	
	/**
	 * ꤷʸƻȽ֤ޤ
	 * 
	 * @param identifier ̻
	 * @return ʸƻȽ
	 */
	public MonitorStringValueInfo get(String identifier) {
		return (MonitorStringValueInfo) this.m_cashe.get(identifier);
	}
	
	/**
	 * ʸƻȽɲäޤ
	 * <p>
	 * 
	 * ȼ̻ҤϼưŪ˳Ƥޤ
	 * 
	 * @param info ʸƻȽ
	 * @return 硢true
	 */
	public boolean add(MonitorStringValueInfo info) {
		
		int order = this.m_cashe.size() + 1;
		
		// ϰָȤ롣
		info.setOrderNo(order);
		// μ̻Ҥ򿶤ʬ롣
		info.setIdentifier("new" + order);
		
		this.m_cashe.put(info.getIdentifier(), info);
		this.m_orderList.add(info);
		return true;
	}
	
	/**
	 * ʸƻȽѹޤ
	 * 
	 * @param info ʸƻȽ
	 * @return 硢true
	 */
	public boolean modify(MonitorStringValueInfo info) {
		if (!this.m_cashe.containsKey(info.getIdentifier())) {
			return false;
		}
		
		this.m_cashe.put(info.getIdentifier(), info);
		this.m_orderList.set(info.getOrderNo() - 1, info);
		return true;
	}
	
	/**
	 * ʸƻȽޤ
	 * 
	 * @param identifier ̻
	 * @return 硢true
	 */
	public boolean delete(String identifier) {
		if (!this.m_cashe.containsKey(identifier)) {
			return false;
		}
		
		MonitorStringValueInfo info = (MonitorStringValueInfo) this.m_cashe.remove(identifier);
		
		this.m_orderList.remove(info.getOrderNo() - 1);
		
		// Ƥʤޤ
		int order = 0;
		Iterator ite = this.m_orderList.iterator();
		while (ite.hasNext()) {
			((MonitorStringValueInfo) ite.next()).setOrderNo(++order);
		}
		
		return true;
	}
	
	/**
	 * ꤷʸƻȽν̤ҤȤľ夲ޤ
	 * 
	 * @param identifier ̻
	 * @return 硢true
	 */
	public boolean upOrder(String identifier) {
		if (!this.m_cashe.containsKey(identifier)) {
			return false;
		}
		
		MonitorStringValueInfo info = (MonitorStringValueInfo) this.m_cashe.get(identifier);
		int oldOrder = info.getOrderNo();
		int newOrder = oldOrder - 1;
		if (newOrder < 1) {
			return false;
		}
		
		return this.change(oldOrder, newOrder);
	}
	
	/**
	 * ꤷʸƻȽν̤ҤȤĲޤ
	 * 
	 * @param identifier ̻
	 * @return 硢true
	 */
	public boolean downOrder(String identifier) {
		if (!this.m_cashe.containsKey(identifier)) {
			return false;
		}
		
		MonitorStringValueInfo info = (MonitorStringValueInfo) this.m_cashe.get(identifier);
		int oldOrder = info.getOrderNo();
		int newOrder = oldOrder + 1;
		if (newOrder > this.m_cashe.size()) {
			return false;
		}
		
		return this.change(oldOrder, newOrder);
	}
	
    /**
     * ʸƻȽɤޤ
     * 
     */
    private void loadLog() {
        this.m_cashe = new HashMap<String, MonitorStringValueInfo>();
        this.m_orderList = new ArrayList<MonitorStringValueInfo>();
        
        if(m_monitorInfo != null){
        	ArrayList records = m_monitorInfo.getJudgementInfo();
        	
        	if(records != null){
        		int index = 0;
            	Iterator ite = records.iterator();
            	while (ite.hasNext()) {
                	Object o = ite.next();
                	MonitorStringValueInfo info = (MonitorStringValueInfo)o;

                	info.setIdentifier("new" + index);
                    this.m_cashe.put(info.getIdentifier(), info);
                    this.m_orderList.add(info);
                    index++;
                }
        	}
        }
    }
	
	/**
	 * ꤷʸƻȽƱΤν̤ؤޤ
	 * <p>
	 * 
	 * ꤹͤϡListΥǥåͤǤϤʤʸƻȽνꤷƲ
	 * 
	 * @param index1 ʸƻȽ󣱤ν
	 * @param index2 ʸƻȽ󣲤ν
	 * @return ˽λ硢true
	 */
	private boolean change(int index1, int index2) {
		MonitorStringValueInfo info1 = (MonitorStringValueInfo) this.m_orderList.get(--index1);
		MonitorStringValueInfo info2 = (MonitorStringValueInfo) this.m_orderList.get(--index2);
		
		int order1 = info1.getOrderNo();
		int order2 = info2.getOrderNo();
		
		// ͤؤޤ
		info1.setOrderNo(order2);
		info2.setOrderNo(order1);
		
		// ꥹȤΰ֤ؤޤ
		this.m_orderList.set(index1, info2);
		this.m_orderList.set(index2, info1);
		
		return true;
	}
}