/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.util.Messages;


/**
 * ξ󥳥ݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class NotifyInfoComposite extends NotifyIdListComposite {

    // ----- instance ե ----- //
	
    /** ץꥱ */
    private Label labelApplication = null;
    private Text textApplication = null;

    // ----- 󥹥ȥ饯 ----- //

	/**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     */
    public NotifyInfoComposite(Composite parent, int style) {
    	super(parent, style, true);

        this.initialize(parent);
    }
    
    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param text ID٥ʸ
     */
    public NotifyInfoComposite(Composite parent, int style, String text) {
    	super(parent, style, text);

        this.initialize(parent);
    }

    // ----- instance ᥽å ----- //

    /**
     * ݥåȤۤޤ
     */
    private void initialize(Composite parent) {
    	
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 15;
        this.setLayout(layout);
        
        /*
         * ץꥱID
         */
        // ٥
        this.labelApplication = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.labelApplication.setLayoutData(gridData);
        this.labelApplication.setText(Messages.getString("application") + " : ");
        // ƥ
        this.textApplication = new Text(this, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textApplication.setLayoutData(gridData);
    }

	
	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		this.textApplication.setEnabled(enabled);
	}
	
	/**
	 * ץꥱ֤ޤ
	 * 
	 * @return ץꥱ
	 */
	public String getApplication() {
		
		return this.textApplication.getText();
	}

	/**
	 * ץꥱꤷޤ
	 */
	public void setApplication(String string) {
		this.textApplication.setText(string);
	}
}