/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.dialog;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.bean.StatusValidPeriodConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.util.Messages;

/**
 * κѹ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyCreateDialog extends CommonDialog {
	
    
	public static final int WIDTH_PRIORITY 		= 1;
	public static final int WIDTH_CHECK 			= 1;
	public static final int WIDTH_COMBO 			= 2;
	public static final int WIDTH_MAIL_ADDRESS 	= 7;

    // ----- instance ե ----- //

    /** ͤݻ륪֥ */
    private NotifyInfo inputData = null;

    /** ͤݻ륪֥ */
    private ValidateResult validateResult = null;
    
    /** ȥե饰 */
    private boolean referenceFlg = false;

    /** ѹоݤID */
    private String notifyId = null;
    
    /** ID */
    private Text textNotifyId = null;

    /** ܺ */
    private Text textDescription = null;
    
    /** ơ */
    private Button checkStatus = null;
    
    /** ơ ͭ֡ʬ*/
    private Combo comboStatusValidPeriod = null;

    /** ơ ַͭвΰ */
    private Button radioStatusDelete = null;

    /** ơ ַͭвΰƤʤݤΥåִ롣 */
    private Button radioStatusUpdate = null;
    
    /** ơ ν */
    private Combo comboStatusPriority = null;
    
    /** ٥ */
    private Button checkEvent = null;

    /** ٥ Τʽ١Ρ */ 
    private Button checkEventNormalInfo = null;
    /** ٥ Τʽ١ٹ */
    private Button checkEventNormalWarning = null;
    /** ٥ Τʽ١۾ */
    private Button checkEventNormalCritical = null;
    /** ٥ Τʽ١ */
    private Button checkEventNormalUnknown = null;

    /** ٥ ξ֡ʽ١Ρ */ 
    private Combo comboEventNormalInfo = null;
    /** ٥ ξ֡ʽ١ٹ */
    private Combo comboEventNormalWarning = null;
    /** ٥ ξ֡ʽ١۾ */
    private Combo comboEventNormalCritical = null;
    /** ٥ ξ֡ʽ١ */
    private Combo comboEventNormalUnknown = null;
    
    /** ٥ ʽ١Ρ */ 
    private Button checkEventInhibitionInfo = null;
    /** ٥ ʽ١ٹ */
    private Button checkEventInhibitionWarning = null;
    /** ٥ ʽ١۾ */
    private Button checkEventInhibitionCritical = null;
    /** ٥ ʽ١ */
    private Button checkEventInhibitionUnknown = null;
    
    /** ٥ ֡ʽ١Ρ */ 
    private Combo comboEventInhibitionInfo = null;
    /** ٥ ֡ʽ١ٹ */
    private Combo comboEventInhibitionWarning = null;
    /** ٥ ֡ʽ١۾ */
    private Combo comboEventInhibitionCritical = null;
    /** ٥ ֡ʽ١ */
    private Combo comboEventInhibitionUnknown = null;
    
    /** ٥ ʽ١Ρ */ 
    private Button checkMailInfo = null;
    /** ٥ ʽ١ٹ */
    private Button checkMailWarning = null;
    /** ٥ ʽ١۾ */
    private Button checkMailCritical = null;
    /** ٥ ʽ١ */
    private Button checkMailUnknown = null;
    
    /** ٥ ʽ١Ρ */ 
    private Text textMailInfo = null;
    /** ٥ ʽ١ٹ */
    private Text textMailWarning = null;
    /** ٥ ʽ١۾ */
    private Text textMailCritical = null;
    /** ٥ ʽ١ */
    private Text textMailUnknown = null;

    /** ʤ */
    private Button radioNoInhibition = null;

    /** ֻ */
    private Button radioInhibitionPeriod = null;

    /**  */
    private Text textInhibitionPeriod = null;

    /**  */
    private Button radioInhibitionFrequency = null;

    /**  */
    private Text textInhibitionFrequency = null;

    /** ٻ */
    private Button radioInhibitionPriority = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public NotifyCreateDialog(Shell parent) {
        super(parent);
    }

    /**
     * ѹѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param notifyId
     *            ѹID
     */
    public NotifyCreateDialog(Shell parent, String notifyId, boolean referenceFlg) {
        super(parent);

        this.notifyId = notifyId;
        this.referenceFlg = referenceFlg;
    }

    // ----- instance ᥽å ----- //

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.notify.create.modify"));

        // ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        /*
         * ID
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.id") + " : ");
        // ƥ
        this.textNotifyId = new Text(parent, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textNotifyId.setLayoutData(gridData);
        if(this.notifyId != null && !"".equals(this.notifyId.trim())){
        	this.textNotifyId.setEnabled(false);
        }
        
        // 
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        /*
         * 
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("description") + " : ");
        // ƥ
        this.textDescription = new Text(parent, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData(gridData);
        // 
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        /*
         * ơ
         */
        this.checkStatus = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.checkStatus.setLayoutData(gridData);
        this.checkStatus.setText(Messages.getString("notifies.status") + " : ");
        this.checkStatus.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                setEnabledForStatus(checkStatus.getSelection());
            }
        });
        
        /*
         * 祰롼
         */
        // ơΥ롼
        Group groupStatus1 = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupStatus1.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupStatus1.setLayoutData(gridData);

        /*
         * ơͭ֡ʬ
         */
        // ٥
        label = new Label(groupStatus1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.status.valid.period") + " : ");
        // ܥܥå
        this.comboStatusValidPeriod = new Combo(groupStatus1, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.comboStatusValidPeriod.setLayoutData(gridData);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_UNLIMITED);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_10);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_20);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_30);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_1);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_3);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_6);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_12);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_DAY_1);
        
        // 
        label = new Label(groupStatus1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ٥
        label = new Label(groupStatus1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.status.invalid.period.treatment") + " : ");
        
        /*
         * 楰롼
         */
        // ơַͭвΰΥ롼
        Group groupStatus2 = new Group(groupStatus1, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupStatus2.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupStatus2.setLayoutData(gridData);
        
        // 
        this.radioStatusDelete = new Button(groupStatus2, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioStatusDelete.setLayoutData(gridData);
        this.radioStatusDelete.setText(Messages.getString("notify.status.invalid.period.delete"));

        // ƤʤݤΥåִ롣
        this.radioStatusUpdate = new Button(groupStatus2, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioStatusUpdate.setLayoutData(gridData);
        this.radioStatusUpdate.setText(Messages.getString("notify.status.invalid.period.updatet"));
        this.radioStatusUpdate.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	comboStatusPriority.setEnabled(radioStatusUpdate.getSelection());
            }
        });
        
        /*
         * ơ 
         */
        // ٥
        label = new Label(groupStatus2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("priority") + " : ");
        // ܥܥå
        this.comboStatusPriority = new Combo(groupStatus2, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.comboStatusPriority.setLayoutData(gridData);
        this.comboStatusPriority.add(PriorityConstant.STRING_CRITICAL);
        this.comboStatusPriority.add(PriorityConstant.STRING_WARNING);
        this.comboStatusPriority.add(PriorityConstant.STRING_INFO);
        this.comboStatusPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.comboStatusPriority.setText(PriorityConstant.STRING_WARNING);
        // 
        label = new Label(groupStatus2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * ٥
         */
        this.checkEvent = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.checkEvent.setLayoutData(gridData);
        this.checkEvent.setText(Messages.getString("notifies.event") + " : ");
        this.checkEvent.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	setEnabledForEvent(checkEvent.getSelection());
            }
        });
        
        /*
         * 祰롼
         */
        // ٥Υ롼
        Group groupEvent1 = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent1.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent1.setLayoutData(gridData);
        
        /*
         * 楰롼
         */
        // ٥
        Group groupEvent2 = new Group(groupEvent1, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent2.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent2.setLayoutData(gridData);
        
        // ٥ʽ١
        label = new Label(groupEvent2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_PRIORITY;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ٥Τ
        label = new Label(groupEvent2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.treatment.normal"));

        // ٥ξ֡
        label = new Label(groupEvent2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_COMBO;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.state.normal"));

        // ٥
        label = new Label(groupEvent2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.treatment.inhibition"));

        // ٥ξ֡
        label = new Label(groupEvent2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_COMBO;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.state.inhibition"));
        
        // ٥
        label = new Label(groupEvent2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.treatment.mail"));
        
        // ٥ʥߥڤˡ
        label = new Label(groupEvent2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_MAIL_ADDRESS;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("email.address.ssv") + " : ");
        
        // ٥ ١
        label = this.getLabelPriority(groupEvent2, Messages.getString("info"),PriorityColorConstant.COLOR_INFO);
        this.checkEventNormalInfo = this.getCheckEventNormal(groupEvent2);
        this.comboEventNormalInfo = this.getComboEventNormal(groupEvent2);
        this.checkEventInhibitionInfo = this.getCheckEventInhibition(groupEvent2);
        this.comboEventInhibitionInfo = this.getComboEventInhibition(groupEvent2);
        this.checkMailInfo = this.getCheckMail(groupEvent2);
        this.textMailInfo = this.getTextMail(groupEvent2);
        
        this.checkEventNormalInfo.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		setEnabledForEvent(checkEventNormalInfo.getSelection(), comboEventNormalInfo, checkEventInhibitionInfo, comboEventInhibitionInfo, checkMailInfo, textMailInfo);
        	}
        });
		this.comboEventNormalInfo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventNormalInfo.getText())){
					comboEventInhibitionInfo.setText(EventConfirmConstant.STRING_DESTRUCTION);
				}
			}
		});
      	this.checkEventInhibitionInfo.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent e) {
	        	comboEventInhibitionInfo.setEnabled(checkEventInhibitionInfo.getSelection());
	        }
	    });
      	this.comboEventInhibitionInfo.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventInhibitionInfo.getText())){
      				comboEventNormalInfo.setText(EventConfirmConstant.STRING_UNCONFIRMED);
      			}
      		}
      	});
      	this.checkMailInfo.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			textMailInfo.setEnabled(checkMailInfo.getSelection());
      		}
      	});

        // ٥ ١ٹ
        label = this.getLabelPriority(groupEvent2, Messages.getString("warning"),PriorityColorConstant.COLOR_WARNING);
        this.checkEventNormalWarning = this.getCheckEventNormal(groupEvent2);
        this.comboEventNormalWarning = this.getComboEventNormal(groupEvent2);
        this.checkEventInhibitionWarning = this.getCheckEventInhibition(groupEvent2);
        this.comboEventInhibitionWarning = this.getComboEventInhibition(groupEvent2);
        this.checkMailWarning = this.getCheckMail(groupEvent2);
        this.textMailWarning = this.getTextMail(groupEvent2);
        
        this.checkEventNormalWarning.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		setEnabledForEvent(checkEventNormalWarning.getSelection(), comboEventNormalWarning, checkEventInhibitionWarning, comboEventInhibitionWarning, checkMailWarning, textMailWarning);
        	}
        });
		this.comboEventNormalWarning.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventNormalWarning.getText())){
					comboEventInhibitionWarning.setText(EventConfirmConstant.STRING_DESTRUCTION);
				}
			}
		});
      	this.checkEventInhibitionWarning.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent e) {
	        	comboEventInhibitionWarning.setEnabled(checkEventInhibitionWarning.getSelection());
	        }
	    });
      	this.comboEventInhibitionWarning.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventInhibitionWarning.getText())){
      				comboEventNormalWarning.setText(EventConfirmConstant.STRING_UNCONFIRMED);
      			}
      		}
      	});
      	this.checkMailWarning.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			textMailWarning.setEnabled(checkMailWarning.getSelection());
      		}
      	});
        
        // ٥ ١۾
        label = this.getLabelPriority(groupEvent2, Messages.getString("critical"),PriorityColorConstant.COLOR_CRITICAL);
        this.checkEventNormalCritical = this.getCheckEventNormal(groupEvent2);
        this.comboEventNormalCritical = this.getComboEventNormal(groupEvent2);
        this.checkEventInhibitionCritical = this.getCheckEventInhibition(groupEvent2);
        this.comboEventInhibitionCritical = this.getComboEventInhibition(groupEvent2);
        this.checkMailCritical = this.getCheckMail(groupEvent2);
        this.textMailCritical = this.getTextMail(groupEvent2);
        
        this.checkEventNormalCritical.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		setEnabledForEvent(checkEventNormalCritical.getSelection(), comboEventNormalCritical, checkEventInhibitionCritical, comboEventInhibitionCritical, checkMailCritical, textMailCritical);
        	}
        });
		this.comboEventNormalCritical.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventNormalCritical.getText())){
					comboEventInhibitionCritical.setText(EventConfirmConstant.STRING_DESTRUCTION);
				}
			}
		});
      	this.checkEventInhibitionCritical.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent e) {
	        	comboEventInhibitionCritical.setEnabled(checkEventInhibitionCritical.getSelection());
	        }
	    });
      	this.comboEventInhibitionCritical.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventInhibitionCritical.getText())){
      				comboEventNormalCritical.setText(EventConfirmConstant.STRING_UNCONFIRMED);
      			}
      		}
      	});
      	this.checkMailCritical.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			textMailCritical.setEnabled(checkMailCritical.getSelection());
      		}
      	});

        // ٥ ١
        label = this.getLabelPriority(groupEvent2, Messages.getString("unknown"),PriorityColorConstant.COLOR_UNKNOWN);
        this.checkEventNormalUnknown = this.getCheckEventNormal(groupEvent2);
        this.comboEventNormalUnknown = this.getComboEventNormal(groupEvent2);
        this.checkEventInhibitionUnknown = this.getCheckEventInhibition(groupEvent2);
        this.comboEventInhibitionUnknown = this.getComboEventInhibition(groupEvent2);
        this.checkMailUnknown = this.getCheckMail(groupEvent2);
        this.textMailUnknown = this.getTextMail(groupEvent2);
        
        this.checkEventNormalUnknown.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		setEnabledForEvent(checkEventNormalUnknown.getSelection(), comboEventNormalUnknown, checkEventInhibitionUnknown, comboEventInhibitionUnknown, checkMailUnknown, textMailUnknown);
        	}
        });
		this.comboEventNormalUnknown.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventNormalUnknown.getText())){
					comboEventInhibitionUnknown.setText(EventConfirmConstant.STRING_DESTRUCTION);
				}
			}
		});
      	this.checkEventInhibitionUnknown.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent e) {
	        	comboEventInhibitionUnknown.setEnabled(checkEventInhibitionUnknown.getSelection());
	        }
	    });
      	this.comboEventInhibitionUnknown.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventInhibitionUnknown.getText())){
      				comboEventNormalUnknown.setText(EventConfirmConstant.STRING_UNCONFIRMED);
      			}
      		}
      	});
      	this.checkMailUnknown.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			textMailUnknown.setEnabled(checkMailUnknown.getSelection());
      		}
      	});
        
        // ٥
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.inhibition") + " : ");
        
        /*
         * 楰롼
         */
        // ٥Ƚʣβ롼
        Group groupEvent3 = new Group(groupEvent1, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent3.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent3.setLayoutData(gridData);
        
        // ٥
        label = new Label(groupEvent3, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.inhibition.timing") + " : ");
        
        /*
         * 롼
         */
        // Υߥ󥰥롼
        Group groupEvent4 = new Group(groupEvent3, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent4.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent4.setLayoutData(gridData);
        
        // 饸ܥʤ
        this.radioNoInhibition = new Button(groupEvent4, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioNoInhibition.setLayoutData(gridData);
        this.radioNoInhibition.setText(Messages.getString("suppress.no"));

        // 饸ܥʴ֤
        this.radioInhibitionPeriod = new Button(groupEvent4, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionPeriod.setLayoutData(gridData);
        this.radioInhibitionPeriod.setText(Messages.getString("suppress.by.time.interval") + " : ");
        this.radioInhibitionPeriod.addSelectionListener(new SelectionAdapter() {
          public void widgetSelected(SelectionEvent e) {
              textInhibitionPeriod.setEnabled(radioInhibitionPeriod.getSelection());
              textInhibitionFrequency.setEnabled(radioInhibitionFrequency.getSelection());
          }
        });

        // ƥȥܥåʴ֤
        this.textInhibitionPeriod = new Text(groupEvent4, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textInhibitionPeriod.addVerifyListener(new PositiveNumberVerifyListener());
        this.textInhibitionPeriod.setLayoutData(gridData);
        
        // 
        label = new Label(groupEvent4, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        
        // 饸ܥʲ
        this.radioInhibitionFrequency = new Button(groupEvent4, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionFrequency.setLayoutData(gridData);
        this.radioInhibitionFrequency.setText(Messages.getString("suppress.by.counter") + " : ");
        this.radioInhibitionFrequency.addSelectionListener(new SelectionAdapter() {
          public void widgetSelected(SelectionEvent e) {
        	  textInhibitionPeriod.setEnabled(radioInhibitionPeriod.getSelection());
        	  textInhibitionFrequency.setEnabled(radioInhibitionFrequency.getSelection());
          }
        });

        // ƥȥܥåʲ
        this.textInhibitionFrequency = new Text(groupEvent4, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textInhibitionFrequency.addVerifyListener(new PositiveNumberVerifyListener());
        this.textInhibitionFrequency.setLayoutData(gridData);
        
        // 
        label = new Label(groupEvent4, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        
        // 饸ܥʽ٤
        this.radioInhibitionPriority = new Button(groupEvent4, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionPriority.setLayoutData(gridData);
        this.radioInhibitionPriority.setText(Messages.getString("suppress.by.priority") + " : ");
        this.radioInhibitionPriority.addSelectionListener(new SelectionAdapter() {
          public void widgetSelected(SelectionEvent e) {
        	  textInhibitionPeriod.setEnabled(radioInhibitionPeriod.getSelection());
        	  textInhibitionFrequency.setEnabled(radioInhibitionFrequency.getSelection());
          }
        });

        // 
        label = new Label(groupEvent4, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 11;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        line.setLayoutData(gridData);

        // Ŭ
        // åɥ쥤ȤѤ硢ʤȲ̤äѤˤʤޤ
        shell.pack();
        shell.setSize(new Point(780, shell.getSize().y));

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);

        // IDꤵƤ硢ξɽ롣
        NotifyInfo info = null; 
        if(this.notifyId != null){
        	info = new GetNotify().getNotify(this.notifyId);        	
        }
        else{
        	info = new NotifyInfo();
        }
        this.setInputData(info);
        
    }

    /**
     * Ƥ֤ޤ
     * 
     * @return Ƥݻξ
     */
    public NotifyInfo getInputData() {
        return this.inputData;
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param notify
     *            ͤȤѤξ
     */
    protected void setInputData(NotifyInfo notify) {

        this.inputData = notify;

        // ƹܤȿ
        if (notify.getNotifyId() != null) {
            this.textNotifyId.setText(notify.getNotifyId());
        }
        if (notify.getDescription() != null) {
            this.textDescription.setText(notify.getDescription());
        }
        
        // ơ
        if (notify.getStatusFlg().intValue() == ValidConstant.TYPE_VALID) {
            this.checkStatus.setSelection(true);
        } else {
            this.checkStatus.setSelection(false);
        }      
        if (notify.getStatusValidPeriod() != null) {
            this.comboStatusValidPeriod.setText(StatusValidPeriodConstant.typeToString(notify.getStatusValidPeriod().intValue()));
        }
        if (notify.getStatusInvalidFlg() != null && notify.getStatusInvalidFlg().intValue() == StatusExpirationConstant.TYPE_DELETE) {
            this.radioStatusDelete.setSelection(true);
        } else {
            this.radioStatusUpdate.setSelection(true);
        }
        this.comboStatusPriority.setText(PriorityConstant.typeToString(notify.getStatusUpdatePriority().intValue()));
        
        // ٥
        if (notify.getEventFlg() != null && notify.getEventFlg().intValue() == ValidConstant.TYPE_VALID) {
            this.checkEvent.setSelection(true);
        } else {
            this.checkEvent.setSelection(false);
        }
        
        ArrayList list = notify.getNotifyEventInfo();
        if(list != null){
            for(int index=0; index<list.size(); index++){
            	NotifyEventInfo event = (NotifyEventInfo)list.get(index);
            	if(event != null){
                	if(PriorityConstant.TYPE_INFO ==  event.getPriority()){
                        this.setInputDataForEvent(event, this.checkEventNormalInfo, 	this.comboEventNormalInfo, 		this.checkEventInhibitionInfo, 		this.comboEventInhibitionInfo, 		this.checkMailInfo, 	this.textMailInfo);
                	}
                	else if(PriorityConstant.TYPE_WARNING ==  event.getPriority()){
                        this.setInputDataForEvent(event, this.checkEventNormalWarning, 	this.comboEventNormalWarning, 	this.checkEventInhibitionWarning, 	this.comboEventInhibitionWarning, 	this.checkMailWarning, 	this.textMailWarning);
                	}
                	else if(PriorityConstant.TYPE_CRITICAL ==  event.getPriority()){
                        this.setInputDataForEvent(event, this.checkEventNormalCritical, this.comboEventNormalCritical, 	this.checkEventInhibitionCritical, 	this.comboEventInhibitionCritical, 	this.checkMailCritical,	this.textMailCritical);
                	}
                	else if(PriorityConstant.TYPE_UNKNOWN ==  event.getPriority()){
                        this.setInputDataForEvent(event, this.checkEventNormalUnknown, 	this.comboEventNormalUnknown, 	this.checkEventInhibitionUnknown, 	this.comboEventInhibitionUnknown, 	this.checkMailUnknown, 	this.textMailUnknown);
                	}
            	}
            }
        }
        
        // ٥Ȥ
        if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg().intValue() == ExclusionConstant.TYPE_PERIOD) {
            this.radioInhibitionPeriod.setSelection(true);
        } else if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg().intValue() == ExclusionConstant.TYPE_FREQUENCY) {
            this.radioInhibitionFrequency.setSelection(true);
        } else if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg().intValue() == ExclusionConstant.TYPE_PRIORITY) {
            this.radioInhibitionPriority.setSelection(true);
        } else {
            this.radioNoInhibition.setSelection(true);
        }
        if (notify.getInhibitionPeriod() != null) {
        	this.textInhibitionPeriod.setText(notify.getInhibitionPeriod().toString());
        }
        if (notify.getInhibitionFrequency() != null) {
        	this.textInhibitionFrequency.setText(notify.getInhibitionFrequency().toString());
        }

        // 
        if(this.referenceFlg){
        	this.setEnabled(false);
        }
        else{
        	this.setEnabledForStatus(this.checkStatus.getSelection());
            this.setEnabledForEvent(this.checkEvent.getSelection());
        }
        
    }

    /**
     * ͤѤξޤ
     * 
     * @return ͤݻξ
     */
    protected NotifyInfo createInputData() {
        NotifyInfo info = new NotifyInfo();

        if (this.textNotifyId.getText() != null
                && !"".equals((this.textNotifyId.getText()).trim())) {
        	info.setNotifyId(this.textNotifyId.getText());
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.10"));
            return null;
        }
        if (this.textDescription.getText() != null
                && !"".equals((this.textDescription.getText()).trim())) {
        	info.setDescription(this.textDescription.getText());
        }
        
        // ơ
        if (this.checkStatus.getSelection()) {
            info.setStatusFlg(ValidConstant.TYPE_VALID);
        } else {
            info.setStatusFlg(ValidConstant.TYPE_INVALID);
        }
        if (this.comboStatusValidPeriod.getText() != null
                && !"".equals((this.comboStatusValidPeriod.getText()).trim())) {
        	info.setStatusValidPeriod(new Integer(StatusValidPeriodConstant.stringToType(this.comboStatusValidPeriod.getText())));
        }
        else{
        	if(this.checkStatus.getSelection()){
            	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.12"));
            	return null;
        	}
        }
        if (this.radioStatusDelete.getSelection()) {
            info.setStatusInvalidFlg(StatusExpirationConstant.TYPE_DELETE);
        } else {
            info.setStatusInvalidFlg(StatusExpirationConstant.TYPE_UPDATE);
        }
        if (this.comboStatusPriority.getText() != null
                && !"".equals((this.comboStatusPriority.getText()).trim())) {
        	info.setStatusUpdatePriority(new Integer(PriorityConstant.stringToType(this.comboStatusPriority.getText())));
        }
        
        // ٥
        if (this.checkEvent.getSelection()) {
            info.setEventFlg(ValidConstant.TYPE_VALID);
        } else {
            info.setEventFlg(ValidConstant.TYPE_INVALID);
        }
        
        // ٥Τ򤵤Ƥ뤬ƽ٤ǣĤΤ򤵤Ƥʤϥ顼
        if (this.checkEvent.getSelection()) {
        	if(!this.checkEventNormalInfo.getSelection() && !this.checkEventNormalWarning.getSelection() && !this.checkEventNormalCritical.getSelection() && !this.checkEventNormalUnknown.getSelection()){
            	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.13"));
                    return null;
        	}
        }
        
        ArrayList<NotifyEventInfo> list = new ArrayList<NotifyEventInfo>();
        
        list = this.createInputDataForEvent(list, PriorityConstant.TYPE_INFO,		this.checkEventNormalInfo, 		this.comboEventNormalInfo, 		this.checkEventInhibitionInfo, 		this.comboEventInhibitionInfo, 		this.checkMailInfo, 	this.textMailInfo);
        list = this.createInputDataForEvent(list, PriorityConstant.TYPE_WARNING,	this.checkEventNormalWarning,		this.comboEventNormalWarning, 	this.checkEventInhibitionWarning, 	this.comboEventInhibitionWarning, 	this.checkMailWarning, 	this.textMailWarning);
        list = this.createInputDataForEvent(list, PriorityConstant.TYPE_CRITICAL,	this.checkEventNormalCritical,	this.comboEventNormalCritical, 	this.checkEventInhibitionCritical, 	this.comboEventInhibitionCritical, 	this.checkMailCritical,	this.textMailCritical);
        list = this.createInputDataForEvent(list, PriorityConstant.TYPE_UNKNOWN,	this.checkEventNormalUnknown, 	this.comboEventNormalUnknown, 	this.checkEventInhibitionUnknown, 	this.comboEventInhibitionUnknown, 	this.checkMailUnknown, 	this.textMailUnknown);
        
        if(list == null){
        	return null;
        }
        info.setNotifyEventInfo(list);
        
        // 
        if (this.radioInhibitionPeriod.getSelection()) {
            info.setInhibitionFlg(ExclusionConstant.TYPE_PERIOD);
        }
        else if(this.radioInhibitionFrequency.getSelection()) {
        	info.setInhibitionFlg(ExclusionConstant.TYPE_FREQUENCY);
        }
        else if(this.radioInhibitionPriority.getSelection()) {
        	info.setInhibitionFlg(ExclusionConstant.TYPE_PRIORITY);
        }
        else {
            info.setInhibitionFlg(ExclusionConstant.TYPE_NO);
        }
        
        try {
            info.setInhibitionPeriod(Integer.parseInt(this.textInhibitionPeriod.getText()));
        } catch (NumberFormatException e) {
            if (this.checkEvent.getSelection()
                    && this.radioInhibitionPeriod.getSelection()) {
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.14"));
                return null;
            }
        }
        try {
            info.setInhibitionFrequency(Integer.parseInt(this.textInhibitionFrequency.getText()));
        } catch (NumberFormatException e) {
            if (this.checkEvent.getSelection()
                    && this.radioInhibitionFrequency.getSelection()) {
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.15"));
                return null;
            }
        }

        return info;
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        // 
        this.inputData = this.createInputData();

        if (this.inputData != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
    /**
     * ٥Τν٥ƥȤ֤ޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected Label getLabelPriority(Composite parent,
    		String text,
    		Color background
    		) {
    	
    	// ٥ʽ١
    	Label label = new Label(parent, SWT.NONE);
    	GridData gridData = new GridData();
    	gridData.horizontalSpan = WIDTH_PRIORITY;
    	gridData.horizontalAlignment = GridData.FILL;
    	gridData.grabExcessHorizontalSpace = true;
    	label.setLayoutData(gridData);
    	label.setText(text + " : ");
    	label.setBackground(background);
        
        return label;
    }
    
    /**
     * ٥ΤΤåܥå֤ޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected Button getCheckEventNormal(Composite parent) {
    	
        // åܥåΤ
    	Button button = new Button(parent, SWT.CHECK);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.CENTER;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);
        
        return button;
    }
    
    /**
     * ٥Τξ֥ܥܥå֤ޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected Combo getComboEventNormal(Composite parent) {
    	
        // ܥܥåξ֡
    	Combo combo = new Combo(parent, SWT.DROP_DOWN | SWT.READ_ONLY);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_COMBO;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData(gridData);
        combo.add(EventConfirmConstant.STRING_UNCONFIRMED);
        combo.add(EventConfirmConstant.STRING_CONFIRMED);
        combo.setText(EventConfirmConstant.STRING_UNCONFIRMED);
        
        return combo;
    }
    
    /**
     * ٥Τåܥå֤ޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected Button getCheckEventInhibition(Composite parent) {
    	
        // åܥå
        Button button = new Button(parent, SWT.CHECK);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.CENTER;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);
        
        return button;
    }
    
    /**
     * ٥Τξ֥ܥܥå֤ޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected Combo getComboEventInhibition(Composite parent) {
    	
        // ܥܥåξ֡
        Combo combo = new Combo(parent, SWT.DROP_DOWN | SWT.READ_ONLY);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_COMBO;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData(gridData);
        combo.add(EventConfirmConstant.STRING_CONFIRMED);
        combo.add(EventConfirmConstant.STRING_DESTRUCTION);
        combo.setText(EventConfirmConstant.STRING_CONFIRMED);
        
        return combo;
    }
    
    /**
     * ٥Τåܥå֤ޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected Button getCheckMail(Composite parent) {
    	
        // åܥå
        Button button = new Button(parent, SWT.CHECK);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.CENTER;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);
        
        return button;
    }
    
    /**
     * ٥Τƥȥܥå֤ޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected Text getTextMail(Composite parent) {
    	
        // ƥȡʥߥڤˡ
    	Text text = new Text(parent, SWT.BORDER);
    	GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_MAIL_ADDRESS;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData(gridData);
        
        return text;
    }
    
    /**
     * ͤѤƥ٥Ⱦޤ
     * 
     * @param checkEventNormal Τåܥå
     * @param comboEventNormal ξ֥ܥܥå
     * @param checkEventInhibition åܥå
     * @param comboEventInhibition ξ֥ܥܥå
     * @param checkMail åܥå
     * @param textMail ƥȥܥå
     * @return Υ٥Ⱦꥹ
     */
    protected ArrayList<NotifyEventInfo> createInputDataForEvent(ArrayList<NotifyEventInfo> list,
    		int priority,
    		Button checkEventNormal, 
    		Combo comboEventNormal,
    		Button checkEventInhibition, 
    		Combo comboEventInhibition,
    		Button checkMail,
    		Text textMail
    		) {
    	
    	if(list == null)
    		return null;
    	
    	NotifyEventInfo event = new NotifyEventInfo();
    	
    	event.setPriority(priority);
        if (checkEventNormal.getSelection()) {
        	event.setEventNormalFlg(new Integer(ValidConstant.TYPE_VALID));
        } else {
        	event.setEventNormalFlg(new Integer(ValidConstant.TYPE_INVALID));
        }
        if (comboEventNormal.getText() != null
                && !"".equals((comboEventNormal.getText()).trim())) {
        	event.setEventNormalState(new Integer(EventConfirmConstant.stringToType(comboEventNormal.getText())));
        }
        if (checkEventInhibition.getSelection()) {
        	if(checkEvent.getSelection() && checkEventNormal.getSelection() && radioNoInhibition.getSelection()){
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.16"));
                return null;
        	}
    		event.setEventInhibitionFlg(new Integer(ValidConstant.TYPE_VALID));
        } else {
        	event.setEventInhibitionFlg(new Integer(ValidConstant.TYPE_INVALID));
        }
        if (comboEventInhibition.getText() != null
                && !"".equals((comboEventInhibition.getText()).trim())) {
        	event.setEventInhibitionState(new Integer(EventConfirmConstant.stringToType(comboEventInhibition.getText())));
        }
        if (checkMail.getSelection()) {
        	event.setMailFlg(new Integer(ValidConstant.TYPE_VALID));
        } else {
        	event.setMailFlg(new Integer(ValidConstant.TYPE_INVALID));
        }
        if (textMail.getText() != null
                && !"".equals((textMail.getText()).trim())) {
        	event.setMailAddress(textMail.getText());
        } else {
        	if(checkEvent.getSelection() && checkEventNormal.getSelection() && checkMail.getSelection()){
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.17"));
                return null;
        	}
        }
        list.add(event);
        return list;
    }
    
    /**
     * ƥ٥Ȥιܤͤꤷޤ
     * 
     * @param info ͤȤѤξ
     * @param checkEventNormal Τåܥå
     * @param comboEventNormal ξ֥ܥܥå
     * @param checkEventInhibition åܥå
     * @param comboEventInhibition ξ֥ܥܥå
     * @param checkMail åܥå
     * @param textMail ƥȥܥå
     */
    private void setInputDataForEvent(NotifyEventInfo info, 
    		Button checkEventNormal, 
    		Combo comboEventNormal,
    		Button checkEventInhibition, 
    		Combo comboEventInhibition,
    		Button checkMail,
    		Text textMail
    		) {
    	
        if (info.getEventNormalFlg() != null && info.getEventNormalFlg().intValue() == ValidConstant.TYPE_VALID) {
        	checkEventNormal.setSelection(true);
        } 
        if (info.getEventNormalState() != null) {
        	comboEventNormal.setText(EventConfirmConstant.typeToString(info.getEventNormalState().intValue()));
        }
        if (info.getEventInhibitionFlg() != null && info.getEventInhibitionFlg().intValue() == ValidConstant.TYPE_VALID) {
        	checkEventInhibition.setSelection(true);
        } 
        if (info.getEventInhibitionState() != null) {
        	comboEventInhibition.setText(EventConfirmConstant.typeToString(info.getEventInhibitionState().intValue()));
        }
        if (info.getMailFlg() != null && info.getMailFlg().intValue() == ValidConstant.TYPE_VALID) {
        	checkMail.setSelection(true);
        } 
        if (info.getMailAddress() != null) {
        	textMail.setText(info.getMailAddress());
        }
    }
    
    /**
     * ݥåȤEnabledꤷޤ
     * 
     * @param enable Enabled
     */
    private void setEnabled(boolean enable) {

    	this.textDescription.setEnabled(enable);
    	this.checkStatus.setEnabled(enable);
    	this.checkEvent.setEnabled(enable);
    	
    	this.setEnabledForStatus(enable);
        this.setEnabledForEvent(enable);
    }
    
    /**
     * ơΤΥݥåȤEnabledꤷޤ
     * 
     * @param enable ơΥåܥåEnabled
     */
    private void setEnabledForStatus(boolean enable) {

        this.comboStatusValidPeriod.setEnabled(enable);
    	this.radioStatusDelete.setEnabled(enable);
        this.radioStatusUpdate.setEnabled(enable);
        if (enable) {
            this.comboStatusPriority.setEnabled(this.radioStatusUpdate.getSelection());
        } else {
            this.comboStatusPriority.setEnabled(enable);
        }
    }
    
    /**
     * ٥ΤΥݥåȤEnabledꤷޤ
     * 
     * @param enable ٥ΥåܥåEnabled
     */
    private void setEnabledForEvent(boolean enable) {

    	// δϢ
        this.setEnabledForEvents(enable, this.checkEventNormalInfo, 	this.comboEventNormalInfo, 		this.checkEventInhibitionInfo, 		this.comboEventInhibitionInfo, 		this.checkMailInfo, 	this.textMailInfo);
        this.setEnabledForEvents(enable, this.checkEventNormalWarning, 	this.comboEventNormalWarning, 	this.checkEventInhibitionWarning, 	this.comboEventInhibitionWarning, 	this.checkMailWarning, 	this.textMailWarning);
        this.setEnabledForEvents(enable, this.checkEventNormalCritical, this.comboEventNormalCritical, 	this.checkEventInhibitionCritical, 	this.comboEventInhibitionCritical, 	this.checkMailCritical,	this.textMailCritical);
        this.setEnabledForEvents(enable, this.checkEventNormalUnknown, 	this.comboEventNormalUnknown, 	this.checkEventInhibitionUnknown, 	this.comboEventInhibitionUnknown, 	this.checkMailUnknown, 	this.textMailUnknown);

        // Ϣ
        this.radioNoInhibition.setEnabled(enable);
        this.radioInhibitionPeriod.setEnabled(enable);
        this.radioInhibitionFrequency.setEnabled(enable);
        this.radioInhibitionPriority.setEnabled(enable);
        if (enable) {
            this.textInhibitionPeriod.setEnabled(this.radioInhibitionPeriod.getSelection());
        } else {
            this.textInhibitionPeriod.setEnabled(false);
        }
        if (enable) {
            this.textInhibitionFrequency.setEnabled(this.radioInhibitionFrequency.getSelection());
        } else {
            this.textInhibitionFrequency.setEnabled(false);
        }
    }
    
    /**
     * 
     * ٥ΤΥݥåȤEnabledꤷޤ
     * 
     * @param enable ٥ΥåܥåEnabled
     * @param checkEventNormal Τåܥå
     * @param comboEventNormal ξ֥ܥܥå
     * @param checkEventInhibition åܥå
     * @param comboEventInhibition ξ֥ܥܥå
     * @param checkMail åܥå
     * @param textMail ƥȥܥå
     */
    private void setEnabledForEvents(boolean enable, 
    		Button checkEventNormal, 
    		Combo comboEventNormal,
    		Button checkEventInhibition, 
    		Combo comboEventInhibition,
    		Button checkMail,
    		Text textMail
    		) {

    	checkEventNormal.setEnabled(enable);
    	
        if (enable) {
        	this.setEnabledForEvent(checkEventNormal.getSelection(), comboEventNormal, checkEventInhibition, comboEventInhibition, checkMail, textMail);
        }
        else{
        	this.setEnabledForEvent(false, comboEventNormal, checkEventInhibition, comboEventInhibition, checkMail, textMail);
        }
    }
    
    /**
     * 
     * ƥ٥ΤΥݥåȤEnabledꤷޤ
     *
     * @param enable ΤåܥåEnabled
     * @param comboEventNormal ξ֥ܥܥå
     * @param checkEventInhibition åܥå
     * @param comboEventInhibition ξ֥ܥܥå
     * @param checkMail åܥå
     * @param textMail ƥȥܥå
     */
    private void setEnabledForEvent(boolean enable, 
    		Combo comboEventNormal,
    		Button checkEventInhibition, 
    		Combo comboEventInhibition,
    		Button checkMail,
    		Text textMail
    		) {

        if (enable) {
        	comboEventNormal.setEnabled(true);
        	
        	checkEventInhibition.setEnabled(true);
        	comboEventInhibition.setEnabled(checkEventInhibition.getSelection());
        	
        	checkMail.setEnabled(true);
        	textMail.setEnabled(checkMail.getSelection());
        }
        else{
        	comboEventNormal.setEnabled(false);
        	
        	checkEventInhibition.setEnabled(false);
        	comboEventInhibition.setEnabled(false);
        	
        	checkMail.setEnabled(false);
        	textMail.setEnabled(false);
        }
    }

    /**
     * ̵ͤξꤷޤ
     *  
     */
    private void setValidateResult(String id, String message) {

        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
    
    /**
     * ܥޤ
     * 
     * @param parent ܥСݥå
     */
    protected void createButtonsForButtonBar(Composite parent) {
    	
        if(!this.referenceFlg){
        	super.createButtonsForButtonBar(parent);
        }
        else{
        	// Ĥܥ
            this.createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CLOSE_LABEL, false);
        }
    }
}