/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.priority.action.ModifyPriorityJudgment;
import com.clustercontrol.priority.bean.PriorityJudgmentInfo;
import com.clustercontrol.priority.composite.PatternComposite;
import com.clustercontrol.priority.composite.PatternLabelComposite;
import com.clustercontrol.util.Messages;

/**
 * Ƚκѹ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class PriorityJudgmentDialog extends CommonDialog {
	PriorityJudgmentInfo priorityInfo = null;

    /** ѹѥȽ̥ե饰 */
    protected boolean isModifyDialog = false;
    
    /** ͤݻ륪֥ */
    private ValidateResult validateResult = null;
    
    protected PatternComposite pattern01 = null;
    protected PatternComposite pattern02 = null;
    protected PatternComposite pattern03 = null;
    protected PatternComposite pattern04 = null;
    protected PatternComposite pattern05 = null;
    protected PatternComposite pattern06 = null;
    protected PatternComposite pattern07 = null;
    protected PatternComposite pattern08 = null;
    protected PatternComposite pattern09 = null;
    protected PatternComposite pattern10 = null;
    protected PatternComposite pattern11 = null;
    protected PatternComposite pattern12 = null;
    protected PatternComposite pattern13 = null;
    protected PatternComposite pattern14 = null;
    protected PatternComposite pattern15 = null;
    
    /**
     * ꤷΥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param judgmentId
     *            ȽID
     * @param isModifyDialog
     *            ѹѥȤѤϡtrue
     */
    public PriorityJudgmentDialog(Shell parent, boolean isModifyDialog) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);

        this.isModifyDialog = isModifyDialog;
    }
    
    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages
                .getString("dialog.priority.create.modify"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 11;
        parent.setLayout(layout);

        /*
         * ȽȤ߹碌
         */
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("combination.definition.of.judgments") + " : ");

        Group group = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.numColumns = 1;
        group.setLayout(layout);
        
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        group.setLayoutData(gridData);
        
        //ȽȤ߹碌Ƚ
        PatternLabelComposite patternLabel = new PatternLabelComposite(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        patternLabel.setLayoutData(gridData);
        
		//      | ٹ |  | 
        // ѥ 1:  | ߡ | ߡ | ߡ
		// ѥ 2:  | ߡ | ߡ | 
		// ѥ 3:  |  | ߡ | ߡ
        // ѥ 4:  |  | ߡ |  
		// ѥ 5: ߡ |  | ߡ | ߡ
		// ѥ 6: ߡ |  | ߡ |  
		// ѥ 7:  | ߡ |  | ߡ
		// ѥ 8:  | ߡ |  |  
		// ѥ 9:  |  |  | ߡ 
		// ѥ10:  |  |  |  
		// ѥ11: ߡ |  |  | ߡ 
		// ѥ12: ߡ |  |  |  
		// ѥ13: ߡ | ߡ |  | ߡ 
		// ѥ14: ߡ | ߡ |  | 
		// ѥ15: ߡ | ߡ | ߡ |  
        
        //ѥ1
        pattern01 = new PatternComposite(group, SWT.NONE, true, false, false, false, this.priorityInfo.getPattern_01());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern01.setLayoutData(gridData);
        
        //ѥ2
        pattern02 = new PatternComposite(group, SWT.NONE, true, false, false, true, this.priorityInfo.getPattern_02());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern02.setLayoutData(gridData);
        
        //ѥ3
        pattern03 = new PatternComposite(group, SWT.NONE, true, true, false, false, this.priorityInfo.getPattern_03());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern03.setLayoutData(gridData);
        
        //ѥ4
        pattern04 = new PatternComposite(group, SWT.NONE, true, true, false, true, this.priorityInfo.getPattern_04());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern04.setLayoutData(gridData);
        
        //ѥ5
        pattern05 = new PatternComposite(group, SWT.NONE, false, true, false, false, this.priorityInfo.getPattern_05());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern05.setLayoutData(gridData);
        
        //ѥ6
        pattern06 = new PatternComposite(group, SWT.NONE, false, true, false, true, this.priorityInfo.getPattern_06());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern06.setLayoutData(gridData);
        
        //ѥ7
        pattern07 = new PatternComposite(group, SWT.NONE, true, false, true, false, this.priorityInfo.getPattern_07());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern07.setLayoutData(gridData);
        
        //ѥ8
        pattern08 = new PatternComposite(group, SWT.NONE, true, false, true, true, this.priorityInfo.getPattern_08());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern08.setLayoutData(gridData);
        
        //ѥ9
        pattern09 = new PatternComposite(group, SWT.NONE, true, true, true, false, this.priorityInfo.getPattern_09());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern09.setLayoutData(gridData);
        
        //ѥ10
        pattern10 = new PatternComposite(group, SWT.NONE, true, true, true, true, this.priorityInfo.getPattern_10());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern10.setLayoutData(gridData);
        
        //ѥ11
        pattern11 = new PatternComposite(group, SWT.NONE, false, true, true, false, this.priorityInfo.getPattern_11());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern11.setLayoutData(gridData);
        
        //ѥ12
        pattern12 = new PatternComposite(group, SWT.NONE, false, true, true, true, this.priorityInfo.getPattern_12());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern12.setLayoutData(gridData);
        
        //ѥ13
        pattern13 = new PatternComposite(group, SWT.NONE, false, false, true, false, this.priorityInfo.getPattern_13());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern13.setLayoutData(gridData);
        
        //ѥ14
        pattern14 = new PatternComposite(group, SWT.NONE, false, false, true, true, this.priorityInfo.getPattern_14());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern14.setLayoutData(gridData);
        
        //ѥ15
        pattern15 = new PatternComposite(group, SWT.NONE, false, false, false, true, this.priorityInfo.getPattern_15());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern15.setLayoutData(gridData);
        

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        // 
        this.priorityInfo = this.createInputData();

        if (this.priorityInfo != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }
    

    /**
     * ͤѤξޤ
     * 
     * @return ͤݻȽ
     */
    protected PriorityJudgmentInfo createInputData() {

    	//ƥѥν٤
    	this.priorityInfo.setPattern_01(new Integer(pattern01.getPriority()));
    	this.priorityInfo.setPattern_02(new Integer(pattern02.getPriority()));
    	this.priorityInfo.setPattern_03(new Integer(pattern03.getPriority()));
    	this.priorityInfo.setPattern_04(new Integer(pattern04.getPriority()));
    	this.priorityInfo.setPattern_05(new Integer(pattern05.getPriority()));
    	this.priorityInfo.setPattern_06(new Integer(pattern06.getPriority()));
    	this.priorityInfo.setPattern_07(new Integer(pattern07.getPriority()));
    	this.priorityInfo.setPattern_08(new Integer(pattern08.getPriority()));
    	this.priorityInfo.setPattern_09(new Integer(pattern09.getPriority()));
    	this.priorityInfo.setPattern_10(new Integer(pattern10.getPriority()));
    	this.priorityInfo.setPattern_11(new Integer(pattern11.getPriority()));
    	this.priorityInfo.setPattern_12(new Integer(pattern12.getPriority()));
    	this.priorityInfo.setPattern_13(new Integer(pattern13.getPriority()));
    	this.priorityInfo.setPattern_14(new Integer(pattern14.getPriority()));
    	this.priorityInfo.setPattern_15(new Integer(pattern15.getPriority()));
    	
        return this.priorityInfo;
    }

    /**
     * ѹѥʤΤ֤ޤ
     * 
     * @return ѹѥξ硢true
     */
    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    /**
     * ͤݻǡǥޤ
     * 
     * @return ǡǥ
     */
    public PriorityJudgmentInfo getInputData() {
        return this.priorityInfo;
    }
    
    /**
     * ͤݻǡǥꤷޤ
     * 
     * @return ǡǥ
     */
    public void setInputData(PriorityJudgmentInfo priorityInfo) {
        this.priorityInfo = priorityInfo;
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        if (isModifyDialog()) {
            return Messages.getString("modify");
        } else {
            return Messages.getString("register");
        }
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

	@Override
	protected void okPressed() {
        ValidateResult result = this.validate();

        if (result == null || result.isValid()) {
        	//ѹ
        	if(this.isModifyDialog){
            	if (new ModifyPriorityJudgment().edit(this.priorityInfo)) {
                    // 
                    MessageBox box = new MessageBox(this.getShell(), SWT.ICON_INFORMATION);
                    box.setText(Messages.getString("successful"));
                    box.setMessage(Messages.getString("message.priority.judgment.1"));
                    box.open();
                } else {
                    // 
                    MessageBox box = new MessageBox(this.getShell(), SWT.ICON_ERROR);
                    box.setText(Messages.getString("failed"));
                    box.setMessage(Messages.getString("message.priority.judgment.2"));
                    box.open();
                }
        		super.okPressed();
        	}
        	else{
        		
        	}
        } else {
            this.displayError(result);
        }
	}
}